<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdItmWhsCollection StructType
 * @subpackage Structs
 */
class UpdItmWhsCollection extends AbstractStructBase
{
    /**
     * The UpdItmWhsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UpdItmWhsItem[]
     */
    public $UpdItmWhsItem;
    /**
     * The maxRecords
     * Meta information extracted from the WSDL
     * - default: 100
     * - use: optional
     * @var int
     */
    public $maxRecords;
    /**
     * Constructor method for UpdItmWhsCollection
     * @uses UpdItmWhsCollection::setUpdItmWhsItem()
     * @uses UpdItmWhsCollection::setMaxRecords()
     * @param \StructType\UpdItmWhsItem[] $updItmWhsItem
     * @param int $maxRecords
     */
    public function __construct(array $updItmWhsItem = array(), $maxRecords = 100)
    {
        $this
            ->setUpdItmWhsItem($updItmWhsItem)
            ->setMaxRecords($maxRecords);
    }
    /**
     * Get UpdItmWhsItem value
     * @return \StructType\UpdItmWhsItem[]|null
     */
    public function getUpdItmWhsItem()
    {
        return $this->UpdItmWhsItem;
    }
    /**
     * This method is responsible for validating the values passed to the setUpdItmWhsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUpdItmWhsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUpdItmWhsItemForArrayConstraintsFromSetUpdItmWhsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $updItmWhsCollectionUpdItmWhsItemItem) {
            // validation for constraint: itemType
            if (!$updItmWhsCollectionUpdItmWhsItemItem instanceof \StructType\UpdItmWhsItem) {
                $invalidValues[] = is_object($updItmWhsCollectionUpdItmWhsItemItem) ? get_class($updItmWhsCollectionUpdItmWhsItemItem) : sprintf('%s(%s)', gettype($updItmWhsCollectionUpdItmWhsItemItem), var_export($updItmWhsCollectionUpdItmWhsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UpdItmWhsItem property can only contain items of type \StructType\UpdItmWhsItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UpdItmWhsItem value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdItmWhsItem[] $updItmWhsItem
     * @return \StructType\UpdItmWhsCollection
     */
    public function setUpdItmWhsItem(array $updItmWhsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($updItmWhsItemArrayErrorMessage = self::validateUpdItmWhsItemForArrayConstraintsFromSetUpdItmWhsItem($updItmWhsItem))) {
            throw new \InvalidArgumentException($updItmWhsItemArrayErrorMessage, __LINE__);
        }
        $this->UpdItmWhsItem = $updItmWhsItem;
        return $this;
    }
    /**
     * Add item to UpdItmWhsItem value
     * @throws \InvalidArgumentException
     * @param \StructType\UpdItmWhsItem $item
     * @return \StructType\UpdItmWhsCollection
     */
    public function addToUpdItmWhsItem(\StructType\UpdItmWhsItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UpdItmWhsItem) {
            throw new \InvalidArgumentException(sprintf('The UpdItmWhsItem property can only contain items of type \StructType\UpdItmWhsItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UpdItmWhsItem[] = $item;
        return $this;
    }
    /**
     * Get maxRecords value
     * @return int|null
     */
    public function getMaxRecords()
    {
        return $this->maxRecords;
    }
    /**
     * Set maxRecords value
     * @param int $maxRecords
     * @return \StructType\UpdItmWhsCollection
     */
    public function setMaxRecords($maxRecords = 100)
    {
        // validation for constraint: int
        if (!is_null($maxRecords) && !(is_int($maxRecords) || ctype_digit($maxRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxRecords, true), gettype($maxRecords)), __LINE__);
        }
        $this->maxRecords = $maxRecords;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdItmWhsCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
