<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lws StructType
 * @subpackage Structs
 */
class Lws extends AbstractStructBase
{
    /**
     * The company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $company;
    /**
     * The division
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $division;
    /**
     * Constructor method for lws
     * @uses Lws::setCompany()
     * @uses Lws::setDivision()
     * @param int $company
     * @param string $division
     */
    public function __construct($company = null, $division = null)
    {
        $this
            ->setCompany($company)
            ->setDivision($division);
    }
    /**
     * Get company value
     * @return int|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param int $company
     * @return \StructType\Lws
     */
    public function setCompany($company = null)
    {
        // validation for constraint: int
        if (!is_null($company) && !(is_int($company) || ctype_digit($company))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get division value
     * @return string|null
     */
    public function getDivision()
    {
        return $this->division;
    }
    /**
     * Set division value
     * @param string $division
     * @return \StructType\Lws
     */
    public function setDivision($division = null)
    {
        // validation for constraint: string
        if (!is_null($division) && !is_string($division)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($division, true), gettype($division)), __LINE__);
        }
        $this->division = $division;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Lws
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
