<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upd ServiceType
 * @subpackage Services
 */
class Upd extends AbstractSoapClientBase
{
    /**
     * Sets the Lws SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Lws $lws
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderLws(\StructType\Lws $lws, $nameSpace = 'http://lawson.com/ws/credentials', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'lws', $lws, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdItmWhs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: lws
     * - SOAPHeaderNamespaces: http://lawson.com/ws/credentials
     * - SOAPHeaderTypes: \StructType\Lws
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdItmWhsCollection $updItmWhs
     * @return \StructType\UpdItmWhsResponseCollection|bool
     */
    public function UpdItmWhs(\StructType\UpdItmWhsCollection $updItmWhs)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdItmWhs($updItmWhs));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdItmWhsResponseCollection
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
