<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseDetails StructType
 * @subpackage Structs
 */
class WarehouseDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Default;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The WarehouseWarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WarehouseWarehouseID;
    /**
     * The DefaultReceiptTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DefaultReceiptTo;
    /**
     * The DefaultIssueFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DefaultIssueFrom;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The InventoryAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryAccount;
    /**
     * The InventorySub
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventorySub;
    /**
     * The OverrideProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverrideProductManager;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProductWorkgroup;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProductManager;
    /**
     * The OverrideStdCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverrideStdCost;
    /**
     * The PriceOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PriceOverride;
    /**
     * The QtyOnHand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnHand;
    /**
     * The OverridePreferredVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverridePreferredVendor;
    /**
     * The PreferredVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PreferredVendor;
    /**
     * The OverrideReplenishmentSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverrideReplenishmentSettings;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Seasonality;
    /**
     * The ReplenishmentSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReplenishmentSource;
    /**
     * The ReplenishmentWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReplenishmentWarehouse;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Override;
    /**
     * The ServiceLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ServiceLevel;
    /**
     * The LastForecastDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LastForecastDate;
    /**
     * The DailyDemandForecast
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DailyDemandForecast;
    /**
     * The DailyDemandForecastErrorSTDEV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DailyDemandForecastErrorSTDEV;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarehouseDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for WarehouseDetails
     * @uses WarehouseDetails::setDisplayName()
     * @uses WarehouseDetails::setDefault()
     * @uses WarehouseDetails::setWarehouse()
     * @uses WarehouseDetails::setWarehouseWarehouseID()
     * @uses WarehouseDetails::setDefaultReceiptTo()
     * @uses WarehouseDetails::setDefaultIssueFrom()
     * @uses WarehouseDetails::setStatus()
     * @uses WarehouseDetails::setInventoryAccount()
     * @uses WarehouseDetails::setInventorySub()
     * @uses WarehouseDetails::setOverrideProductManager()
     * @uses WarehouseDetails::setProductWorkgroup()
     * @uses WarehouseDetails::setProductManager()
     * @uses WarehouseDetails::setOverrideStdCost()
     * @uses WarehouseDetails::setPriceOverride()
     * @uses WarehouseDetails::setQtyOnHand()
     * @uses WarehouseDetails::setOverridePreferredVendor()
     * @uses WarehouseDetails::setPreferredVendor()
     * @uses WarehouseDetails::setOverrideReplenishmentSettings()
     * @uses WarehouseDetails::setSeasonality()
     * @uses WarehouseDetails::setReplenishmentSource()
     * @uses WarehouseDetails::setReplenishmentWarehouse()
     * @uses WarehouseDetails::setOverride()
     * @uses WarehouseDetails::setServiceLevel()
     * @uses WarehouseDetails::setLastForecastDate()
     * @uses WarehouseDetails::setDailyDemandForecast()
     * @uses WarehouseDetails::setDailyDemandForecastErrorSTDEV()
     * @uses WarehouseDetails::setNoteText()
     * @uses WarehouseDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $default
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $warehouseWarehouseID
     * @param \StructType\Field $defaultReceiptTo
     * @param \StructType\Field $defaultIssueFrom
     * @param \StructType\Field $status
     * @param \StructType\Field $inventoryAccount
     * @param \StructType\Field $inventorySub
     * @param \StructType\Field $overrideProductManager
     * @param \StructType\Field $productWorkgroup
     * @param \StructType\Field $productManager
     * @param \StructType\Field $overrideStdCost
     * @param \StructType\Field $priceOverride
     * @param \StructType\Field $qtyOnHand
     * @param \StructType\Field $overridePreferredVendor
     * @param \StructType\Field $preferredVendor
     * @param \StructType\Field $overrideReplenishmentSettings
     * @param \StructType\Field $seasonality
     * @param \StructType\Field $replenishmentSource
     * @param \StructType\Field $replenishmentWarehouse
     * @param \StructType\Field $override
     * @param \StructType\Field $serviceLevel
     * @param \StructType\Field $lastForecastDate
     * @param \StructType\Field $dailyDemandForecast
     * @param \StructType\Field $dailyDemandForecastErrorSTDEV
     * @param \StructType\Field $noteText
     * @param \StructType\WarehouseDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $default = null, \StructType\Field $warehouse = null, \StructType\Field $warehouseWarehouseID = null, \StructType\Field $defaultReceiptTo = null, \StructType\Field $defaultIssueFrom = null, \StructType\Field $status = null, \StructType\Field $inventoryAccount = null, \StructType\Field $inventorySub = null, \StructType\Field $overrideProductManager = null, \StructType\Field $productWorkgroup = null, \StructType\Field $productManager = null, \StructType\Field $overrideStdCost = null, \StructType\Field $priceOverride = null, \StructType\Field $qtyOnHand = null, \StructType\Field $overridePreferredVendor = null, \StructType\Field $preferredVendor = null, \StructType\Field $overrideReplenishmentSettings = null, \StructType\Field $seasonality = null, \StructType\Field $replenishmentSource = null, \StructType\Field $replenishmentWarehouse = null, \StructType\Field $override = null, \StructType\Field $serviceLevel = null, \StructType\Field $lastForecastDate = null, \StructType\Field $dailyDemandForecast = null, \StructType\Field $dailyDemandForecastErrorSTDEV = null, \StructType\Field $noteText = null, \StructType\WarehouseDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDefault($default)
            ->setWarehouse($warehouse)
            ->setWarehouseWarehouseID($warehouseWarehouseID)
            ->setDefaultReceiptTo($defaultReceiptTo)
            ->setDefaultIssueFrom($defaultIssueFrom)
            ->setStatus($status)
            ->setInventoryAccount($inventoryAccount)
            ->setInventorySub($inventorySub)
            ->setOverrideProductManager($overrideProductManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setProductManager($productManager)
            ->setOverrideStdCost($overrideStdCost)
            ->setPriceOverride($priceOverride)
            ->setQtyOnHand($qtyOnHand)
            ->setOverridePreferredVendor($overridePreferredVendor)
            ->setPreferredVendor($preferredVendor)
            ->setOverrideReplenishmentSettings($overrideReplenishmentSettings)
            ->setSeasonality($seasonality)
            ->setReplenishmentSource($replenishmentSource)
            ->setReplenishmentWarehouse($replenishmentWarehouse)
            ->setOverride($override)
            ->setServiceLevel($serviceLevel)
            ->setLastForecastDate($lastForecastDate)
            ->setDailyDemandForecast($dailyDemandForecast)
            ->setDailyDemandForecastErrorSTDEV($dailyDemandForecastErrorSTDEV)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\WarehouseDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Default value
     * @return \StructType\Field|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \StructType\Field $default
     * @return \StructType\WarehouseDetails
     */
    public function setDefault(\StructType\Field $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\WarehouseDetails
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get WarehouseWarehouseID value
     * @return \StructType\Field|null
     */
    public function getWarehouseWarehouseID()
    {
        return $this->WarehouseWarehouseID;
    }
    /**
     * Set WarehouseWarehouseID value
     * @param \StructType\Field $warehouseWarehouseID
     * @return \StructType\WarehouseDetails
     */
    public function setWarehouseWarehouseID(\StructType\Field $warehouseWarehouseID = null)
    {
        $this->WarehouseWarehouseID = $warehouseWarehouseID;
        return $this;
    }
    /**
     * Get DefaultReceiptTo value
     * @return \StructType\Field|null
     */
    public function getDefaultReceiptTo()
    {
        return $this->DefaultReceiptTo;
    }
    /**
     * Set DefaultReceiptTo value
     * @param \StructType\Field $defaultReceiptTo
     * @return \StructType\WarehouseDetails
     */
    public function setDefaultReceiptTo(\StructType\Field $defaultReceiptTo = null)
    {
        $this->DefaultReceiptTo = $defaultReceiptTo;
        return $this;
    }
    /**
     * Get DefaultIssueFrom value
     * @return \StructType\Field|null
     */
    public function getDefaultIssueFrom()
    {
        return $this->DefaultIssueFrom;
    }
    /**
     * Set DefaultIssueFrom value
     * @param \StructType\Field $defaultIssueFrom
     * @return \StructType\WarehouseDetails
     */
    public function setDefaultIssueFrom(\StructType\Field $defaultIssueFrom = null)
    {
        $this->DefaultIssueFrom = $defaultIssueFrom;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\WarehouseDetails
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get InventoryAccount value
     * @return \StructType\Field|null
     */
    public function getInventoryAccount()
    {
        return $this->InventoryAccount;
    }
    /**
     * Set InventoryAccount value
     * @param \StructType\Field $inventoryAccount
     * @return \StructType\WarehouseDetails
     */
    public function setInventoryAccount(\StructType\Field $inventoryAccount = null)
    {
        $this->InventoryAccount = $inventoryAccount;
        return $this;
    }
    /**
     * Get InventorySub value
     * @return \StructType\Field|null
     */
    public function getInventorySub()
    {
        return $this->InventorySub;
    }
    /**
     * Set InventorySub value
     * @param \StructType\Field $inventorySub
     * @return \StructType\WarehouseDetails
     */
    public function setInventorySub(\StructType\Field $inventorySub = null)
    {
        $this->InventorySub = $inventorySub;
        return $this;
    }
    /**
     * Get OverrideProductManager value
     * @return \StructType\Field|null
     */
    public function getOverrideProductManager()
    {
        return $this->OverrideProductManager;
    }
    /**
     * Set OverrideProductManager value
     * @param \StructType\Field $overrideProductManager
     * @return \StructType\WarehouseDetails
     */
    public function setOverrideProductManager(\StructType\Field $overrideProductManager = null)
    {
        $this->OverrideProductManager = $overrideProductManager;
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * @return \StructType\Field|null
     */
    public function getProductWorkgroup()
    {
        return $this->ProductWorkgroup;
    }
    /**
     * Set ProductWorkgroup value
     * @param \StructType\Field $productWorkgroup
     * @return \StructType\WarehouseDetails
     */
    public function setProductWorkgroup(\StructType\Field $productWorkgroup = null)
    {
        $this->ProductWorkgroup = $productWorkgroup;
        return $this;
    }
    /**
     * Get ProductManager value
     * @return \StructType\Field|null
     */
    public function getProductManager()
    {
        return $this->ProductManager;
    }
    /**
     * Set ProductManager value
     * @param \StructType\Field $productManager
     * @return \StructType\WarehouseDetails
     */
    public function setProductManager(\StructType\Field $productManager = null)
    {
        $this->ProductManager = $productManager;
        return $this;
    }
    /**
     * Get OverrideStdCost value
     * @return \StructType\Field|null
     */
    public function getOverrideStdCost()
    {
        return $this->OverrideStdCost;
    }
    /**
     * Set OverrideStdCost value
     * @param \StructType\Field $overrideStdCost
     * @return \StructType\WarehouseDetails
     */
    public function setOverrideStdCost(\StructType\Field $overrideStdCost = null)
    {
        $this->OverrideStdCost = $overrideStdCost;
        return $this;
    }
    /**
     * Get PriceOverride value
     * @return \StructType\Field|null
     */
    public function getPriceOverride()
    {
        return $this->PriceOverride;
    }
    /**
     * Set PriceOverride value
     * @param \StructType\Field $priceOverride
     * @return \StructType\WarehouseDetails
     */
    public function setPriceOverride(\StructType\Field $priceOverride = null)
    {
        $this->PriceOverride = $priceOverride;
        return $this;
    }
    /**
     * Get QtyOnHand value
     * @return \StructType\Field|null
     */
    public function getQtyOnHand()
    {
        return $this->QtyOnHand;
    }
    /**
     * Set QtyOnHand value
     * @param \StructType\Field $qtyOnHand
     * @return \StructType\WarehouseDetails
     */
    public function setQtyOnHand(\StructType\Field $qtyOnHand = null)
    {
        $this->QtyOnHand = $qtyOnHand;
        return $this;
    }
    /**
     * Get OverridePreferredVendor value
     * @return \StructType\Field|null
     */
    public function getOverridePreferredVendor()
    {
        return $this->OverridePreferredVendor;
    }
    /**
     * Set OverridePreferredVendor value
     * @param \StructType\Field $overridePreferredVendor
     * @return \StructType\WarehouseDetails
     */
    public function setOverridePreferredVendor(\StructType\Field $overridePreferredVendor = null)
    {
        $this->OverridePreferredVendor = $overridePreferredVendor;
        return $this;
    }
    /**
     * Get PreferredVendor value
     * @return \StructType\Field|null
     */
    public function getPreferredVendor()
    {
        return $this->PreferredVendor;
    }
    /**
     * Set PreferredVendor value
     * @param \StructType\Field $preferredVendor
     * @return \StructType\WarehouseDetails
     */
    public function setPreferredVendor(\StructType\Field $preferredVendor = null)
    {
        $this->PreferredVendor = $preferredVendor;
        return $this;
    }
    /**
     * Get OverrideReplenishmentSettings value
     * @return \StructType\Field|null
     */
    public function getOverrideReplenishmentSettings()
    {
        return $this->OverrideReplenishmentSettings;
    }
    /**
     * Set OverrideReplenishmentSettings value
     * @param \StructType\Field $overrideReplenishmentSettings
     * @return \StructType\WarehouseDetails
     */
    public function setOverrideReplenishmentSettings(\StructType\Field $overrideReplenishmentSettings = null)
    {
        $this->OverrideReplenishmentSettings = $overrideReplenishmentSettings;
        return $this;
    }
    /**
     * Get Seasonality value
     * @return \StructType\Field|null
     */
    public function getSeasonality()
    {
        return $this->Seasonality;
    }
    /**
     * Set Seasonality value
     * @param \StructType\Field $seasonality
     * @return \StructType\WarehouseDetails
     */
    public function setSeasonality(\StructType\Field $seasonality = null)
    {
        $this->Seasonality = $seasonality;
        return $this;
    }
    /**
     * Get ReplenishmentSource value
     * @return \StructType\Field|null
     */
    public function getReplenishmentSource()
    {
        return $this->ReplenishmentSource;
    }
    /**
     * Set ReplenishmentSource value
     * @param \StructType\Field $replenishmentSource
     * @return \StructType\WarehouseDetails
     */
    public function setReplenishmentSource(\StructType\Field $replenishmentSource = null)
    {
        $this->ReplenishmentSource = $replenishmentSource;
        return $this;
    }
    /**
     * Get ReplenishmentWarehouse value
     * @return \StructType\Field|null
     */
    public function getReplenishmentWarehouse()
    {
        return $this->ReplenishmentWarehouse;
    }
    /**
     * Set ReplenishmentWarehouse value
     * @param \StructType\Field $replenishmentWarehouse
     * @return \StructType\WarehouseDetails
     */
    public function setReplenishmentWarehouse(\StructType\Field $replenishmentWarehouse = null)
    {
        $this->ReplenishmentWarehouse = $replenishmentWarehouse;
        return $this;
    }
    /**
     * Get Override value
     * @return \StructType\Field|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param \StructType\Field $override
     * @return \StructType\WarehouseDetails
     */
    public function setOverride(\StructType\Field $override = null)
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Get ServiceLevel value
     * @return \StructType\Field|null
     */
    public function getServiceLevel()
    {
        return $this->ServiceLevel;
    }
    /**
     * Set ServiceLevel value
     * @param \StructType\Field $serviceLevel
     * @return \StructType\WarehouseDetails
     */
    public function setServiceLevel(\StructType\Field $serviceLevel = null)
    {
        $this->ServiceLevel = $serviceLevel;
        return $this;
    }
    /**
     * Get LastForecastDate value
     * @return \StructType\Field|null
     */
    public function getLastForecastDate()
    {
        return $this->LastForecastDate;
    }
    /**
     * Set LastForecastDate value
     * @param \StructType\Field $lastForecastDate
     * @return \StructType\WarehouseDetails
     */
    public function setLastForecastDate(\StructType\Field $lastForecastDate = null)
    {
        $this->LastForecastDate = $lastForecastDate;
        return $this;
    }
    /**
     * Get DailyDemandForecast value
     * @return \StructType\Field|null
     */
    public function getDailyDemandForecast()
    {
        return $this->DailyDemandForecast;
    }
    /**
     * Set DailyDemandForecast value
     * @param \StructType\Field $dailyDemandForecast
     * @return \StructType\WarehouseDetails
     */
    public function setDailyDemandForecast(\StructType\Field $dailyDemandForecast = null)
    {
        $this->DailyDemandForecast = $dailyDemandForecast;
        return $this;
    }
    /**
     * Get DailyDemandForecastErrorSTDEV value
     * @return \StructType\Field|null
     */
    public function getDailyDemandForecastErrorSTDEV()
    {
        return $this->DailyDemandForecastErrorSTDEV;
    }
    /**
     * Set DailyDemandForecastErrorSTDEV value
     * @param \StructType\Field $dailyDemandForecastErrorSTDEV
     * @return \StructType\WarehouseDetails
     */
    public function setDailyDemandForecastErrorSTDEV(\StructType\Field $dailyDemandForecastErrorSTDEV = null)
    {
        $this->DailyDemandForecastErrorSTDEV = $dailyDemandForecastErrorSTDEV;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\WarehouseDetails
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\WarehouseDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\WarehouseDetailsServiceCommands $serviceCommands
     * @return \StructType\WarehouseDetails
     */
    public function setServiceCommands(\StructType\WarehouseDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarehouseDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
