<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subitems StructType
 * @subpackage Structs
 */
class Subitems extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The SegmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SegmentID;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Value;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SubitemsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Subitems
     * @uses Subitems::setDisplayName()
     * @uses Subitems::setSegmentID()
     * @uses Subitems::setValue()
     * @uses Subitems::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $segmentID
     * @param \StructType\Field $value
     * @param \StructType\SubitemsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $segmentID = null, \StructType\Field $value = null, \StructType\SubitemsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setSegmentID($segmentID)
            ->setValue($value)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Subitems
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get SegmentID value
     * @return \StructType\Field|null
     */
    public function getSegmentID()
    {
        return $this->SegmentID;
    }
    /**
     * Set SegmentID value
     * @param \StructType\Field $segmentID
     * @return \StructType\Subitems
     */
    public function setSegmentID(\StructType\Field $segmentID = null)
    {
        $this->SegmentID = $segmentID;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\Field|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \StructType\Field $value
     * @return \StructType\Subitems
     */
    public function setValue(\StructType\Field $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SubitemsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SubitemsServiceCommands $serviceCommands
     * @return \StructType\Subitems
     */
    public function setServiceCommands(\StructType\SubitemsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subitems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
