<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockItemSummary StructType
 * @subpackage Structs
 */
class StockItemSummary extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The ItemStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemStatus;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The ProductWorkgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProductWorkgroup;
    /**
     * The ProductManager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProductManager;
    /**
     * The ChkEquipmentManagement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ChkEquipmentManagement;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The AddPopUpNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AddPopUpNote;
    /**
     * The PopUpNoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PopUpNoteText;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockItemSummaryServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for StockItemSummary
     * @uses StockItemSummary::setDisplayName()
     * @uses StockItemSummary::setInventoryID()
     * @uses StockItemSummary::setItemStatus()
     * @uses StockItemSummary::setDescription()
     * @uses StockItemSummary::setProductWorkgroup()
     * @uses StockItemSummary::setProductManager()
     * @uses StockItemSummary::setChkEquipmentManagement()
     * @uses StockItemSummary::setNoteText()
     * @uses StockItemSummary::setAddPopUpNote()
     * @uses StockItemSummary::setPopUpNoteText()
     * @uses StockItemSummary::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $itemStatus
     * @param \StructType\Field $description
     * @param \StructType\Field $productWorkgroup
     * @param \StructType\Field $productManager
     * @param \StructType\Field $chkEquipmentManagement
     * @param \StructType\Field $noteText
     * @param \StructType\Field $addPopUpNote
     * @param \StructType\Field $popUpNoteText
     * @param \StructType\StockItemSummaryServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $inventoryID = null, \StructType\Field $itemStatus = null, \StructType\Field $description = null, \StructType\Field $productWorkgroup = null, \StructType\Field $productManager = null, \StructType\Field $chkEquipmentManagement = null, \StructType\Field $noteText = null, \StructType\Field $addPopUpNote = null, \StructType\Field $popUpNoteText = null, \StructType\StockItemSummaryServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setInventoryID($inventoryID)
            ->setItemStatus($itemStatus)
            ->setDescription($description)
            ->setProductWorkgroup($productWorkgroup)
            ->setProductManager($productManager)
            ->setChkEquipmentManagement($chkEquipmentManagement)
            ->setNoteText($noteText)
            ->setAddPopUpNote($addPopUpNote)
            ->setPopUpNoteText($popUpNoteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\StockItemSummary
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\StockItemSummary
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get ItemStatus value
     * @return \StructType\Field|null
     */
    public function getItemStatus()
    {
        return $this->ItemStatus;
    }
    /**
     * Set ItemStatus value
     * @param \StructType\Field $itemStatus
     * @return \StructType\StockItemSummary
     */
    public function setItemStatus(\StructType\Field $itemStatus = null)
    {
        $this->ItemStatus = $itemStatus;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\StockItemSummary
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * @return \StructType\Field|null
     */
    public function getProductWorkgroup()
    {
        return $this->ProductWorkgroup;
    }
    /**
     * Set ProductWorkgroup value
     * @param \StructType\Field $productWorkgroup
     * @return \StructType\StockItemSummary
     */
    public function setProductWorkgroup(\StructType\Field $productWorkgroup = null)
    {
        $this->ProductWorkgroup = $productWorkgroup;
        return $this;
    }
    /**
     * Get ProductManager value
     * @return \StructType\Field|null
     */
    public function getProductManager()
    {
        return $this->ProductManager;
    }
    /**
     * Set ProductManager value
     * @param \StructType\Field $productManager
     * @return \StructType\StockItemSummary
     */
    public function setProductManager(\StructType\Field $productManager = null)
    {
        $this->ProductManager = $productManager;
        return $this;
    }
    /**
     * Get ChkEquipmentManagement value
     * @return \StructType\Field|null
     */
    public function getChkEquipmentManagement()
    {
        return $this->ChkEquipmentManagement;
    }
    /**
     * Set ChkEquipmentManagement value
     * @param \StructType\Field $chkEquipmentManagement
     * @return \StructType\StockItemSummary
     */
    public function setChkEquipmentManagement(\StructType\Field $chkEquipmentManagement = null)
    {
        $this->ChkEquipmentManagement = $chkEquipmentManagement;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\StockItemSummary
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get AddPopUpNote value
     * @return \StructType\Field|null
     */
    public function getAddPopUpNote()
    {
        return $this->AddPopUpNote;
    }
    /**
     * Set AddPopUpNote value
     * @param \StructType\Field $addPopUpNote
     * @return \StructType\StockItemSummary
     */
    public function setAddPopUpNote(\StructType\Field $addPopUpNote = null)
    {
        $this->AddPopUpNote = $addPopUpNote;
        return $this;
    }
    /**
     * Get PopUpNoteText value
     * @return \StructType\Field|null
     */
    public function getPopUpNoteText()
    {
        return $this->PopUpNoteText;
    }
    /**
     * Set PopUpNoteText value
     * @param \StructType\Field $popUpNoteText
     * @return \StructType\StockItemSummary
     */
    public function setPopUpNoteText(\StructType\Field $popUpNoteText = null)
    {
        $this->PopUpNoteText = $popUpNoteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\StockItemSummaryServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\StockItemSummaryServiceCommands $serviceCommands
     * @return \StructType\StockItemSummary
     */
    public function setServiceCommands(\StructType\StockItemSummaryServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockItemSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
