<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceManagementEquipmentClass StructType
 * @subpackage Structs
 */
class ServiceManagementEquipmentClass extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The EquipmentClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentClass;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Manufacturer;
    /**
     * The ManufacturerModel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ManufacturerModel;
    /**
     * The EquipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentType;
    /**
     * The MemShowComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MemShowComponent;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceManagementEquipmentClassServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ServiceManagementEquipmentClass
     * @uses ServiceManagementEquipmentClass::setDisplayName()
     * @uses ServiceManagementEquipmentClass::setEquipmentClass()
     * @uses ServiceManagementEquipmentClass::setManufacturer()
     * @uses ServiceManagementEquipmentClass::setManufacturerModel()
     * @uses ServiceManagementEquipmentClass::setEquipmentType()
     * @uses ServiceManagementEquipmentClass::setMemShowComponent()
     * @uses ServiceManagementEquipmentClass::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $equipmentClass
     * @param \StructType\Field $manufacturer
     * @param \StructType\Field $manufacturerModel
     * @param \StructType\Field $equipmentType
     * @param \StructType\Field $memShowComponent
     * @param \StructType\ServiceManagementEquipmentClassServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $equipmentClass = null, \StructType\Field $manufacturer = null, \StructType\Field $manufacturerModel = null, \StructType\Field $equipmentType = null, \StructType\Field $memShowComponent = null, \StructType\ServiceManagementEquipmentClassServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEquipmentClass($equipmentClass)
            ->setManufacturer($manufacturer)
            ->setManufacturerModel($manufacturerModel)
            ->setEquipmentType($equipmentType)
            ->setMemShowComponent($memShowComponent)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get EquipmentClass value
     * @return \StructType\Field|null
     */
    public function getEquipmentClass()
    {
        return $this->EquipmentClass;
    }
    /**
     * Set EquipmentClass value
     * @param \StructType\Field $equipmentClass
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setEquipmentClass(\StructType\Field $equipmentClass = null)
    {
        $this->EquipmentClass = $equipmentClass;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return \StructType\Field|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param \StructType\Field $manufacturer
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setManufacturer(\StructType\Field $manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get ManufacturerModel value
     * @return \StructType\Field|null
     */
    public function getManufacturerModel()
    {
        return $this->ManufacturerModel;
    }
    /**
     * Set ManufacturerModel value
     * @param \StructType\Field $manufacturerModel
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setManufacturerModel(\StructType\Field $manufacturerModel = null)
    {
        $this->ManufacturerModel = $manufacturerModel;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return \StructType\Field|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param \StructType\Field $equipmentType
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setEquipmentType(\StructType\Field $equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get MemShowComponent value
     * @return \StructType\Field|null
     */
    public function getMemShowComponent()
    {
        return $this->MemShowComponent;
    }
    /**
     * Set MemShowComponent value
     * @param \StructType\Field $memShowComponent
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setMemShowComponent(\StructType\Field $memShowComponent = null)
    {
        $this->MemShowComponent = $memShowComponent;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ServiceManagementEquipmentClassServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ServiceManagementEquipmentClassServiceCommands $serviceCommands
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public function setServiceCommands(\StructType\ServiceManagementEquipmentClassServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceManagementEquipmentClass
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
