<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplenishmentInfoReplenishmentParameters StructType
 * @subpackage Structs
 */
class ReplenishmentInfoReplenishmentParameters extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ReplClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReplClass;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Seasonality;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Source;
    /**
     * The Method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Method;
    /**
     * The ReplenishmentWarehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReplenishmentWarehouse;
    /**
     * The MaxShelfLifeDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MaxShelfLifeDays;
    /**
     * The LaunchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LaunchDate;
    /**
     * The TerminationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TerminationDate;
    /**
     * The ServiceLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ServiceLevel;
    /**
     * The SafetyStock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SafetyStock;
    /**
     * The ReorderPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReorderPoint;
    /**
     * The MaxQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MaxQty;
    /**
     * The TransferERQ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TransferERQ;
    /**
     * The DemandForecastModel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DemandForecastModel;
    /**
     * The ForecastPeriodType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ForecastPeriodType;
    /**
     * The PeriodsToAnalyze
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PeriodsToAnalyze;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReplenishmentInfoReplenishmentParametersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ReplenishmentInfoReplenishmentParameters
     * @uses ReplenishmentInfoReplenishmentParameters::setDisplayName()
     * @uses ReplenishmentInfoReplenishmentParameters::setReplClass()
     * @uses ReplenishmentInfoReplenishmentParameters::setSeasonality()
     * @uses ReplenishmentInfoReplenishmentParameters::setSource()
     * @uses ReplenishmentInfoReplenishmentParameters::setMethod()
     * @uses ReplenishmentInfoReplenishmentParameters::setReplenishmentWarehouse()
     * @uses ReplenishmentInfoReplenishmentParameters::setMaxShelfLifeDays()
     * @uses ReplenishmentInfoReplenishmentParameters::setLaunchDate()
     * @uses ReplenishmentInfoReplenishmentParameters::setTerminationDate()
     * @uses ReplenishmentInfoReplenishmentParameters::setServiceLevel()
     * @uses ReplenishmentInfoReplenishmentParameters::setSafetyStock()
     * @uses ReplenishmentInfoReplenishmentParameters::setReorderPoint()
     * @uses ReplenishmentInfoReplenishmentParameters::setMaxQty()
     * @uses ReplenishmentInfoReplenishmentParameters::setTransferERQ()
     * @uses ReplenishmentInfoReplenishmentParameters::setDemandForecastModel()
     * @uses ReplenishmentInfoReplenishmentParameters::setForecastPeriodType()
     * @uses ReplenishmentInfoReplenishmentParameters::setPeriodsToAnalyze()
     * @uses ReplenishmentInfoReplenishmentParameters::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $replClass
     * @param \StructType\Field $seasonality
     * @param \StructType\Field $source
     * @param \StructType\Field $method
     * @param \StructType\Field $replenishmentWarehouse
     * @param \StructType\Field $maxShelfLifeDays
     * @param \StructType\Field $launchDate
     * @param \StructType\Field $terminationDate
     * @param \StructType\Field $serviceLevel
     * @param \StructType\Field $safetyStock
     * @param \StructType\Field $reorderPoint
     * @param \StructType\Field $maxQty
     * @param \StructType\Field $transferERQ
     * @param \StructType\Field $demandForecastModel
     * @param \StructType\Field $forecastPeriodType
     * @param \StructType\Field $periodsToAnalyze
     * @param \StructType\ReplenishmentInfoReplenishmentParametersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $replClass = null, \StructType\Field $seasonality = null, \StructType\Field $source = null, \StructType\Field $method = null, \StructType\Field $replenishmentWarehouse = null, \StructType\Field $maxShelfLifeDays = null, \StructType\Field $launchDate = null, \StructType\Field $terminationDate = null, \StructType\Field $serviceLevel = null, \StructType\Field $safetyStock = null, \StructType\Field $reorderPoint = null, \StructType\Field $maxQty = null, \StructType\Field $transferERQ = null, \StructType\Field $demandForecastModel = null, \StructType\Field $forecastPeriodType = null, \StructType\Field $periodsToAnalyze = null, \StructType\ReplenishmentInfoReplenishmentParametersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setReplClass($replClass)
            ->setSeasonality($seasonality)
            ->setSource($source)
            ->setMethod($method)
            ->setReplenishmentWarehouse($replenishmentWarehouse)
            ->setMaxShelfLifeDays($maxShelfLifeDays)
            ->setLaunchDate($launchDate)
            ->setTerminationDate($terminationDate)
            ->setServiceLevel($serviceLevel)
            ->setSafetyStock($safetyStock)
            ->setReorderPoint($reorderPoint)
            ->setMaxQty($maxQty)
            ->setTransferERQ($transferERQ)
            ->setDemandForecastModel($demandForecastModel)
            ->setForecastPeriodType($forecastPeriodType)
            ->setPeriodsToAnalyze($periodsToAnalyze)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ReplClass value
     * @return \StructType\Field|null
     */
    public function getReplClass()
    {
        return $this->ReplClass;
    }
    /**
     * Set ReplClass value
     * @param \StructType\Field $replClass
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setReplClass(\StructType\Field $replClass = null)
    {
        $this->ReplClass = $replClass;
        return $this;
    }
    /**
     * Get Seasonality value
     * @return \StructType\Field|null
     */
    public function getSeasonality()
    {
        return $this->Seasonality;
    }
    /**
     * Set Seasonality value
     * @param \StructType\Field $seasonality
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setSeasonality(\StructType\Field $seasonality = null)
    {
        $this->Seasonality = $seasonality;
        return $this;
    }
    /**
     * Get Source value
     * @return \StructType\Field|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \StructType\Field $source
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setSource(\StructType\Field $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Method value
     * @return \StructType\Field|null
     */
    public function getMethod()
    {
        return $this->Method;
    }
    /**
     * Set Method value
     * @param \StructType\Field $method
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setMethod(\StructType\Field $method = null)
    {
        $this->Method = $method;
        return $this;
    }
    /**
     * Get ReplenishmentWarehouse value
     * @return \StructType\Field|null
     */
    public function getReplenishmentWarehouse()
    {
        return $this->ReplenishmentWarehouse;
    }
    /**
     * Set ReplenishmentWarehouse value
     * @param \StructType\Field $replenishmentWarehouse
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setReplenishmentWarehouse(\StructType\Field $replenishmentWarehouse = null)
    {
        $this->ReplenishmentWarehouse = $replenishmentWarehouse;
        return $this;
    }
    /**
     * Get MaxShelfLifeDays value
     * @return \StructType\Field|null
     */
    public function getMaxShelfLifeDays()
    {
        return $this->MaxShelfLifeDays;
    }
    /**
     * Set MaxShelfLifeDays value
     * @param \StructType\Field $maxShelfLifeDays
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setMaxShelfLifeDays(\StructType\Field $maxShelfLifeDays = null)
    {
        $this->MaxShelfLifeDays = $maxShelfLifeDays;
        return $this;
    }
    /**
     * Get LaunchDate value
     * @return \StructType\Field|null
     */
    public function getLaunchDate()
    {
        return $this->LaunchDate;
    }
    /**
     * Set LaunchDate value
     * @param \StructType\Field $launchDate
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setLaunchDate(\StructType\Field $launchDate = null)
    {
        $this->LaunchDate = $launchDate;
        return $this;
    }
    /**
     * Get TerminationDate value
     * @return \StructType\Field|null
     */
    public function getTerminationDate()
    {
        return $this->TerminationDate;
    }
    /**
     * Set TerminationDate value
     * @param \StructType\Field $terminationDate
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setTerminationDate(\StructType\Field $terminationDate = null)
    {
        $this->TerminationDate = $terminationDate;
        return $this;
    }
    /**
     * Get ServiceLevel value
     * @return \StructType\Field|null
     */
    public function getServiceLevel()
    {
        return $this->ServiceLevel;
    }
    /**
     * Set ServiceLevel value
     * @param \StructType\Field $serviceLevel
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setServiceLevel(\StructType\Field $serviceLevel = null)
    {
        $this->ServiceLevel = $serviceLevel;
        return $this;
    }
    /**
     * Get SafetyStock value
     * @return \StructType\Field|null
     */
    public function getSafetyStock()
    {
        return $this->SafetyStock;
    }
    /**
     * Set SafetyStock value
     * @param \StructType\Field $safetyStock
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setSafetyStock(\StructType\Field $safetyStock = null)
    {
        $this->SafetyStock = $safetyStock;
        return $this;
    }
    /**
     * Get ReorderPoint value
     * @return \StructType\Field|null
     */
    public function getReorderPoint()
    {
        return $this->ReorderPoint;
    }
    /**
     * Set ReorderPoint value
     * @param \StructType\Field $reorderPoint
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setReorderPoint(\StructType\Field $reorderPoint = null)
    {
        $this->ReorderPoint = $reorderPoint;
        return $this;
    }
    /**
     * Get MaxQty value
     * @return \StructType\Field|null
     */
    public function getMaxQty()
    {
        return $this->MaxQty;
    }
    /**
     * Set MaxQty value
     * @param \StructType\Field $maxQty
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setMaxQty(\StructType\Field $maxQty = null)
    {
        $this->MaxQty = $maxQty;
        return $this;
    }
    /**
     * Get TransferERQ value
     * @return \StructType\Field|null
     */
    public function getTransferERQ()
    {
        return $this->TransferERQ;
    }
    /**
     * Set TransferERQ value
     * @param \StructType\Field $transferERQ
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setTransferERQ(\StructType\Field $transferERQ = null)
    {
        $this->TransferERQ = $transferERQ;
        return $this;
    }
    /**
     * Get DemandForecastModel value
     * @return \StructType\Field|null
     */
    public function getDemandForecastModel()
    {
        return $this->DemandForecastModel;
    }
    /**
     * Set DemandForecastModel value
     * @param \StructType\Field $demandForecastModel
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setDemandForecastModel(\StructType\Field $demandForecastModel = null)
    {
        $this->DemandForecastModel = $demandForecastModel;
        return $this;
    }
    /**
     * Get ForecastPeriodType value
     * @return \StructType\Field|null
     */
    public function getForecastPeriodType()
    {
        return $this->ForecastPeriodType;
    }
    /**
     * Set ForecastPeriodType value
     * @param \StructType\Field $forecastPeriodType
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setForecastPeriodType(\StructType\Field $forecastPeriodType = null)
    {
        $this->ForecastPeriodType = $forecastPeriodType;
        return $this;
    }
    /**
     * Get PeriodsToAnalyze value
     * @return \StructType\Field|null
     */
    public function getPeriodsToAnalyze()
    {
        return $this->PeriodsToAnalyze;
    }
    /**
     * Set PeriodsToAnalyze value
     * @param \StructType\Field $periodsToAnalyze
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setPeriodsToAnalyze(\StructType\Field $periodsToAnalyze = null)
    {
        $this->PeriodsToAnalyze = $periodsToAnalyze;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ReplenishmentInfoReplenishmentParametersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ReplenishmentInfoReplenishmentParametersServiceCommands $serviceCommands
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public function setServiceCommands(\StructType\ReplenishmentInfoReplenishmentParametersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
