<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralSettings StructType
 * @subpackage Structs
 */
class GeneralSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The TemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TemplateID;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for GeneralSettings
     * @uses GeneralSettings::setDisplayName()
     * @uses GeneralSettings::setTemplateID()
     * @uses GeneralSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $templateID
     * @param \StructType\GeneralSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $templateID = null, \StructType\GeneralSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setTemplateID($templateID)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\GeneralSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get TemplateID value
     * @return \StructType\Field|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param \StructType\Field $templateID
     * @return \StructType\GeneralSettings
     */
    public function setTemplateID(\StructType\Field $templateID = null)
    {
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\GeneralSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\GeneralSettingsServiceCommands $serviceCommands
     * @return \StructType\GeneralSettings
     */
    public function setServiceCommands(\StructType\GeneralSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeneralSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
