<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributesAttributes StructType
 * @subpackage Structs
 */
class AttributesAttributes extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Attribute;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Required;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Category;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Value;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributesAttributesServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AttributesAttributes
     * @uses AttributesAttributes::setDisplayName()
     * @uses AttributesAttributes::setAttribute()
     * @uses AttributesAttributes::setRequired()
     * @uses AttributesAttributes::setCategory()
     * @uses AttributesAttributes::setValue()
     * @uses AttributesAttributes::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $attribute
     * @param \StructType\Field $required
     * @param \StructType\Field $category
     * @param \StructType\Field $value
     * @param \StructType\AttributesAttributesServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $attribute = null, \StructType\Field $required = null, \StructType\Field $category = null, \StructType\Field $value = null, \StructType\AttributesAttributesServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAttribute($attribute)
            ->setRequired($required)
            ->setCategory($category)
            ->setValue($value)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AttributesAttributes
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Attribute value
     * @return \StructType\Field|null
     */
    public function getAttribute()
    {
        return $this->Attribute;
    }
    /**
     * Set Attribute value
     * @param \StructType\Field $attribute
     * @return \StructType\AttributesAttributes
     */
    public function setAttribute(\StructType\Field $attribute = null)
    {
        $this->Attribute = $attribute;
        return $this;
    }
    /**
     * Get Required value
     * @return \StructType\Field|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param \StructType\Field $required
     * @return \StructType\AttributesAttributes
     */
    public function setRequired(\StructType\Field $required = null)
    {
        $this->Required = $required;
        return $this;
    }
    /**
     * Get Category value
     * @return \StructType\Field|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param \StructType\Field $category
     * @return \StructType\AttributesAttributes
     */
    public function setCategory(\StructType\Field $category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Value value
     * @return \StructType\Field|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \StructType\Field $value
     * @return \StructType\AttributesAttributes
     */
    public function setValue(\StructType\Field $value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AttributesAttributesServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AttributesAttributesServiceCommands $serviceCommands
     * @return \StructType\AttributesAttributes
     */
    public function setServiceCommands(\StructType\AttributesAttributesServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributesAttributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
