<?php

namespace EnumType;

/**
 * This class stands for PXSpecialButtonType EnumType
 * @subpackage Enumerations
 */
class PXSpecialButtonType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Save'
     * @return string 'Save'
     */
    const VALUE_SAVE = 'Save';
    /**
     * Constant for value 'SaveNotClose'
     * @return string 'SaveNotClose'
     */
    const VALUE_SAVE_NOT_CLOSE = 'SaveNotClose';
    /**
     * Constant for value 'Cancel'
     * @return string 'Cancel'
     */
    const VALUE_CANCEL = 'Cancel';
    /**
     * Constant for value 'Refresh'
     * @return string 'Refresh'
     */
    const VALUE_REFRESH = 'Refresh';
    /**
     * Constant for value 'CopyPaste'
     * @return string 'CopyPaste'
     */
    const VALUE_COPY_PASTE = 'CopyPaste';
    /**
     * Constant for value 'Report'
     * @return string 'Report'
     */
    const VALUE_REPORT = 'Report';
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'Next'
     * @return string 'Next'
     */
    const VALUE_NEXT = 'Next';
    /**
     * Constant for value 'Prev'
     * @return string 'Prev'
     */
    const VALUE_PREV = 'Prev';
    /**
     * Constant for value 'Last'
     * @return string 'Last'
     */
    const VALUE_LAST = 'Last';
    /**
     * Constant for value 'Insert'
     * @return string 'Insert'
     */
    const VALUE_INSERT = 'Insert';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Approve'
     * @return string 'Approve'
     */
    const VALUE_APPROVE = 'Approve';
    /**
     * Constant for value 'ApproveAll'
     * @return string 'ApproveAll'
     */
    const VALUE_APPROVE_ALL = 'ApproveAll';
    /**
     * Constant for value 'Process'
     * @return string 'Process'
     */
    const VALUE_PROCESS = 'Process';
    /**
     * Constant for value 'ProcessAll'
     * @return string 'ProcessAll'
     */
    const VALUE_PROCESS_ALL = 'ProcessAll';
    /**
     * Constant for value 'Schedule'
     * @return string 'Schedule'
     */
    const VALUE_SCHEDULE = 'Schedule';
    /**
     * Constant for value 'EditDetail'
     * @return string 'EditDetail'
     */
    const VALUE_EDIT_DETAIL = 'EditDetail';
    /**
     * Constant for value 'ActionsFolder'
     * @return string 'ActionsFolder'
     */
    const VALUE_ACTIONS_FOLDER = 'ActionsFolder';
    /**
     * Constant for value 'InquiriesFolder'
     * @return string 'InquiriesFolder'
     */
    const VALUE_INQUIRIES_FOLDER = 'InquiriesFolder';
    /**
     * Constant for value 'ReportsFolder'
     * @return string 'ReportsFolder'
     */
    const VALUE_REPORTS_FOLDER = 'ReportsFolder';
    /**
     * Constant for value 'ToolbarFolder'
     * @return string 'ToolbarFolder'
     */
    const VALUE_TOOLBAR_FOLDER = 'ToolbarFolder';
    /**
     * Constant for value 'SidePanelFolder'
     * @return string 'SidePanelFolder'
     */
    const VALUE_SIDE_PANEL_FOLDER = 'SidePanelFolder';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_SAVE
     * @uses self::VALUE_SAVE_NOT_CLOSE
     * @uses self::VALUE_CANCEL
     * @uses self::VALUE_REFRESH
     * @uses self::VALUE_COPY_PASTE
     * @uses self::VALUE_REPORT
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_NEXT
     * @uses self::VALUE_PREV
     * @uses self::VALUE_LAST
     * @uses self::VALUE_INSERT
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_APPROVE
     * @uses self::VALUE_APPROVE_ALL
     * @uses self::VALUE_PROCESS
     * @uses self::VALUE_PROCESS_ALL
     * @uses self::VALUE_SCHEDULE
     * @uses self::VALUE_EDIT_DETAIL
     * @uses self::VALUE_ACTIONS_FOLDER
     * @uses self::VALUE_INQUIRIES_FOLDER
     * @uses self::VALUE_REPORTS_FOLDER
     * @uses self::VALUE_TOOLBAR_FOLDER
     * @uses self::VALUE_SIDE_PANEL_FOLDER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_SAVE,
            self::VALUE_SAVE_NOT_CLOSE,
            self::VALUE_CANCEL,
            self::VALUE_REFRESH,
            self::VALUE_COPY_PASTE,
            self::VALUE_REPORT,
            self::VALUE_FIRST,
            self::VALUE_NEXT,
            self::VALUE_PREV,
            self::VALUE_LAST,
            self::VALUE_INSERT,
            self::VALUE_DELETE,
            self::VALUE_APPROVE,
            self::VALUE_APPROVE_ALL,
            self::VALUE_PROCESS,
            self::VALUE_PROCESS_ALL,
            self::VALUE_SCHEDULE,
            self::VALUE_EDIT_DETAIL,
            self::VALUE_ACTIONS_FOLDER,
            self::VALUE_INQUIRIES_FOLDER,
            self::VALUE_REPORTS_FOLDER,
            self::VALUE_TOOLBAR_FOLDER,
            self::VALUE_SIDE_PANEL_FOLDER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
