<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorDetails StructType
 * @subpackage Structs
 */
class VendorDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Active;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Default;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorID;
    /**
     * The VendorName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorName;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subitem;
    /**
     * The PurchaseUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PurchaseUnit;
    /**
     * The VendorInventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorInventoryID;
    /**
     * The LeadTimeDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LeadTimeDays;
    /**
     * The Override
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Override;
    /**
     * The AddLeadTimeDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AddLeadTimeDays;
    /**
     * The MinOrderFreqDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MinOrderFreqDays;
    /**
     * The MinOrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MinOrderQty;
    /**
     * The MaxOrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MaxOrderQty;
    /**
     * The LotSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LotSize;
    /**
     * The EOQ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EOQ;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CurrencyID;
    /**
     * The LastVendorPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LastVendorPrice;
    /**
     * The PrepaymentPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentPercent;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VendorDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for VendorDetails
     * @uses VendorDetails::setDisplayName()
     * @uses VendorDetails::setActive()
     * @uses VendorDetails::setDefault()
     * @uses VendorDetails::setVendorID()
     * @uses VendorDetails::setVendorName()
     * @uses VendorDetails::setLocation()
     * @uses VendorDetails::setWarehouse()
     * @uses VendorDetails::setSubitem()
     * @uses VendorDetails::setPurchaseUnit()
     * @uses VendorDetails::setVendorInventoryID()
     * @uses VendorDetails::setLeadTimeDays()
     * @uses VendorDetails::setOverride()
     * @uses VendorDetails::setAddLeadTimeDays()
     * @uses VendorDetails::setMinOrderFreqDays()
     * @uses VendorDetails::setMinOrderQty()
     * @uses VendorDetails::setMaxOrderQty()
     * @uses VendorDetails::setLotSize()
     * @uses VendorDetails::setEOQ()
     * @uses VendorDetails::setCurrencyID()
     * @uses VendorDetails::setLastVendorPrice()
     * @uses VendorDetails::setPrepaymentPercent()
     * @uses VendorDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $active
     * @param \StructType\Field $default
     * @param \StructType\Field $vendorID
     * @param \StructType\Field $vendorName
     * @param \StructType\Field $location
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $subitem
     * @param \StructType\Field $purchaseUnit
     * @param \StructType\Field $vendorInventoryID
     * @param \StructType\Field $leadTimeDays
     * @param \StructType\Field $override
     * @param \StructType\Field $addLeadTimeDays
     * @param \StructType\Field $minOrderFreqDays
     * @param \StructType\Field $minOrderQty
     * @param \StructType\Field $maxOrderQty
     * @param \StructType\Field $lotSize
     * @param \StructType\Field $eOQ
     * @param \StructType\Field $currencyID
     * @param \StructType\Field $lastVendorPrice
     * @param \StructType\Field $prepaymentPercent
     * @param \StructType\VendorDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $active = null, \StructType\Field $default = null, \StructType\Field $vendorID = null, \StructType\Field $vendorName = null, \StructType\Field $location = null, \StructType\Field $warehouse = null, \StructType\Field $subitem = null, \StructType\Field $purchaseUnit = null, \StructType\Field $vendorInventoryID = null, \StructType\Field $leadTimeDays = null, \StructType\Field $override = null, \StructType\Field $addLeadTimeDays = null, \StructType\Field $minOrderFreqDays = null, \StructType\Field $minOrderQty = null, \StructType\Field $maxOrderQty = null, \StructType\Field $lotSize = null, \StructType\Field $eOQ = null, \StructType\Field $currencyID = null, \StructType\Field $lastVendorPrice = null, \StructType\Field $prepaymentPercent = null, \StructType\VendorDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setActive($active)
            ->setDefault($default)
            ->setVendorID($vendorID)
            ->setVendorName($vendorName)
            ->setLocation($location)
            ->setWarehouse($warehouse)
            ->setSubitem($subitem)
            ->setPurchaseUnit($purchaseUnit)
            ->setVendorInventoryID($vendorInventoryID)
            ->setLeadTimeDays($leadTimeDays)
            ->setOverride($override)
            ->setAddLeadTimeDays($addLeadTimeDays)
            ->setMinOrderFreqDays($minOrderFreqDays)
            ->setMinOrderQty($minOrderQty)
            ->setMaxOrderQty($maxOrderQty)
            ->setLotSize($lotSize)
            ->setEOQ($eOQ)
            ->setCurrencyID($currencyID)
            ->setLastVendorPrice($lastVendorPrice)
            ->setPrepaymentPercent($prepaymentPercent)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\VendorDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Active value
     * @return \StructType\Field|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param \StructType\Field $active
     * @return \StructType\VendorDetails
     */
    public function setActive(\StructType\Field $active = null)
    {
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Default value
     * @return \StructType\Field|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param \StructType\Field $default
     * @return \StructType\VendorDetails
     */
    public function setDefault(\StructType\Field $default = null)
    {
        $this->Default = $default;
        return $this;
    }
    /**
     * Get VendorID value
     * @return \StructType\Field|null
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param \StructType\Field $vendorID
     * @return \StructType\VendorDetails
     */
    public function setVendorID(\StructType\Field $vendorID = null)
    {
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get VendorName value
     * @return \StructType\Field|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param \StructType\Field $vendorName
     * @return \StructType\VendorDetails
     */
    public function setVendorName(\StructType\Field $vendorName = null)
    {
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\VendorDetails
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\VendorDetails
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Subitem value
     * @return \StructType\Field|null
     */
    public function getSubitem()
    {
        return $this->Subitem;
    }
    /**
     * Set Subitem value
     * @param \StructType\Field $subitem
     * @return \StructType\VendorDetails
     */
    public function setSubitem(\StructType\Field $subitem = null)
    {
        $this->Subitem = $subitem;
        return $this;
    }
    /**
     * Get PurchaseUnit value
     * @return \StructType\Field|null
     */
    public function getPurchaseUnit()
    {
        return $this->PurchaseUnit;
    }
    /**
     * Set PurchaseUnit value
     * @param \StructType\Field $purchaseUnit
     * @return \StructType\VendorDetails
     */
    public function setPurchaseUnit(\StructType\Field $purchaseUnit = null)
    {
        $this->PurchaseUnit = $purchaseUnit;
        return $this;
    }
    /**
     * Get VendorInventoryID value
     * @return \StructType\Field|null
     */
    public function getVendorInventoryID()
    {
        return $this->VendorInventoryID;
    }
    /**
     * Set VendorInventoryID value
     * @param \StructType\Field $vendorInventoryID
     * @return \StructType\VendorDetails
     */
    public function setVendorInventoryID(\StructType\Field $vendorInventoryID = null)
    {
        $this->VendorInventoryID = $vendorInventoryID;
        return $this;
    }
    /**
     * Get LeadTimeDays value
     * @return \StructType\Field|null
     */
    public function getLeadTimeDays()
    {
        return $this->LeadTimeDays;
    }
    /**
     * Set LeadTimeDays value
     * @param \StructType\Field $leadTimeDays
     * @return \StructType\VendorDetails
     */
    public function setLeadTimeDays(\StructType\Field $leadTimeDays = null)
    {
        $this->LeadTimeDays = $leadTimeDays;
        return $this;
    }
    /**
     * Get Override value
     * @return \StructType\Field|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param \StructType\Field $override
     * @return \StructType\VendorDetails
     */
    public function setOverride(\StructType\Field $override = null)
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Get AddLeadTimeDays value
     * @return \StructType\Field|null
     */
    public function getAddLeadTimeDays()
    {
        return $this->AddLeadTimeDays;
    }
    /**
     * Set AddLeadTimeDays value
     * @param \StructType\Field $addLeadTimeDays
     * @return \StructType\VendorDetails
     */
    public function setAddLeadTimeDays(\StructType\Field $addLeadTimeDays = null)
    {
        $this->AddLeadTimeDays = $addLeadTimeDays;
        return $this;
    }
    /**
     * Get MinOrderFreqDays value
     * @return \StructType\Field|null
     */
    public function getMinOrderFreqDays()
    {
        return $this->MinOrderFreqDays;
    }
    /**
     * Set MinOrderFreqDays value
     * @param \StructType\Field $minOrderFreqDays
     * @return \StructType\VendorDetails
     */
    public function setMinOrderFreqDays(\StructType\Field $minOrderFreqDays = null)
    {
        $this->MinOrderFreqDays = $minOrderFreqDays;
        return $this;
    }
    /**
     * Get MinOrderQty value
     * @return \StructType\Field|null
     */
    public function getMinOrderQty()
    {
        return $this->MinOrderQty;
    }
    /**
     * Set MinOrderQty value
     * @param \StructType\Field $minOrderQty
     * @return \StructType\VendorDetails
     */
    public function setMinOrderQty(\StructType\Field $minOrderQty = null)
    {
        $this->MinOrderQty = $minOrderQty;
        return $this;
    }
    /**
     * Get MaxOrderQty value
     * @return \StructType\Field|null
     */
    public function getMaxOrderQty()
    {
        return $this->MaxOrderQty;
    }
    /**
     * Set MaxOrderQty value
     * @param \StructType\Field $maxOrderQty
     * @return \StructType\VendorDetails
     */
    public function setMaxOrderQty(\StructType\Field $maxOrderQty = null)
    {
        $this->MaxOrderQty = $maxOrderQty;
        return $this;
    }
    /**
     * Get LotSize value
     * @return \StructType\Field|null
     */
    public function getLotSize()
    {
        return $this->LotSize;
    }
    /**
     * Set LotSize value
     * @param \StructType\Field $lotSize
     * @return \StructType\VendorDetails
     */
    public function setLotSize(\StructType\Field $lotSize = null)
    {
        $this->LotSize = $lotSize;
        return $this;
    }
    /**
     * Get EOQ value
     * @return \StructType\Field|null
     */
    public function getEOQ()
    {
        return $this->EOQ;
    }
    /**
     * Set EOQ value
     * @param \StructType\Field $eOQ
     * @return \StructType\VendorDetails
     */
    public function setEOQ(\StructType\Field $eOQ = null)
    {
        $this->EOQ = $eOQ;
        return $this;
    }
    /**
     * Get CurrencyID value
     * @return \StructType\Field|null
     */
    public function getCurrencyID()
    {
        return $this->CurrencyID;
    }
    /**
     * Set CurrencyID value
     * @param \StructType\Field $currencyID
     * @return \StructType\VendorDetails
     */
    public function setCurrencyID(\StructType\Field $currencyID = null)
    {
        $this->CurrencyID = $currencyID;
        return $this;
    }
    /**
     * Get LastVendorPrice value
     * @return \StructType\Field|null
     */
    public function getLastVendorPrice()
    {
        return $this->LastVendorPrice;
    }
    /**
     * Set LastVendorPrice value
     * @param \StructType\Field $lastVendorPrice
     * @return \StructType\VendorDetails
     */
    public function setLastVendorPrice(\StructType\Field $lastVendorPrice = null)
    {
        $this->LastVendorPrice = $lastVendorPrice;
        return $this;
    }
    /**
     * Get PrepaymentPercent value
     * @return \StructType\Field|null
     */
    public function getPrepaymentPercent()
    {
        return $this->PrepaymentPercent;
    }
    /**
     * Set PrepaymentPercent value
     * @param \StructType\Field $prepaymentPercent
     * @return \StructType\VendorDetails
     */
    public function setPrepaymentPercent(\StructType\Field $prepaymentPercent = null)
    {
        $this->PrepaymentPercent = $prepaymentPercent;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\VendorDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\VendorDetailsServiceCommands $serviceCommands
     * @return \StructType\VendorDetails
     */
    public function setServiceCommands(\StructType\VendorDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
