<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceManagement StructType
 * @subpackage Structs
 */
class ServiceManagement extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ComponentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ComponentID;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Active;
    /**
     * The Optional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Optional;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Qty;
    /**
     * The Descr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Descr;
    /**
     * The ClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ClassID;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The RequireSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequireSerial;
    /**
     * The CpnyWarrantyValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CpnyWarrantyValue;
    /**
     * The CpnyWarrantyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CpnyWarrantyType;
    /**
     * The VendorWarrantyValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorWarrantyValue;
    /**
     * The VendorWarrantyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorWarrantyType;
    /**
     * The VendorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorID;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceManagementServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ServiceManagement
     * @uses ServiceManagement::setDisplayName()
     * @uses ServiceManagement::setComponentID()
     * @uses ServiceManagement::setActive()
     * @uses ServiceManagement::setOptional()
     * @uses ServiceManagement::setQty()
     * @uses ServiceManagement::setDescr()
     * @uses ServiceManagement::setClassID()
     * @uses ServiceManagement::setInventoryID()
     * @uses ServiceManagement::setRequireSerial()
     * @uses ServiceManagement::setCpnyWarrantyValue()
     * @uses ServiceManagement::setCpnyWarrantyType()
     * @uses ServiceManagement::setVendorWarrantyValue()
     * @uses ServiceManagement::setVendorWarrantyType()
     * @uses ServiceManagement::setVendorID()
     * @uses ServiceManagement::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $componentID
     * @param \StructType\Field $active
     * @param \StructType\Field $optional
     * @param \StructType\Field $qty
     * @param \StructType\Field $descr
     * @param \StructType\Field $classID
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $requireSerial
     * @param \StructType\Field $cpnyWarrantyValue
     * @param \StructType\Field $cpnyWarrantyType
     * @param \StructType\Field $vendorWarrantyValue
     * @param \StructType\Field $vendorWarrantyType
     * @param \StructType\Field $vendorID
     * @param \StructType\ServiceManagementServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $componentID = null, \StructType\Field $active = null, \StructType\Field $optional = null, \StructType\Field $qty = null, \StructType\Field $descr = null, \StructType\Field $classID = null, \StructType\Field $inventoryID = null, \StructType\Field $requireSerial = null, \StructType\Field $cpnyWarrantyValue = null, \StructType\Field $cpnyWarrantyType = null, \StructType\Field $vendorWarrantyValue = null, \StructType\Field $vendorWarrantyType = null, \StructType\Field $vendorID = null, \StructType\ServiceManagementServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setComponentID($componentID)
            ->setActive($active)
            ->setOptional($optional)
            ->setQty($qty)
            ->setDescr($descr)
            ->setClassID($classID)
            ->setInventoryID($inventoryID)
            ->setRequireSerial($requireSerial)
            ->setCpnyWarrantyValue($cpnyWarrantyValue)
            ->setCpnyWarrantyType($cpnyWarrantyType)
            ->setVendorWarrantyValue($vendorWarrantyValue)
            ->setVendorWarrantyType($vendorWarrantyType)
            ->setVendorID($vendorID)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ServiceManagement
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ComponentID value
     * @return \StructType\Field|null
     */
    public function getComponentID()
    {
        return $this->ComponentID;
    }
    /**
     * Set ComponentID value
     * @param \StructType\Field $componentID
     * @return \StructType\ServiceManagement
     */
    public function setComponentID(\StructType\Field $componentID = null)
    {
        $this->ComponentID = $componentID;
        return $this;
    }
    /**
     * Get Active value
     * @return \StructType\Field|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param \StructType\Field $active
     * @return \StructType\ServiceManagement
     */
    public function setActive(\StructType\Field $active = null)
    {
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Optional value
     * @return \StructType\Field|null
     */
    public function getOptional()
    {
        return $this->Optional;
    }
    /**
     * Set Optional value
     * @param \StructType\Field $optional
     * @return \StructType\ServiceManagement
     */
    public function setOptional(\StructType\Field $optional = null)
    {
        $this->Optional = $optional;
        return $this;
    }
    /**
     * Get Qty value
     * @return \StructType\Field|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param \StructType\Field $qty
     * @return \StructType\ServiceManagement
     */
    public function setQty(\StructType\Field $qty = null)
    {
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get Descr value
     * @return \StructType\Field|null
     */
    public function getDescr()
    {
        return $this->Descr;
    }
    /**
     * Set Descr value
     * @param \StructType\Field $descr
     * @return \StructType\ServiceManagement
     */
    public function setDescr(\StructType\Field $descr = null)
    {
        $this->Descr = $descr;
        return $this;
    }
    /**
     * Get ClassID value
     * @return \StructType\Field|null
     */
    public function getClassID()
    {
        return $this->ClassID;
    }
    /**
     * Set ClassID value
     * @param \StructType\Field $classID
     * @return \StructType\ServiceManagement
     */
    public function setClassID(\StructType\Field $classID = null)
    {
        $this->ClassID = $classID;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\ServiceManagement
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get RequireSerial value
     * @return \StructType\Field|null
     */
    public function getRequireSerial()
    {
        return $this->RequireSerial;
    }
    /**
     * Set RequireSerial value
     * @param \StructType\Field $requireSerial
     * @return \StructType\ServiceManagement
     */
    public function setRequireSerial(\StructType\Field $requireSerial = null)
    {
        $this->RequireSerial = $requireSerial;
        return $this;
    }
    /**
     * Get CpnyWarrantyValue value
     * @return \StructType\Field|null
     */
    public function getCpnyWarrantyValue()
    {
        return $this->CpnyWarrantyValue;
    }
    /**
     * Set CpnyWarrantyValue value
     * @param \StructType\Field $cpnyWarrantyValue
     * @return \StructType\ServiceManagement
     */
    public function setCpnyWarrantyValue(\StructType\Field $cpnyWarrantyValue = null)
    {
        $this->CpnyWarrantyValue = $cpnyWarrantyValue;
        return $this;
    }
    /**
     * Get CpnyWarrantyType value
     * @return \StructType\Field|null
     */
    public function getCpnyWarrantyType()
    {
        return $this->CpnyWarrantyType;
    }
    /**
     * Set CpnyWarrantyType value
     * @param \StructType\Field $cpnyWarrantyType
     * @return \StructType\ServiceManagement
     */
    public function setCpnyWarrantyType(\StructType\Field $cpnyWarrantyType = null)
    {
        $this->CpnyWarrantyType = $cpnyWarrantyType;
        return $this;
    }
    /**
     * Get VendorWarrantyValue value
     * @return \StructType\Field|null
     */
    public function getVendorWarrantyValue()
    {
        return $this->VendorWarrantyValue;
    }
    /**
     * Set VendorWarrantyValue value
     * @param \StructType\Field $vendorWarrantyValue
     * @return \StructType\ServiceManagement
     */
    public function setVendorWarrantyValue(\StructType\Field $vendorWarrantyValue = null)
    {
        $this->VendorWarrantyValue = $vendorWarrantyValue;
        return $this;
    }
    /**
     * Get VendorWarrantyType value
     * @return \StructType\Field|null
     */
    public function getVendorWarrantyType()
    {
        return $this->VendorWarrantyType;
    }
    /**
     * Set VendorWarrantyType value
     * @param \StructType\Field $vendorWarrantyType
     * @return \StructType\ServiceManagement
     */
    public function setVendorWarrantyType(\StructType\Field $vendorWarrantyType = null)
    {
        $this->VendorWarrantyType = $vendorWarrantyType;
        return $this;
    }
    /**
     * Get VendorID value
     * @return \StructType\Field|null
     */
    public function getVendorID()
    {
        return $this->VendorID;
    }
    /**
     * Set VendorID value
     * @param \StructType\Field $vendorID
     * @return \StructType\ServiceManagement
     */
    public function setVendorID(\StructType\Field $vendorID = null)
    {
        $this->VendorID = $vendorID;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ServiceManagementServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ServiceManagementServiceCommands $serviceCommands
     * @return \StructType\ServiceManagement
     */
    public function setServiceCommands(\StructType\ServiceManagementServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
