<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedItems StructType
 * @subpackage Structs
 */
class RelatedItems extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Relation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Relation;
    /**
     * The Rank
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Rank;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Tag;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExpirationDate;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Active;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedItemsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for RelatedItems
     * @uses RelatedItems::setDisplayName()
     * @uses RelatedItems::setRelation()
     * @uses RelatedItems::setRank()
     * @uses RelatedItems::setTag()
     * @uses RelatedItems::setInventoryID()
     * @uses RelatedItems::setDescription()
     * @uses RelatedItems::setUOM()
     * @uses RelatedItems::setEffectiveDate()
     * @uses RelatedItems::setExpirationDate()
     * @uses RelatedItems::setActive()
     * @uses RelatedItems::setNoteText()
     * @uses RelatedItems::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $relation
     * @param \StructType\Field $rank
     * @param \StructType\Field $tag
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $description
     * @param \StructType\Field $uOM
     * @param \StructType\Field $effectiveDate
     * @param \StructType\Field $expirationDate
     * @param \StructType\Field $active
     * @param \StructType\Field $noteText
     * @param \StructType\RelatedItemsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $relation = null, \StructType\Field $rank = null, \StructType\Field $tag = null, \StructType\Field $inventoryID = null, \StructType\Field $description = null, \StructType\Field $uOM = null, \StructType\Field $effectiveDate = null, \StructType\Field $expirationDate = null, \StructType\Field $active = null, \StructType\Field $noteText = null, \StructType\RelatedItemsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setRelation($relation)
            ->setRank($rank)
            ->setTag($tag)
            ->setInventoryID($inventoryID)
            ->setDescription($description)
            ->setUOM($uOM)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setActive($active)
            ->setNoteText($noteText)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\RelatedItems
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Relation value
     * @return \StructType\Field|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param \StructType\Field $relation
     * @return \StructType\RelatedItems
     */
    public function setRelation(\StructType\Field $relation = null)
    {
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get Rank value
     * @return \StructType\Field|null
     */
    public function getRank()
    {
        return $this->Rank;
    }
    /**
     * Set Rank value
     * @param \StructType\Field $rank
     * @return \StructType\RelatedItems
     */
    public function setRank(\StructType\Field $rank = null)
    {
        $this->Rank = $rank;
        return $this;
    }
    /**
     * Get Tag value
     * @return \StructType\Field|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param \StructType\Field $tag
     * @return \StructType\RelatedItems
     */
    public function setTag(\StructType\Field $tag = null)
    {
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\RelatedItems
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\RelatedItems
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\RelatedItems
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return \StructType\Field|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param \StructType\Field $effectiveDate
     * @return \StructType\RelatedItems
     */
    public function setEffectiveDate(\StructType\Field $effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return \StructType\Field|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param \StructType\Field $expirationDate
     * @return \StructType\RelatedItems
     */
    public function setExpirationDate(\StructType\Field $expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get Active value
     * @return \StructType\Field|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param \StructType\Field $active
     * @return \StructType\RelatedItems
     */
    public function setActive(\StructType\Field $active = null)
    {
        $this->Active = $active;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\RelatedItems
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\RelatedItemsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\RelatedItemsServiceCommands $serviceCommands
     * @return \StructType\RelatedItems
     */
    public function setServiceCommands(\StructType\RelatedItemsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatedItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
