<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackagingDimensions StructType
 * @subpackage Structs
 */
class PackagingDimensions extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Weight;
    /**
     * The WeightUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WeightUOM;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Volume;
    /**
     * The VolumeUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VolumeUOM;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingDimensionsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PackagingDimensions
     * @uses PackagingDimensions::setDisplayName()
     * @uses PackagingDimensions::setWeight()
     * @uses PackagingDimensions::setWeightUOM()
     * @uses PackagingDimensions::setVolume()
     * @uses PackagingDimensions::setVolumeUOM()
     * @uses PackagingDimensions::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $weight
     * @param \StructType\Field $weightUOM
     * @param \StructType\Field $volume
     * @param \StructType\Field $volumeUOM
     * @param \StructType\PackagingDimensionsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $weight = null, \StructType\Field $weightUOM = null, \StructType\Field $volume = null, \StructType\Field $volumeUOM = null, \StructType\PackagingDimensionsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setWeight($weight)
            ->setWeightUOM($weightUOM)
            ->setVolume($volume)
            ->setVolumeUOM($volumeUOM)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PackagingDimensions
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Weight value
     * @return \StructType\Field|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \StructType\Field $weight
     * @return \StructType\PackagingDimensions
     */
    public function setWeight(\StructType\Field $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get WeightUOM value
     * @return \StructType\Field|null
     */
    public function getWeightUOM()
    {
        return $this->WeightUOM;
    }
    /**
     * Set WeightUOM value
     * @param \StructType\Field $weightUOM
     * @return \StructType\PackagingDimensions
     */
    public function setWeightUOM(\StructType\Field $weightUOM = null)
    {
        $this->WeightUOM = $weightUOM;
        return $this;
    }
    /**
     * Get Volume value
     * @return \StructType\Field|null
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param \StructType\Field $volume
     * @return \StructType\PackagingDimensions
     */
    public function setVolume(\StructType\Field $volume = null)
    {
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get VolumeUOM value
     * @return \StructType\Field|null
     */
    public function getVolumeUOM()
    {
        return $this->VolumeUOM;
    }
    /**
     * Set VolumeUOM value
     * @param \StructType\Field $volumeUOM
     * @return \StructType\PackagingDimensions
     */
    public function setVolumeUOM(\StructType\Field $volumeUOM = null)
    {
        $this->VolumeUOM = $volumeUOM;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PackagingDimensionsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PackagingDimensionsServiceCommands $serviceCommands
     * @return \StructType\PackagingDimensions
     */
    public function setServiceCommands(\StructType\PackagingDimensionsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackagingDimensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
