<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackagingAutomaticPackaging StructType
 * @subpackage Structs
 */
class PackagingAutomaticPackaging extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The PackagingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PackagingOption;
    /**
     * The PackSeparately
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PackSeparately;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingAutomaticPackagingServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for PackagingAutomaticPackaging
     * @uses PackagingAutomaticPackaging::setDisplayName()
     * @uses PackagingAutomaticPackaging::setPackagingOption()
     * @uses PackagingAutomaticPackaging::setPackSeparately()
     * @uses PackagingAutomaticPackaging::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $packagingOption
     * @param \StructType\Field $packSeparately
     * @param \StructType\PackagingAutomaticPackagingServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $packagingOption = null, \StructType\Field $packSeparately = null, \StructType\PackagingAutomaticPackagingServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setPackagingOption($packagingOption)
            ->setPackSeparately($packSeparately)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\PackagingAutomaticPackaging
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get PackagingOption value
     * @return \StructType\Field|null
     */
    public function getPackagingOption()
    {
        return $this->PackagingOption;
    }
    /**
     * Set PackagingOption value
     * @param \StructType\Field $packagingOption
     * @return \StructType\PackagingAutomaticPackaging
     */
    public function setPackagingOption(\StructType\Field $packagingOption = null)
    {
        $this->PackagingOption = $packagingOption;
        return $this;
    }
    /**
     * Get PackSeparately value
     * @return \StructType\Field|null
     */
    public function getPackSeparately()
    {
        return $this->PackSeparately;
    }
    /**
     * Set PackSeparately value
     * @param \StructType\Field $packSeparately
     * @return \StructType\PackagingAutomaticPackaging
     */
    public function setPackSeparately(\StructType\Field $packSeparately = null)
    {
        $this->PackSeparately = $packSeparately;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\PackagingAutomaticPackagingServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\PackagingAutomaticPackagingServiceCommands $serviceCommands
     * @return \StructType\PackagingAutomaticPackaging
     */
    public function setServiceCommands(\StructType\PackagingAutomaticPackagingServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackagingAutomaticPackaging
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
