<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossReference StructType
 * @subpackage Structs
 */
class CrossReference extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subitem;
    /**
     * The AlternateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AlternateType;
    /**
     * The VendorCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VendorCustomer;
    /**
     * The AlternateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AlternateID;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Description;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CrossReferenceServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for CrossReference
     * @uses CrossReference::setDisplayName()
     * @uses CrossReference::setSubitem()
     * @uses CrossReference::setAlternateType()
     * @uses CrossReference::setVendorCustomer()
     * @uses CrossReference::setAlternateID()
     * @uses CrossReference::setUOM()
     * @uses CrossReference::setDescription()
     * @uses CrossReference::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $subitem
     * @param \StructType\Field $alternateType
     * @param \StructType\Field $vendorCustomer
     * @param \StructType\Field $alternateID
     * @param \StructType\Field $uOM
     * @param \StructType\Field $description
     * @param \StructType\CrossReferenceServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $subitem = null, \StructType\Field $alternateType = null, \StructType\Field $vendorCustomer = null, \StructType\Field $alternateID = null, \StructType\Field $uOM = null, \StructType\Field $description = null, \StructType\CrossReferenceServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setSubitem($subitem)
            ->setAlternateType($alternateType)
            ->setVendorCustomer($vendorCustomer)
            ->setAlternateID($alternateID)
            ->setUOM($uOM)
            ->setDescription($description)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\CrossReference
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Subitem value
     * @return \StructType\Field|null
     */
    public function getSubitem()
    {
        return $this->Subitem;
    }
    /**
     * Set Subitem value
     * @param \StructType\Field $subitem
     * @return \StructType\CrossReference
     */
    public function setSubitem(\StructType\Field $subitem = null)
    {
        $this->Subitem = $subitem;
        return $this;
    }
    /**
     * Get AlternateType value
     * @return \StructType\Field|null
     */
    public function getAlternateType()
    {
        return $this->AlternateType;
    }
    /**
     * Set AlternateType value
     * @param \StructType\Field $alternateType
     * @return \StructType\CrossReference
     */
    public function setAlternateType(\StructType\Field $alternateType = null)
    {
        $this->AlternateType = $alternateType;
        return $this;
    }
    /**
     * Get VendorCustomer value
     * @return \StructType\Field|null
     */
    public function getVendorCustomer()
    {
        return $this->VendorCustomer;
    }
    /**
     * Set VendorCustomer value
     * @param \StructType\Field $vendorCustomer
     * @return \StructType\CrossReference
     */
    public function setVendorCustomer(\StructType\Field $vendorCustomer = null)
    {
        $this->VendorCustomer = $vendorCustomer;
        return $this;
    }
    /**
     * Get AlternateID value
     * @return \StructType\Field|null
     */
    public function getAlternateID()
    {
        return $this->AlternateID;
    }
    /**
     * Set AlternateID value
     * @param \StructType\Field $alternateID
     * @return \StructType\CrossReference
     */
    public function setAlternateID(\StructType\Field $alternateID = null)
    {
        $this->AlternateID = $alternateID;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\CrossReference
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Field|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Field $description
     * @return \StructType\CrossReference
     */
    public function setDescription(\StructType\Field $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\CrossReferenceServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\CrossReferenceServiceCommands $serviceCommands
     * @return \StructType\CrossReference
     */
    public function setServiceCommands(\StructType\CrossReferenceServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CrossReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
