<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Content StructType
 * @subpackage Structs
 */
class Content extends AbstractStructBase
{
    /**
     * The Actions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Actions
     */
    public $Actions;
    /**
     * The StockItemSummary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockItemSummary
     */
    public $StockItemSummary;
    /**
     * The GeneralSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettings
     */
    public $GeneralSettings;
    /**
     * The GeneralSettingsItemDefaults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsItemDefaults
     */
    public $GeneralSettingsItemDefaults;
    /**
     * The GeneralSettingsWarehouseDefaults
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsWarehouseDefaults
     */
    public $GeneralSettingsWarehouseDefaults;
    /**
     * The GeneralSettingsUnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsUnitOfMeasure
     */
    public $GeneralSettingsUnitOfMeasure;
    /**
     * The GeneralSettingsPhysicalInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsPhysicalInventory
     */
    public $GeneralSettingsPhysicalInventory;
    /**
     * The PriceCostInfoPriceManagement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCostInfoPriceManagement
     */
    public $PriceCostInfoPriceManagement;
    /**
     * The PriceCostInfoStandardCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCostInfoStandardCost
     */
    public $PriceCostInfoStandardCost;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Attributes
     */
    public $Attributes;
    /**
     * The PackagingDimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingDimensions
     */
    public $PackagingDimensions;
    /**
     * The PackagingInternationalShipping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingInternationalShipping
     */
    public $PackagingInternationalShipping;
    /**
     * The PackagingShippingThresholds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingShippingThresholds
     */
    public $PackagingShippingThresholds;
    /**
     * The PackagingAutomaticPackaging
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingAutomaticPackaging
     */
    public $PackagingAutomaticPackaging;
    /**
     * The GLAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GLAccounts
     */
    public $GLAccounts;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The DeferralSettingsRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeferralSettingsRules
     */
    public $DeferralSettingsRules;
    /**
     * The ServiceManagementEquipmentClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceManagementEquipmentClass
     */
    public $ServiceManagementEquipmentClass;
    /**
     * The ServiceManagementEQUIPMENTGENERALWARRANTY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceManagementEQUIPMENTGENERALWARRANTY
     */
    public $ServiceManagementEQUIPMENTGENERALWARRANTY;
    /**
     * The Subitems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Subitems
     */
    public $Subitems;
    /**
     * The GeneralSettingsUnitOfMeasureConversions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeneralSettingsUnitOfMeasureConversions
     */
    public $GeneralSettingsUnitOfMeasureConversions;
    /**
     * The DeferralSettingsRevenueComponents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeferralSettingsRevenueComponents
     */
    public $DeferralSettingsRevenueComponents;
    /**
     * The CrossReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CrossReference
     */
    public $CrossReference;
    /**
     * The VendorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * The AttributesAttributes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributesAttributes
     */
    public $AttributesAttributes;
    /**
     * The AttributesSalesCategories
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributesSalesCategories
     */
    public $AttributesSalesCategories;
    /**
     * The PriceCostInfoCostStatistics
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCostInfoCostStatistics
     */
    public $PriceCostInfoCostStatistics;
    /**
     * The WarehouseDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarehouseDetails
     */
    public $WarehouseDetails;
    /**
     * The ReplenishmentInfoReplenishmentParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReplenishmentInfoReplenishmentParameters
     */
    public $ReplenishmentInfoReplenishmentParameters;
    /**
     * The ReplenishmentInfoSubitemReplenishmentParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReplenishmentInfoSubitemReplenishmentParameters
     */
    public $ReplenishmentInfoSubitemReplenishmentParameters;
    /**
     * The PackagingAutomaticPackagingBoxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackagingAutomaticPackagingBoxes
     */
    public $PackagingAutomaticPackagingBoxes;
    /**
     * The RestrictionGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RestrictionGroups
     */
    public $RestrictionGroups;
    /**
     * The RelatedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedItems
     */
    public $RelatedItems;
    /**
     * The SyncStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SyncStatus
     */
    public $SyncStatus;
    /**
     * The SpecifyNewID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecifyNewID
     */
    public $SpecifyNewID;
    /**
     * The PriceCostInfoCostStatisticsRulesRUTAndRUTSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings
     */
    public $PriceCostInfoCostStatisticsRulesRUTAndRUTSettings;
    /**
     * The PriceCostInfoCostStatisticsRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceCostInfoCostStatisticsRules
     */
    public $PriceCostInfoCostStatisticsRules;
    /**
     * The ServiceManagement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceManagement
     */
    public $ServiceManagement;
    /**
     * Constructor method for Content
     * @uses Content::setActions()
     * @uses Content::setStockItemSummary()
     * @uses Content::setGeneralSettings()
     * @uses Content::setGeneralSettingsItemDefaults()
     * @uses Content::setGeneralSettingsWarehouseDefaults()
     * @uses Content::setGeneralSettingsUnitOfMeasure()
     * @uses Content::setGeneralSettingsPhysicalInventory()
     * @uses Content::setPriceCostInfoPriceManagement()
     * @uses Content::setPriceCostInfoStandardCost()
     * @uses Content::setAttributes()
     * @uses Content::setPackagingDimensions()
     * @uses Content::setPackagingInternationalShipping()
     * @uses Content::setPackagingShippingThresholds()
     * @uses Content::setPackagingAutomaticPackaging()
     * @uses Content::setGLAccounts()
     * @uses Content::setDescription()
     * @uses Content::setDeferralSettingsRules()
     * @uses Content::setServiceManagementEquipmentClass()
     * @uses Content::setServiceManagementEQUIPMENTGENERALWARRANTY()
     * @uses Content::setSubitems()
     * @uses Content::setGeneralSettingsUnitOfMeasureConversions()
     * @uses Content::setDeferralSettingsRevenueComponents()
     * @uses Content::setCrossReference()
     * @uses Content::setVendorDetails()
     * @uses Content::setAttributesAttributes()
     * @uses Content::setAttributesSalesCategories()
     * @uses Content::setPriceCostInfoCostStatistics()
     * @uses Content::setWarehouseDetails()
     * @uses Content::setReplenishmentInfoReplenishmentParameters()
     * @uses Content::setReplenishmentInfoSubitemReplenishmentParameters()
     * @uses Content::setPackagingAutomaticPackagingBoxes()
     * @uses Content::setRestrictionGroups()
     * @uses Content::setRelatedItems()
     * @uses Content::setSyncStatus()
     * @uses Content::setSpecifyNewID()
     * @uses Content::setPriceCostInfoCostStatisticsRulesRUTAndRUTSettings()
     * @uses Content::setPriceCostInfoCostStatisticsRules()
     * @uses Content::setServiceManagement()
     * @param \StructType\Actions $actions
     * @param \StructType\StockItemSummary $stockItemSummary
     * @param \StructType\GeneralSettings $generalSettings
     * @param \StructType\GeneralSettingsItemDefaults $generalSettingsItemDefaults
     * @param \StructType\GeneralSettingsWarehouseDefaults $generalSettingsWarehouseDefaults
     * @param \StructType\GeneralSettingsUnitOfMeasure $generalSettingsUnitOfMeasure
     * @param \StructType\GeneralSettingsPhysicalInventory $generalSettingsPhysicalInventory
     * @param \StructType\PriceCostInfoPriceManagement $priceCostInfoPriceManagement
     * @param \StructType\PriceCostInfoStandardCost $priceCostInfoStandardCost
     * @param \StructType\Attributes $attributes
     * @param \StructType\PackagingDimensions $packagingDimensions
     * @param \StructType\PackagingInternationalShipping $packagingInternationalShipping
     * @param \StructType\PackagingShippingThresholds $packagingShippingThresholds
     * @param \StructType\PackagingAutomaticPackaging $packagingAutomaticPackaging
     * @param \StructType\GLAccounts $gLAccounts
     * @param \StructType\Description $description
     * @param \StructType\DeferralSettingsRules $deferralSettingsRules
     * @param \StructType\ServiceManagementEquipmentClass $serviceManagementEquipmentClass
     * @param \StructType\ServiceManagementEQUIPMENTGENERALWARRANTY $serviceManagementEQUIPMENTGENERALWARRANTY
     * @param \StructType\Subitems $subitems
     * @param \StructType\GeneralSettingsUnitOfMeasureConversions $generalSettingsUnitOfMeasureConversions
     * @param \StructType\DeferralSettingsRevenueComponents $deferralSettingsRevenueComponents
     * @param \StructType\CrossReference $crossReference
     * @param \StructType\VendorDetails $vendorDetails
     * @param \StructType\AttributesAttributes $attributesAttributes
     * @param \StructType\AttributesSalesCategories $attributesSalesCategories
     * @param \StructType\PriceCostInfoCostStatistics $priceCostInfoCostStatistics
     * @param \StructType\WarehouseDetails $warehouseDetails
     * @param \StructType\ReplenishmentInfoReplenishmentParameters $replenishmentInfoReplenishmentParameters
     * @param \StructType\ReplenishmentInfoSubitemReplenishmentParameters $replenishmentInfoSubitemReplenishmentParameters
     * @param \StructType\PackagingAutomaticPackagingBoxes $packagingAutomaticPackagingBoxes
     * @param \StructType\RestrictionGroups $restrictionGroups
     * @param \StructType\RelatedItems $relatedItems
     * @param \StructType\SyncStatus $syncStatus
     * @param \StructType\SpecifyNewID $specifyNewID
     * @param \StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings $priceCostInfoCostStatisticsRulesRUTAndRUTSettings
     * @param \StructType\PriceCostInfoCostStatisticsRules $priceCostInfoCostStatisticsRules
     * @param \StructType\ServiceManagement $serviceManagement
     */
    public function __construct(\StructType\Actions $actions = null, \StructType\StockItemSummary $stockItemSummary = null, \StructType\GeneralSettings $generalSettings = null, \StructType\GeneralSettingsItemDefaults $generalSettingsItemDefaults = null, \StructType\GeneralSettingsWarehouseDefaults $generalSettingsWarehouseDefaults = null, \StructType\GeneralSettingsUnitOfMeasure $generalSettingsUnitOfMeasure = null, \StructType\GeneralSettingsPhysicalInventory $generalSettingsPhysicalInventory = null, \StructType\PriceCostInfoPriceManagement $priceCostInfoPriceManagement = null, \StructType\PriceCostInfoStandardCost $priceCostInfoStandardCost = null, \StructType\Attributes $attributes = null, \StructType\PackagingDimensions $packagingDimensions = null, \StructType\PackagingInternationalShipping $packagingInternationalShipping = null, \StructType\PackagingShippingThresholds $packagingShippingThresholds = null, \StructType\PackagingAutomaticPackaging $packagingAutomaticPackaging = null, \StructType\GLAccounts $gLAccounts = null, \StructType\Description $description = null, \StructType\DeferralSettingsRules $deferralSettingsRules = null, \StructType\ServiceManagementEquipmentClass $serviceManagementEquipmentClass = null, \StructType\ServiceManagementEQUIPMENTGENERALWARRANTY $serviceManagementEQUIPMENTGENERALWARRANTY = null, \StructType\Subitems $subitems = null, \StructType\GeneralSettingsUnitOfMeasureConversions $generalSettingsUnitOfMeasureConversions = null, \StructType\DeferralSettingsRevenueComponents $deferralSettingsRevenueComponents = null, \StructType\CrossReference $crossReference = null, \StructType\VendorDetails $vendorDetails = null, \StructType\AttributesAttributes $attributesAttributes = null, \StructType\AttributesSalesCategories $attributesSalesCategories = null, \StructType\PriceCostInfoCostStatistics $priceCostInfoCostStatistics = null, \StructType\WarehouseDetails $warehouseDetails = null, \StructType\ReplenishmentInfoReplenishmentParameters $replenishmentInfoReplenishmentParameters = null, \StructType\ReplenishmentInfoSubitemReplenishmentParameters $replenishmentInfoSubitemReplenishmentParameters = null, \StructType\PackagingAutomaticPackagingBoxes $packagingAutomaticPackagingBoxes = null, \StructType\RestrictionGroups $restrictionGroups = null, \StructType\RelatedItems $relatedItems = null, \StructType\SyncStatus $syncStatus = null, \StructType\SpecifyNewID $specifyNewID = null, \StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings $priceCostInfoCostStatisticsRulesRUTAndRUTSettings = null, \StructType\PriceCostInfoCostStatisticsRules $priceCostInfoCostStatisticsRules = null, \StructType\ServiceManagement $serviceManagement = null)
    {
        $this
            ->setActions($actions)
            ->setStockItemSummary($stockItemSummary)
            ->setGeneralSettings($generalSettings)
            ->setGeneralSettingsItemDefaults($generalSettingsItemDefaults)
            ->setGeneralSettingsWarehouseDefaults($generalSettingsWarehouseDefaults)
            ->setGeneralSettingsUnitOfMeasure($generalSettingsUnitOfMeasure)
            ->setGeneralSettingsPhysicalInventory($generalSettingsPhysicalInventory)
            ->setPriceCostInfoPriceManagement($priceCostInfoPriceManagement)
            ->setPriceCostInfoStandardCost($priceCostInfoStandardCost)
            ->setAttributes($attributes)
            ->setPackagingDimensions($packagingDimensions)
            ->setPackagingInternationalShipping($packagingInternationalShipping)
            ->setPackagingShippingThresholds($packagingShippingThresholds)
            ->setPackagingAutomaticPackaging($packagingAutomaticPackaging)
            ->setGLAccounts($gLAccounts)
            ->setDescription($description)
            ->setDeferralSettingsRules($deferralSettingsRules)
            ->setServiceManagementEquipmentClass($serviceManagementEquipmentClass)
            ->setServiceManagementEQUIPMENTGENERALWARRANTY($serviceManagementEQUIPMENTGENERALWARRANTY)
            ->setSubitems($subitems)
            ->setGeneralSettingsUnitOfMeasureConversions($generalSettingsUnitOfMeasureConversions)
            ->setDeferralSettingsRevenueComponents($deferralSettingsRevenueComponents)
            ->setCrossReference($crossReference)
            ->setVendorDetails($vendorDetails)
            ->setAttributesAttributes($attributesAttributes)
            ->setAttributesSalesCategories($attributesSalesCategories)
            ->setPriceCostInfoCostStatistics($priceCostInfoCostStatistics)
            ->setWarehouseDetails($warehouseDetails)
            ->setReplenishmentInfoReplenishmentParameters($replenishmentInfoReplenishmentParameters)
            ->setReplenishmentInfoSubitemReplenishmentParameters($replenishmentInfoSubitemReplenishmentParameters)
            ->setPackagingAutomaticPackagingBoxes($packagingAutomaticPackagingBoxes)
            ->setRestrictionGroups($restrictionGroups)
            ->setRelatedItems($relatedItems)
            ->setSyncStatus($syncStatus)
            ->setSpecifyNewID($specifyNewID)
            ->setPriceCostInfoCostStatisticsRulesRUTAndRUTSettings($priceCostInfoCostStatisticsRulesRUTAndRUTSettings)
            ->setPriceCostInfoCostStatisticsRules($priceCostInfoCostStatisticsRules)
            ->setServiceManagement($serviceManagement);
    }
    /**
     * Get Actions value
     * @return \StructType\Actions|null
     */
    public function getActions()
    {
        return $this->Actions;
    }
    /**
     * Set Actions value
     * @param \StructType\Actions $actions
     * @return \StructType\Content
     */
    public function setActions(\StructType\Actions $actions = null)
    {
        $this->Actions = $actions;
        return $this;
    }
    /**
     * Get StockItemSummary value
     * @return \StructType\StockItemSummary|null
     */
    public function getStockItemSummary()
    {
        return $this->StockItemSummary;
    }
    /**
     * Set StockItemSummary value
     * @param \StructType\StockItemSummary $stockItemSummary
     * @return \StructType\Content
     */
    public function setStockItemSummary(\StructType\StockItemSummary $stockItemSummary = null)
    {
        $this->StockItemSummary = $stockItemSummary;
        return $this;
    }
    /**
     * Get GeneralSettings value
     * @return \StructType\GeneralSettings|null
     */
    public function getGeneralSettings()
    {
        return $this->GeneralSettings;
    }
    /**
     * Set GeneralSettings value
     * @param \StructType\GeneralSettings $generalSettings
     * @return \StructType\Content
     */
    public function setGeneralSettings(\StructType\GeneralSettings $generalSettings = null)
    {
        $this->GeneralSettings = $generalSettings;
        return $this;
    }
    /**
     * Get GeneralSettingsItemDefaults value
     * @return \StructType\GeneralSettingsItemDefaults|null
     */
    public function getGeneralSettingsItemDefaults()
    {
        return $this->GeneralSettingsItemDefaults;
    }
    /**
     * Set GeneralSettingsItemDefaults value
     * @param \StructType\GeneralSettingsItemDefaults $generalSettingsItemDefaults
     * @return \StructType\Content
     */
    public function setGeneralSettingsItemDefaults(\StructType\GeneralSettingsItemDefaults $generalSettingsItemDefaults = null)
    {
        $this->GeneralSettingsItemDefaults = $generalSettingsItemDefaults;
        return $this;
    }
    /**
     * Get GeneralSettingsWarehouseDefaults value
     * @return \StructType\GeneralSettingsWarehouseDefaults|null
     */
    public function getGeneralSettingsWarehouseDefaults()
    {
        return $this->GeneralSettingsWarehouseDefaults;
    }
    /**
     * Set GeneralSettingsWarehouseDefaults value
     * @param \StructType\GeneralSettingsWarehouseDefaults $generalSettingsWarehouseDefaults
     * @return \StructType\Content
     */
    public function setGeneralSettingsWarehouseDefaults(\StructType\GeneralSettingsWarehouseDefaults $generalSettingsWarehouseDefaults = null)
    {
        $this->GeneralSettingsWarehouseDefaults = $generalSettingsWarehouseDefaults;
        return $this;
    }
    /**
     * Get GeneralSettingsUnitOfMeasure value
     * @return \StructType\GeneralSettingsUnitOfMeasure|null
     */
    public function getGeneralSettingsUnitOfMeasure()
    {
        return $this->GeneralSettingsUnitOfMeasure;
    }
    /**
     * Set GeneralSettingsUnitOfMeasure value
     * @param \StructType\GeneralSettingsUnitOfMeasure $generalSettingsUnitOfMeasure
     * @return \StructType\Content
     */
    public function setGeneralSettingsUnitOfMeasure(\StructType\GeneralSettingsUnitOfMeasure $generalSettingsUnitOfMeasure = null)
    {
        $this->GeneralSettingsUnitOfMeasure = $generalSettingsUnitOfMeasure;
        return $this;
    }
    /**
     * Get GeneralSettingsPhysicalInventory value
     * @return \StructType\GeneralSettingsPhysicalInventory|null
     */
    public function getGeneralSettingsPhysicalInventory()
    {
        return $this->GeneralSettingsPhysicalInventory;
    }
    /**
     * Set GeneralSettingsPhysicalInventory value
     * @param \StructType\GeneralSettingsPhysicalInventory $generalSettingsPhysicalInventory
     * @return \StructType\Content
     */
    public function setGeneralSettingsPhysicalInventory(\StructType\GeneralSettingsPhysicalInventory $generalSettingsPhysicalInventory = null)
    {
        $this->GeneralSettingsPhysicalInventory = $generalSettingsPhysicalInventory;
        return $this;
    }
    /**
     * Get PriceCostInfoPriceManagement value
     * @return \StructType\PriceCostInfoPriceManagement|null
     */
    public function getPriceCostInfoPriceManagement()
    {
        return $this->PriceCostInfoPriceManagement;
    }
    /**
     * Set PriceCostInfoPriceManagement value
     * @param \StructType\PriceCostInfoPriceManagement $priceCostInfoPriceManagement
     * @return \StructType\Content
     */
    public function setPriceCostInfoPriceManagement(\StructType\PriceCostInfoPriceManagement $priceCostInfoPriceManagement = null)
    {
        $this->PriceCostInfoPriceManagement = $priceCostInfoPriceManagement;
        return $this;
    }
    /**
     * Get PriceCostInfoStandardCost value
     * @return \StructType\PriceCostInfoStandardCost|null
     */
    public function getPriceCostInfoStandardCost()
    {
        return $this->PriceCostInfoStandardCost;
    }
    /**
     * Set PriceCostInfoStandardCost value
     * @param \StructType\PriceCostInfoStandardCost $priceCostInfoStandardCost
     * @return \StructType\Content
     */
    public function setPriceCostInfoStandardCost(\StructType\PriceCostInfoStandardCost $priceCostInfoStandardCost = null)
    {
        $this->PriceCostInfoStandardCost = $priceCostInfoStandardCost;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \StructType\Attributes|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @param \StructType\Attributes $attributes
     * @return \StructType\Content
     */
    public function setAttributes(\StructType\Attributes $attributes = null)
    {
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Get PackagingDimensions value
     * @return \StructType\PackagingDimensions|null
     */
    public function getPackagingDimensions()
    {
        return $this->PackagingDimensions;
    }
    /**
     * Set PackagingDimensions value
     * @param \StructType\PackagingDimensions $packagingDimensions
     * @return \StructType\Content
     */
    public function setPackagingDimensions(\StructType\PackagingDimensions $packagingDimensions = null)
    {
        $this->PackagingDimensions = $packagingDimensions;
        return $this;
    }
    /**
     * Get PackagingInternationalShipping value
     * @return \StructType\PackagingInternationalShipping|null
     */
    public function getPackagingInternationalShipping()
    {
        return $this->PackagingInternationalShipping;
    }
    /**
     * Set PackagingInternationalShipping value
     * @param \StructType\PackagingInternationalShipping $packagingInternationalShipping
     * @return \StructType\Content
     */
    public function setPackagingInternationalShipping(\StructType\PackagingInternationalShipping $packagingInternationalShipping = null)
    {
        $this->PackagingInternationalShipping = $packagingInternationalShipping;
        return $this;
    }
    /**
     * Get PackagingShippingThresholds value
     * @return \StructType\PackagingShippingThresholds|null
     */
    public function getPackagingShippingThresholds()
    {
        return $this->PackagingShippingThresholds;
    }
    /**
     * Set PackagingShippingThresholds value
     * @param \StructType\PackagingShippingThresholds $packagingShippingThresholds
     * @return \StructType\Content
     */
    public function setPackagingShippingThresholds(\StructType\PackagingShippingThresholds $packagingShippingThresholds = null)
    {
        $this->PackagingShippingThresholds = $packagingShippingThresholds;
        return $this;
    }
    /**
     * Get PackagingAutomaticPackaging value
     * @return \StructType\PackagingAutomaticPackaging|null
     */
    public function getPackagingAutomaticPackaging()
    {
        return $this->PackagingAutomaticPackaging;
    }
    /**
     * Set PackagingAutomaticPackaging value
     * @param \StructType\PackagingAutomaticPackaging $packagingAutomaticPackaging
     * @return \StructType\Content
     */
    public function setPackagingAutomaticPackaging(\StructType\PackagingAutomaticPackaging $packagingAutomaticPackaging = null)
    {
        $this->PackagingAutomaticPackaging = $packagingAutomaticPackaging;
        return $this;
    }
    /**
     * Get GLAccounts value
     * @return \StructType\GLAccounts|null
     */
    public function getGLAccounts()
    {
        return $this->GLAccounts;
    }
    /**
     * Set GLAccounts value
     * @param \StructType\GLAccounts $gLAccounts
     * @return \StructType\Content
     */
    public function setGLAccounts(\StructType\GLAccounts $gLAccounts = null)
    {
        $this->GLAccounts = $gLAccounts;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\Content
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DeferralSettingsRules value
     * @return \StructType\DeferralSettingsRules|null
     */
    public function getDeferralSettingsRules()
    {
        return $this->DeferralSettingsRules;
    }
    /**
     * Set DeferralSettingsRules value
     * @param \StructType\DeferralSettingsRules $deferralSettingsRules
     * @return \StructType\Content
     */
    public function setDeferralSettingsRules(\StructType\DeferralSettingsRules $deferralSettingsRules = null)
    {
        $this->DeferralSettingsRules = $deferralSettingsRules;
        return $this;
    }
    /**
     * Get ServiceManagementEquipmentClass value
     * @return \StructType\ServiceManagementEquipmentClass|null
     */
    public function getServiceManagementEquipmentClass()
    {
        return $this->ServiceManagementEquipmentClass;
    }
    /**
     * Set ServiceManagementEquipmentClass value
     * @param \StructType\ServiceManagementEquipmentClass $serviceManagementEquipmentClass
     * @return \StructType\Content
     */
    public function setServiceManagementEquipmentClass(\StructType\ServiceManagementEquipmentClass $serviceManagementEquipmentClass = null)
    {
        $this->ServiceManagementEquipmentClass = $serviceManagementEquipmentClass;
        return $this;
    }
    /**
     * Get ServiceManagementEQUIPMENTGENERALWARRANTY value
     * @return \StructType\ServiceManagementEQUIPMENTGENERALWARRANTY|null
     */
    public function getServiceManagementEQUIPMENTGENERALWARRANTY()
    {
        return $this->ServiceManagementEQUIPMENTGENERALWARRANTY;
    }
    /**
     * Set ServiceManagementEQUIPMENTGENERALWARRANTY value
     * @param \StructType\ServiceManagementEQUIPMENTGENERALWARRANTY $serviceManagementEQUIPMENTGENERALWARRANTY
     * @return \StructType\Content
     */
    public function setServiceManagementEQUIPMENTGENERALWARRANTY(\StructType\ServiceManagementEQUIPMENTGENERALWARRANTY $serviceManagementEQUIPMENTGENERALWARRANTY = null)
    {
        $this->ServiceManagementEQUIPMENTGENERALWARRANTY = $serviceManagementEQUIPMENTGENERALWARRANTY;
        return $this;
    }
    /**
     * Get Subitems value
     * @return \StructType\Subitems|null
     */
    public function getSubitems()
    {
        return $this->Subitems;
    }
    /**
     * Set Subitems value
     * @param \StructType\Subitems $subitems
     * @return \StructType\Content
     */
    public function setSubitems(\StructType\Subitems $subitems = null)
    {
        $this->Subitems = $subitems;
        return $this;
    }
    /**
     * Get GeneralSettingsUnitOfMeasureConversions value
     * @return \StructType\GeneralSettingsUnitOfMeasureConversions|null
     */
    public function getGeneralSettingsUnitOfMeasureConversions()
    {
        return $this->GeneralSettingsUnitOfMeasureConversions;
    }
    /**
     * Set GeneralSettingsUnitOfMeasureConversions value
     * @param \StructType\GeneralSettingsUnitOfMeasureConversions $generalSettingsUnitOfMeasureConversions
     * @return \StructType\Content
     */
    public function setGeneralSettingsUnitOfMeasureConversions(\StructType\GeneralSettingsUnitOfMeasureConversions $generalSettingsUnitOfMeasureConversions = null)
    {
        $this->GeneralSettingsUnitOfMeasureConversions = $generalSettingsUnitOfMeasureConversions;
        return $this;
    }
    /**
     * Get DeferralSettingsRevenueComponents value
     * @return \StructType\DeferralSettingsRevenueComponents|null
     */
    public function getDeferralSettingsRevenueComponents()
    {
        return $this->DeferralSettingsRevenueComponents;
    }
    /**
     * Set DeferralSettingsRevenueComponents value
     * @param \StructType\DeferralSettingsRevenueComponents $deferralSettingsRevenueComponents
     * @return \StructType\Content
     */
    public function setDeferralSettingsRevenueComponents(\StructType\DeferralSettingsRevenueComponents $deferralSettingsRevenueComponents = null)
    {
        $this->DeferralSettingsRevenueComponents = $deferralSettingsRevenueComponents;
        return $this;
    }
    /**
     * Get CrossReference value
     * @return \StructType\CrossReference|null
     */
    public function getCrossReference()
    {
        return $this->CrossReference;
    }
    /**
     * Set CrossReference value
     * @param \StructType\CrossReference $crossReference
     * @return \StructType\Content
     */
    public function setCrossReference(\StructType\CrossReference $crossReference = null)
    {
        $this->CrossReference = $crossReference;
        return $this;
    }
    /**
     * Get VendorDetails value
     * @return \StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return $this->VendorDetails;
    }
    /**
     * Set VendorDetails value
     * @param \StructType\VendorDetails $vendorDetails
     * @return \StructType\Content
     */
    public function setVendorDetails(\StructType\VendorDetails $vendorDetails = null)
    {
        $this->VendorDetails = $vendorDetails;
        return $this;
    }
    /**
     * Get AttributesAttributes value
     * @return \StructType\AttributesAttributes|null
     */
    public function getAttributesAttributes()
    {
        return $this->AttributesAttributes;
    }
    /**
     * Set AttributesAttributes value
     * @param \StructType\AttributesAttributes $attributesAttributes
     * @return \StructType\Content
     */
    public function setAttributesAttributes(\StructType\AttributesAttributes $attributesAttributes = null)
    {
        $this->AttributesAttributes = $attributesAttributes;
        return $this;
    }
    /**
     * Get AttributesSalesCategories value
     * @return \StructType\AttributesSalesCategories|null
     */
    public function getAttributesSalesCategories()
    {
        return $this->AttributesSalesCategories;
    }
    /**
     * Set AttributesSalesCategories value
     * @param \StructType\AttributesSalesCategories $attributesSalesCategories
     * @return \StructType\Content
     */
    public function setAttributesSalesCategories(\StructType\AttributesSalesCategories $attributesSalesCategories = null)
    {
        $this->AttributesSalesCategories = $attributesSalesCategories;
        return $this;
    }
    /**
     * Get PriceCostInfoCostStatistics value
     * @return \StructType\PriceCostInfoCostStatistics|null
     */
    public function getPriceCostInfoCostStatistics()
    {
        return $this->PriceCostInfoCostStatistics;
    }
    /**
     * Set PriceCostInfoCostStatistics value
     * @param \StructType\PriceCostInfoCostStatistics $priceCostInfoCostStatistics
     * @return \StructType\Content
     */
    public function setPriceCostInfoCostStatistics(\StructType\PriceCostInfoCostStatistics $priceCostInfoCostStatistics = null)
    {
        $this->PriceCostInfoCostStatistics = $priceCostInfoCostStatistics;
        return $this;
    }
    /**
     * Get WarehouseDetails value
     * @return \StructType\WarehouseDetails|null
     */
    public function getWarehouseDetails()
    {
        return $this->WarehouseDetails;
    }
    /**
     * Set WarehouseDetails value
     * @param \StructType\WarehouseDetails $warehouseDetails
     * @return \StructType\Content
     */
    public function setWarehouseDetails(\StructType\WarehouseDetails $warehouseDetails = null)
    {
        $this->WarehouseDetails = $warehouseDetails;
        return $this;
    }
    /**
     * Get ReplenishmentInfoReplenishmentParameters value
     * @return \StructType\ReplenishmentInfoReplenishmentParameters|null
     */
    public function getReplenishmentInfoReplenishmentParameters()
    {
        return $this->ReplenishmentInfoReplenishmentParameters;
    }
    /**
     * Set ReplenishmentInfoReplenishmentParameters value
     * @param \StructType\ReplenishmentInfoReplenishmentParameters $replenishmentInfoReplenishmentParameters
     * @return \StructType\Content
     */
    public function setReplenishmentInfoReplenishmentParameters(\StructType\ReplenishmentInfoReplenishmentParameters $replenishmentInfoReplenishmentParameters = null)
    {
        $this->ReplenishmentInfoReplenishmentParameters = $replenishmentInfoReplenishmentParameters;
        return $this;
    }
    /**
     * Get ReplenishmentInfoSubitemReplenishmentParameters value
     * @return \StructType\ReplenishmentInfoSubitemReplenishmentParameters|null
     */
    public function getReplenishmentInfoSubitemReplenishmentParameters()
    {
        return $this->ReplenishmentInfoSubitemReplenishmentParameters;
    }
    /**
     * Set ReplenishmentInfoSubitemReplenishmentParameters value
     * @param \StructType\ReplenishmentInfoSubitemReplenishmentParameters $replenishmentInfoSubitemReplenishmentParameters
     * @return \StructType\Content
     */
    public function setReplenishmentInfoSubitemReplenishmentParameters(\StructType\ReplenishmentInfoSubitemReplenishmentParameters $replenishmentInfoSubitemReplenishmentParameters = null)
    {
        $this->ReplenishmentInfoSubitemReplenishmentParameters = $replenishmentInfoSubitemReplenishmentParameters;
        return $this;
    }
    /**
     * Get PackagingAutomaticPackagingBoxes value
     * @return \StructType\PackagingAutomaticPackagingBoxes|null
     */
    public function getPackagingAutomaticPackagingBoxes()
    {
        return $this->PackagingAutomaticPackagingBoxes;
    }
    /**
     * Set PackagingAutomaticPackagingBoxes value
     * @param \StructType\PackagingAutomaticPackagingBoxes $packagingAutomaticPackagingBoxes
     * @return \StructType\Content
     */
    public function setPackagingAutomaticPackagingBoxes(\StructType\PackagingAutomaticPackagingBoxes $packagingAutomaticPackagingBoxes = null)
    {
        $this->PackagingAutomaticPackagingBoxes = $packagingAutomaticPackagingBoxes;
        return $this;
    }
    /**
     * Get RestrictionGroups value
     * @return \StructType\RestrictionGroups|null
     */
    public function getRestrictionGroups()
    {
        return $this->RestrictionGroups;
    }
    /**
     * Set RestrictionGroups value
     * @param \StructType\RestrictionGroups $restrictionGroups
     * @return \StructType\Content
     */
    public function setRestrictionGroups(\StructType\RestrictionGroups $restrictionGroups = null)
    {
        $this->RestrictionGroups = $restrictionGroups;
        return $this;
    }
    /**
     * Get RelatedItems value
     * @return \StructType\RelatedItems|null
     */
    public function getRelatedItems()
    {
        return $this->RelatedItems;
    }
    /**
     * Set RelatedItems value
     * @param \StructType\RelatedItems $relatedItems
     * @return \StructType\Content
     */
    public function setRelatedItems(\StructType\RelatedItems $relatedItems = null)
    {
        $this->RelatedItems = $relatedItems;
        return $this;
    }
    /**
     * Get SyncStatus value
     * @return \StructType\SyncStatus|null
     */
    public function getSyncStatus()
    {
        return $this->SyncStatus;
    }
    /**
     * Set SyncStatus value
     * @param \StructType\SyncStatus $syncStatus
     * @return \StructType\Content
     */
    public function setSyncStatus(\StructType\SyncStatus $syncStatus = null)
    {
        $this->SyncStatus = $syncStatus;
        return $this;
    }
    /**
     * Get SpecifyNewID value
     * @return \StructType\SpecifyNewID|null
     */
    public function getSpecifyNewID()
    {
        return $this->SpecifyNewID;
    }
    /**
     * Set SpecifyNewID value
     * @param \StructType\SpecifyNewID $specifyNewID
     * @return \StructType\Content
     */
    public function setSpecifyNewID(\StructType\SpecifyNewID $specifyNewID = null)
    {
        $this->SpecifyNewID = $specifyNewID;
        return $this;
    }
    /**
     * Get PriceCostInfoCostStatisticsRulesRUTAndRUTSettings value
     * @return \StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings|null
     */
    public function getPriceCostInfoCostStatisticsRulesRUTAndRUTSettings()
    {
        return $this->PriceCostInfoCostStatisticsRulesRUTAndRUTSettings;
    }
    /**
     * Set PriceCostInfoCostStatisticsRulesRUTAndRUTSettings value
     * @param \StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings $priceCostInfoCostStatisticsRulesRUTAndRUTSettings
     * @return \StructType\Content
     */
    public function setPriceCostInfoCostStatisticsRulesRUTAndRUTSettings(\StructType\PriceCostInfoCostStatisticsRulesRUTAndRUTSettings $priceCostInfoCostStatisticsRulesRUTAndRUTSettings = null)
    {
        $this->PriceCostInfoCostStatisticsRulesRUTAndRUTSettings = $priceCostInfoCostStatisticsRulesRUTAndRUTSettings;
        return $this;
    }
    /**
     * Get PriceCostInfoCostStatisticsRules value
     * @return \StructType\PriceCostInfoCostStatisticsRules|null
     */
    public function getPriceCostInfoCostStatisticsRules()
    {
        return $this->PriceCostInfoCostStatisticsRules;
    }
    /**
     * Set PriceCostInfoCostStatisticsRules value
     * @param \StructType\PriceCostInfoCostStatisticsRules $priceCostInfoCostStatisticsRules
     * @return \StructType\Content
     */
    public function setPriceCostInfoCostStatisticsRules(\StructType\PriceCostInfoCostStatisticsRules $priceCostInfoCostStatisticsRules = null)
    {
        $this->PriceCostInfoCostStatisticsRules = $priceCostInfoCostStatisticsRules;
        return $this;
    }
    /**
     * Get ServiceManagement value
     * @return \StructType\ServiceManagement|null
     */
    public function getServiceManagement()
    {
        return $this->ServiceManagement;
    }
    /**
     * Set ServiceManagement value
     * @param \StructType\ServiceManagement $serviceManagement
     * @return \StructType\Content
     */
    public function setServiceManagement(\StructType\ServiceManagement $serviceManagement = null)
    {
        $this->ServiceManagement = $serviceManagement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Content
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
