<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributes StructType
 * @subpackage Structs
 */
class Attributes extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Image;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AttributesServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Attributes
     * @uses Attributes::setDisplayName()
     * @uses Attributes::setImage()
     * @uses Attributes::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $image
     * @param \StructType\AttributesServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $image = null, \StructType\AttributesServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setImage($image)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Attributes
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\Field|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param \StructType\Field $image
     * @return \StructType\Attributes
     */
    public function setImage(\StructType\Field $image = null)
    {
        $this->Image = $image;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AttributesServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AttributesServiceCommands $serviceCommands
     * @return \StructType\Attributes
     */
    public function setServiceCommands(\StructType\AttributesServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
