<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommand ArrayType
 * @subpackage Arrays
 */
class ArrayOfCommand extends AbstractStructArrayBase
{
    /**
     * The Command
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Command[]
     */
    public $Command;
    /**
     * Constructor method for ArrayOfCommand
     * @uses ArrayOfCommand::setCommand()
     * @param \StructType\Command[] $command
     */
    public function __construct(array $command = array())
    {
        $this
            ->setCommand($command);
    }
    /**
     * Get Command value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Command[]|null
     */
    public function getCommand()
    {
        return isset($this->Command) ? $this->Command : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommand method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommand method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommandForArrayConstraintsFromSetCommand(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCommandCommandItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommandCommandItem instanceof \StructType\Command) {
                $invalidValues[] = is_object($arrayOfCommandCommandItem) ? get_class($arrayOfCommandCommandItem) : sprintf('%s(%s)', gettype($arrayOfCommandCommandItem), var_export($arrayOfCommandCommandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Command property can only contain items of type \StructType\Command, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Command value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Command[] $command
     * @return \ArrayType\ArrayOfCommand
     */
    public function setCommand(array $command = array())
    {
        // validation for constraint: array
        if ('' !== ($commandArrayErrorMessage = self::validateCommandForArrayConstraintsFromSetCommand($command))) {
            throw new \InvalidArgumentException($commandArrayErrorMessage, __LINE__);
        }
        if (is_null($command) || (is_array($command) && empty($command))) {
            unset($this->Command);
        } else {
            $this->Command = $command;
        }
        return $this;
    }
    /**
     * Add item to Command value
     * @throws \InvalidArgumentException
     * @param \StructType\Command $item
     * @return \ArrayType\ArrayOfCommand
     */
    public function addToCommand(\StructType\Command $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Command) {
            throw new \InvalidArgumentException(sprintf('The Command property can only contain items of type \StructType\Command, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Command[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Command|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Command|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Command|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Command|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Command|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Command
     */
    public function getAttributeName()
    {
        return 'Command';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCommand
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
