<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncStatus StructType
 * @subpackage Structs
 */
class SyncStatus extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The DataProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DataProvider;
    /**
     * The ExtRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExtRef;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Status;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Error;
    /**
     * The LatestAttempt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LatestAttempt;
    /**
     * The AttemptCounter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AttemptCounter;
    /**
     * The ImportScenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ImportScenario;
    /**
     * The ExportScenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExportScenario;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SyncStatusServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for SyncStatus
     * @uses SyncStatus::setDisplayName()
     * @uses SyncStatus::setDataProvider()
     * @uses SyncStatus::setExtRef()
     * @uses SyncStatus::setStatus()
     * @uses SyncStatus::setOperation()
     * @uses SyncStatus::setError()
     * @uses SyncStatus::setLatestAttempt()
     * @uses SyncStatus::setAttemptCounter()
     * @uses SyncStatus::setImportScenario()
     * @uses SyncStatus::setExportScenario()
     * @uses SyncStatus::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $dataProvider
     * @param \StructType\Field $extRef
     * @param \StructType\Field $status
     * @param \StructType\Field $operation
     * @param \StructType\Field $error
     * @param \StructType\Field $latestAttempt
     * @param \StructType\Field $attemptCounter
     * @param \StructType\Field $importScenario
     * @param \StructType\Field $exportScenario
     * @param \StructType\SyncStatusServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $dataProvider = null, \StructType\Field $extRef = null, \StructType\Field $status = null, \StructType\Field $operation = null, \StructType\Field $error = null, \StructType\Field $latestAttempt = null, \StructType\Field $attemptCounter = null, \StructType\Field $importScenario = null, \StructType\Field $exportScenario = null, \StructType\SyncStatusServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setDataProvider($dataProvider)
            ->setExtRef($extRef)
            ->setStatus($status)
            ->setOperation($operation)
            ->setError($error)
            ->setLatestAttempt($latestAttempt)
            ->setAttemptCounter($attemptCounter)
            ->setImportScenario($importScenario)
            ->setExportScenario($exportScenario)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\SyncStatus
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get DataProvider value
     * @return \StructType\Field|null
     */
    public function getDataProvider()
    {
        return $this->DataProvider;
    }
    /**
     * Set DataProvider value
     * @param \StructType\Field $dataProvider
     * @return \StructType\SyncStatus
     */
    public function setDataProvider(\StructType\Field $dataProvider = null)
    {
        $this->DataProvider = $dataProvider;
        return $this;
    }
    /**
     * Get ExtRef value
     * @return \StructType\Field|null
     */
    public function getExtRef()
    {
        return $this->ExtRef;
    }
    /**
     * Set ExtRef value
     * @param \StructType\Field $extRef
     * @return \StructType\SyncStatus
     */
    public function setExtRef(\StructType\Field $extRef = null)
    {
        $this->ExtRef = $extRef;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Field|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Field $status
     * @return \StructType\SyncStatus
     */
    public function setStatus(\StructType\Field $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\SyncStatus
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get Error value
     * @return \StructType\Field|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \StructType\Field $error
     * @return \StructType\SyncStatus
     */
    public function setError(\StructType\Field $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Get LatestAttempt value
     * @return \StructType\Field|null
     */
    public function getLatestAttempt()
    {
        return $this->LatestAttempt;
    }
    /**
     * Set LatestAttempt value
     * @param \StructType\Field $latestAttempt
     * @return \StructType\SyncStatus
     */
    public function setLatestAttempt(\StructType\Field $latestAttempt = null)
    {
        $this->LatestAttempt = $latestAttempt;
        return $this;
    }
    /**
     * Get AttemptCounter value
     * @return \StructType\Field|null
     */
    public function getAttemptCounter()
    {
        return $this->AttemptCounter;
    }
    /**
     * Set AttemptCounter value
     * @param \StructType\Field $attemptCounter
     * @return \StructType\SyncStatus
     */
    public function setAttemptCounter(\StructType\Field $attemptCounter = null)
    {
        $this->AttemptCounter = $attemptCounter;
        return $this;
    }
    /**
     * Get ImportScenario value
     * @return \StructType\Field|null
     */
    public function getImportScenario()
    {
        return $this->ImportScenario;
    }
    /**
     * Set ImportScenario value
     * @param \StructType\Field $importScenario
     * @return \StructType\SyncStatus
     */
    public function setImportScenario(\StructType\Field $importScenario = null)
    {
        $this->ImportScenario = $importScenario;
        return $this;
    }
    /**
     * Get ExportScenario value
     * @return \StructType\Field|null
     */
    public function getExportScenario()
    {
        return $this->ExportScenario;
    }
    /**
     * Set ExportScenario value
     * @param \StructType\Field $exportScenario
     * @return \StructType\SyncStatus
     */
    public function setExportScenario(\StructType\Field $exportScenario = null)
    {
        $this->ExportScenario = $exportScenario;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\SyncStatusServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\SyncStatusServiceCommands $serviceCommands
     * @return \StructType\SyncStatus
     */
    public function setServiceCommands(\StructType\SyncStatusServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SyncStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
