<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScenario StructType
 * @subpackage Structs
 */
class GetScenario extends AbstractStructBase
{
    /**
     * The scenario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scenario;
    /**
     * Constructor method for GetScenario
     * @uses GetScenario::setScenario()
     * @param string $scenario
     */
    public function __construct($scenario = null)
    {
        $this
            ->setScenario($scenario);
    }
    /**
     * Get scenario value
     * @return string|null
     */
    public function getScenario()
    {
        return $this->scenario;
    }
    /**
     * Set scenario value
     * @param string $scenario
     * @return \StructType\GetScenario
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        $this->scenario = $scenario;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetScenario
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
