<?php

namespace Capitole\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The loyerMensuel
     * @var float
     */
    public $loyerMensuel;
    /**
     * The ADIIT
     * @var float
     */
    public $ADIIT;
    /**
     * The deces_seul
     * @var float
     */
    public $deces_seul;
    /**
     * The perte_total
     * @var float
     */
    public $perte_total;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * The valeurRachat
     * @var float
     */
    public $valeurRachat;
    /**
     * The prix_capitole_finance
     * @var float
     */
    public $prix_capitole_finance;
    /**
     * The cout_total
     * @var float
     */
    public $cout_total;
    /**
     * The frais_dossier
     * @var float
     */
    public $frais_dossier;
    /**
     * The nb_loyer
     * @var int
     */
    public $nb_loyer;
    /**
     * The premier_loyer
     * @var float
     */
    public $premier_loyer;
    /**
     * The prix_carte_grise
     * @var float
     */
    public $prix_carte_grise;
    /**
     * The taux_perte_total
     * @var float
     */
    public $taux_perte_total;
    /**
     * The ADIIT_locataire
     * @var float
     */
    public $ADIIT_locataire;
    /**
     * The ADIIT_colocataire
     * @var float
     */
    public $ADIIT_colocataire;
    /**
     * The deces_seul_locataire
     * @var float
     */
    public $deces_seul_locataire;
    /**
     * The deces_seul_colocataire
     * @var float
     */
    public $deces_seul_colocataire;
    /**
     * The natixis_ADIIT_locataire
     * @var float
     */
    public $natixis_ADIIT_locataire;
    /**
     * The natixis_ADIIT_colocataire
     * @var float
     */
    public $natixis_ADIIT_colocataire;
    /**
     * The natixis_deces_seul_locataire
     * @var float
     */
    public $natixis_deces_seul_locataire;
    /**
     * The natixis_deces_seul_colocataire
     * @var float
     */
    public $natixis_deces_seul_colocataire;
    /**
     * The natixis_perte_total
     * @var float
     */
    public $natixis_perte_total;
    /**
     * The taux_ADIIT_locataire
     * @var float
     */
    public $taux_ADIIT_locataire;
    /**
     * The taux_ADIIT_colocataire
     * @var float
     */
    public $taux_ADIIT_colocataire;
    /**
     * The taux_deces_seul_locataire
     * @var float
     */
    public $taux_deces_seul_locataire;
    /**
     * The taux_deces_seul_colocataire
     * @var float
     */
    public $taux_deces_seul_colocataire;
    /**
     * The taux_natixis_ADIIT_locataire
     * @var float
     */
    public $taux_natixis_ADIIT_locataire;
    /**
     * The taux_natixis_ADIIT_colocataire
     * @var float
     */
    public $taux_natixis_ADIIT_colocataire;
    /**
     * The taux_natixis_deces_seul_locataire
     * @var float
     */
    public $taux_natixis_deces_seul_locataire;
    /**
     * The taux_natixis_deces_seul_colocataire
     * @var float
     */
    public $taux_natixis_deces_seul_colocataire;
    /**
     * The taux_natixis_perte_total
     * @var float
     */
    public $taux_natixis_perte_total;
    /**
     * The marge_aleatoire_pourcent
     * @var float
     */
    public $marge_aleatoire_pourcent;
    /**
     * The tdf_pourcent
     * @var float
     */
    public $tdf_pourcent;
    /**
     * The montant_commission
     * @var float
     */
    public $montant_commission;
    /**
     * The prestations_opteven
     * Meta information extracted from the WSDL
     * - arrayType: tns:Prestation[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var \Capitole\StructType\Prestation[]
     */
    public $prestations_opteven;
    /**
     * Constructor method for Result
     * @uses Result::setLoyerMensuel()
     * @uses Result::setADIIT()
     * @uses Result::setDeces_seul()
     * @uses Result::setPerte_total()
     * @uses Result::setMessage()
     * @uses Result::setValeurRachat()
     * @uses Result::setPrix_capitole_finance()
     * @uses Result::setCout_total()
     * @uses Result::setFrais_dossier()
     * @uses Result::setNb_loyer()
     * @uses Result::setPremier_loyer()
     * @uses Result::setPrix_carte_grise()
     * @uses Result::setTaux_perte_total()
     * @uses Result::setADIIT_locataire()
     * @uses Result::setADIIT_colocataire()
     * @uses Result::setDeces_seul_locataire()
     * @uses Result::setDeces_seul_colocataire()
     * @uses Result::setNatixis_ADIIT_locataire()
     * @uses Result::setNatixis_ADIIT_colocataire()
     * @uses Result::setNatixis_deces_seul_locataire()
     * @uses Result::setNatixis_deces_seul_colocataire()
     * @uses Result::setNatixis_perte_total()
     * @uses Result::setTaux_ADIIT_locataire()
     * @uses Result::setTaux_ADIIT_colocataire()
     * @uses Result::setTaux_deces_seul_locataire()
     * @uses Result::setTaux_deces_seul_colocataire()
     * @uses Result::setTaux_natixis_ADIIT_locataire()
     * @uses Result::setTaux_natixis_ADIIT_colocataire()
     * @uses Result::setTaux_natixis_deces_seul_locataire()
     * @uses Result::setTaux_natixis_deces_seul_colocataire()
     * @uses Result::setTaux_natixis_perte_total()
     * @uses Result::setMarge_aleatoire_pourcent()
     * @uses Result::setTdf_pourcent()
     * @uses Result::setMontant_commission()
     * @uses Result::setPrestations_opteven()
     * @param float $loyerMensuel
     * @param float $aDIIT
     * @param float $deces_seul
     * @param float $perte_total
     * @param string $message
     * @param float $valeurRachat
     * @param float $prix_capitole_finance
     * @param float $cout_total
     * @param float $frais_dossier
     * @param int $nb_loyer
     * @param float $premier_loyer
     * @param float $prix_carte_grise
     * @param float $taux_perte_total
     * @param float $aDIIT_locataire
     * @param float $aDIIT_colocataire
     * @param float $deces_seul_locataire
     * @param float $deces_seul_colocataire
     * @param float $natixis_ADIIT_locataire
     * @param float $natixis_ADIIT_colocataire
     * @param float $natixis_deces_seul_locataire
     * @param float $natixis_deces_seul_colocataire
     * @param float $natixis_perte_total
     * @param float $taux_ADIIT_locataire
     * @param float $taux_ADIIT_colocataire
     * @param float $taux_deces_seul_locataire
     * @param float $taux_deces_seul_colocataire
     * @param float $taux_natixis_ADIIT_locataire
     * @param float $taux_natixis_ADIIT_colocataire
     * @param float $taux_natixis_deces_seul_locataire
     * @param float $taux_natixis_deces_seul_colocataire
     * @param float $taux_natixis_perte_total
     * @param float $marge_aleatoire_pourcent
     * @param float $tdf_pourcent
     * @param float $montant_commission
     * @param \Capitole\StructType\Prestation[] $prestations_opteven
     */
    public function __construct($loyerMensuel = null, $aDIIT = null, $deces_seul = null, $perte_total = null, $message = null, $valeurRachat = null, $prix_capitole_finance = null, $cout_total = null, $frais_dossier = null, $nb_loyer = null, $premier_loyer = null, $prix_carte_grise = null, $taux_perte_total = null, $aDIIT_locataire = null, $aDIIT_colocataire = null, $deces_seul_locataire = null, $deces_seul_colocataire = null, $natixis_ADIIT_locataire = null, $natixis_ADIIT_colocataire = null, $natixis_deces_seul_locataire = null, $natixis_deces_seul_colocataire = null, $natixis_perte_total = null, $taux_ADIIT_locataire = null, $taux_ADIIT_colocataire = null, $taux_deces_seul_locataire = null, $taux_deces_seul_colocataire = null, $taux_natixis_ADIIT_locataire = null, $taux_natixis_ADIIT_colocataire = null, $taux_natixis_deces_seul_locataire = null, $taux_natixis_deces_seul_colocataire = null, $taux_natixis_perte_total = null, $marge_aleatoire_pourcent = null, $tdf_pourcent = null, $montant_commission = null, array $prestations_opteven = array())
    {
        $this
            ->setLoyerMensuel($loyerMensuel)
            ->setADIIT($aDIIT)
            ->setDeces_seul($deces_seul)
            ->setPerte_total($perte_total)
            ->setMessage($message)
            ->setValeurRachat($valeurRachat)
            ->setPrix_capitole_finance($prix_capitole_finance)
            ->setCout_total($cout_total)
            ->setFrais_dossier($frais_dossier)
            ->setNb_loyer($nb_loyer)
            ->setPremier_loyer($premier_loyer)
            ->setPrix_carte_grise($prix_carte_grise)
            ->setTaux_perte_total($taux_perte_total)
            ->setADIIT_locataire($aDIIT_locataire)
            ->setADIIT_colocataire($aDIIT_colocataire)
            ->setDeces_seul_locataire($deces_seul_locataire)
            ->setDeces_seul_colocataire($deces_seul_colocataire)
            ->setNatixis_ADIIT_locataire($natixis_ADIIT_locataire)
            ->setNatixis_ADIIT_colocataire($natixis_ADIIT_colocataire)
            ->setNatixis_deces_seul_locataire($natixis_deces_seul_locataire)
            ->setNatixis_deces_seul_colocataire($natixis_deces_seul_colocataire)
            ->setNatixis_perte_total($natixis_perte_total)
            ->setTaux_ADIIT_locataire($taux_ADIIT_locataire)
            ->setTaux_ADIIT_colocataire($taux_ADIIT_colocataire)
            ->setTaux_deces_seul_locataire($taux_deces_seul_locataire)
            ->setTaux_deces_seul_colocataire($taux_deces_seul_colocataire)
            ->setTaux_natixis_ADIIT_locataire($taux_natixis_ADIIT_locataire)
            ->setTaux_natixis_ADIIT_colocataire($taux_natixis_ADIIT_colocataire)
            ->setTaux_natixis_deces_seul_locataire($taux_natixis_deces_seul_locataire)
            ->setTaux_natixis_deces_seul_colocataire($taux_natixis_deces_seul_colocataire)
            ->setTaux_natixis_perte_total($taux_natixis_perte_total)
            ->setMarge_aleatoire_pourcent($marge_aleatoire_pourcent)
            ->setTdf_pourcent($tdf_pourcent)
            ->setMontant_commission($montant_commission)
            ->setPrestations_opteven($prestations_opteven);
    }
    /**
     * Get loyerMensuel value
     * @return float|null
     */
    public function getLoyerMensuel()
    {
        return $this->loyerMensuel;
    }
    /**
     * Set loyerMensuel value
     * @param float $loyerMensuel
     * @return \Capitole\StructType\Result
     */
    public function setLoyerMensuel($loyerMensuel = null)
    {
        // validation for constraint: float
        if (!is_null($loyerMensuel) && !(is_float($loyerMensuel) || is_numeric($loyerMensuel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyerMensuel, true), gettype($loyerMensuel)), __LINE__);
        }
        $this->loyerMensuel = $loyerMensuel;
        return $this;
    }
    /**
     * Get ADIIT value
     * @return float|null
     */
    public function getADIIT()
    {
        return $this->ADIIT;
    }
    /**
     * Set ADIIT value
     * @param float $aDIIT
     * @return \Capitole\StructType\Result
     */
    public function setADIIT($aDIIT = null)
    {
        // validation for constraint: float
        if (!is_null($aDIIT) && !(is_float($aDIIT) || is_numeric($aDIIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDIIT, true), gettype($aDIIT)), __LINE__);
        }
        $this->ADIIT = $aDIIT;
        return $this;
    }
    /**
     * Get deces_seul value
     * @return float|null
     */
    public function getDeces_seul()
    {
        return $this->deces_seul;
    }
    /**
     * Set deces_seul value
     * @param float $deces_seul
     * @return \Capitole\StructType\Result
     */
    public function setDeces_seul($deces_seul = null)
    {
        // validation for constraint: float
        if (!is_null($deces_seul) && !(is_float($deces_seul) || is_numeric($deces_seul))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deces_seul, true), gettype($deces_seul)), __LINE__);
        }
        $this->deces_seul = $deces_seul;
        return $this;
    }
    /**
     * Get perte_total value
     * @return float|null
     */
    public function getPerte_total()
    {
        return $this->perte_total;
    }
    /**
     * Set perte_total value
     * @param float $perte_total
     * @return \Capitole\StructType\Result
     */
    public function setPerte_total($perte_total = null)
    {
        // validation for constraint: float
        if (!is_null($perte_total) && !(is_float($perte_total) || is_numeric($perte_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($perte_total, true), gettype($perte_total)), __LINE__);
        }
        $this->perte_total = $perte_total;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \Capitole\StructType\Result
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get valeurRachat value
     * @return float|null
     */
    public function getValeurRachat()
    {
        return $this->valeurRachat;
    }
    /**
     * Set valeurRachat value
     * @param float $valeurRachat
     * @return \Capitole\StructType\Result
     */
    public function setValeurRachat($valeurRachat = null)
    {
        // validation for constraint: float
        if (!is_null($valeurRachat) && !(is_float($valeurRachat) || is_numeric($valeurRachat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valeurRachat, true), gettype($valeurRachat)), __LINE__);
        }
        $this->valeurRachat = $valeurRachat;
        return $this;
    }
    /**
     * Get prix_capitole_finance value
     * @return float|null
     */
    public function getPrix_capitole_finance()
    {
        return $this->prix_capitole_finance;
    }
    /**
     * Set prix_capitole_finance value
     * @param float $prix_capitole_finance
     * @return \Capitole\StructType\Result
     */
    public function setPrix_capitole_finance($prix_capitole_finance = null)
    {
        // validation for constraint: float
        if (!is_null($prix_capitole_finance) && !(is_float($prix_capitole_finance) || is_numeric($prix_capitole_finance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix_capitole_finance, true), gettype($prix_capitole_finance)), __LINE__);
        }
        $this->prix_capitole_finance = $prix_capitole_finance;
        return $this;
    }
    /**
     * Get cout_total value
     * @return float|null
     */
    public function getCout_total()
    {
        return $this->cout_total;
    }
    /**
     * Set cout_total value
     * @param float $cout_total
     * @return \Capitole\StructType\Result
     */
    public function setCout_total($cout_total = null)
    {
        // validation for constraint: float
        if (!is_null($cout_total) && !(is_float($cout_total) || is_numeric($cout_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cout_total, true), gettype($cout_total)), __LINE__);
        }
        $this->cout_total = $cout_total;
        return $this;
    }
    /**
     * Get frais_dossier value
     * @return float|null
     */
    public function getFrais_dossier()
    {
        return $this->frais_dossier;
    }
    /**
     * Set frais_dossier value
     * @param float $frais_dossier
     * @return \Capitole\StructType\Result
     */
    public function setFrais_dossier($frais_dossier = null)
    {
        // validation for constraint: float
        if (!is_null($frais_dossier) && !(is_float($frais_dossier) || is_numeric($frais_dossier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_dossier, true), gettype($frais_dossier)), __LINE__);
        }
        $this->frais_dossier = $frais_dossier;
        return $this;
    }
    /**
     * Get nb_loyer value
     * @return int|null
     */
    public function getNb_loyer()
    {
        return $this->nb_loyer;
    }
    /**
     * Set nb_loyer value
     * @param int $nb_loyer
     * @return \Capitole\StructType\Result
     */
    public function setNb_loyer($nb_loyer = null)
    {
        // validation for constraint: int
        if (!is_null($nb_loyer) && !(is_int($nb_loyer) || ctype_digit($nb_loyer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nb_loyer, true), gettype($nb_loyer)), __LINE__);
        }
        $this->nb_loyer = $nb_loyer;
        return $this;
    }
    /**
     * Get premier_loyer value
     * @return float|null
     */
    public function getPremier_loyer()
    {
        return $this->premier_loyer;
    }
    /**
     * Set premier_loyer value
     * @param float $premier_loyer
     * @return \Capitole\StructType\Result
     */
    public function setPremier_loyer($premier_loyer = null)
    {
        // validation for constraint: float
        if (!is_null($premier_loyer) && !(is_float($premier_loyer) || is_numeric($premier_loyer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premier_loyer, true), gettype($premier_loyer)), __LINE__);
        }
        $this->premier_loyer = $premier_loyer;
        return $this;
    }
    /**
     * Get prix_carte_grise value
     * @return float|null
     */
    public function getPrix_carte_grise()
    {
        return $this->prix_carte_grise;
    }
    /**
     * Set prix_carte_grise value
     * @param float $prix_carte_grise
     * @return \Capitole\StructType\Result
     */
    public function setPrix_carte_grise($prix_carte_grise = null)
    {
        // validation for constraint: float
        if (!is_null($prix_carte_grise) && !(is_float($prix_carte_grise) || is_numeric($prix_carte_grise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix_carte_grise, true), gettype($prix_carte_grise)), __LINE__);
        }
        $this->prix_carte_grise = $prix_carte_grise;
        return $this;
    }
    /**
     * Get taux_perte_total value
     * @return float|null
     */
    public function getTaux_perte_total()
    {
        return $this->taux_perte_total;
    }
    /**
     * Set taux_perte_total value
     * @param float $taux_perte_total
     * @return \Capitole\StructType\Result
     */
    public function setTaux_perte_total($taux_perte_total = null)
    {
        // validation for constraint: float
        if (!is_null($taux_perte_total) && !(is_float($taux_perte_total) || is_numeric($taux_perte_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_perte_total, true), gettype($taux_perte_total)), __LINE__);
        }
        $this->taux_perte_total = $taux_perte_total;
        return $this;
    }
    /**
     * Get ADIIT_locataire value
     * @return float|null
     */
    public function getADIIT_locataire()
    {
        return $this->ADIIT_locataire;
    }
    /**
     * Set ADIIT_locataire value
     * @param float $aDIIT_locataire
     * @return \Capitole\StructType\Result
     */
    public function setADIIT_locataire($aDIIT_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($aDIIT_locataire) && !(is_float($aDIIT_locataire) || is_numeric($aDIIT_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDIIT_locataire, true), gettype($aDIIT_locataire)), __LINE__);
        }
        $this->ADIIT_locataire = $aDIIT_locataire;
        return $this;
    }
    /**
     * Get ADIIT_colocataire value
     * @return float|null
     */
    public function getADIIT_colocataire()
    {
        return $this->ADIIT_colocataire;
    }
    /**
     * Set ADIIT_colocataire value
     * @param float $aDIIT_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setADIIT_colocataire($aDIIT_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($aDIIT_colocataire) && !(is_float($aDIIT_colocataire) || is_numeric($aDIIT_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDIIT_colocataire, true), gettype($aDIIT_colocataire)), __LINE__);
        }
        $this->ADIIT_colocataire = $aDIIT_colocataire;
        return $this;
    }
    /**
     * Get deces_seul_locataire value
     * @return float|null
     */
    public function getDeces_seul_locataire()
    {
        return $this->deces_seul_locataire;
    }
    /**
     * Set deces_seul_locataire value
     * @param float $deces_seul_locataire
     * @return \Capitole\StructType\Result
     */
    public function setDeces_seul_locataire($deces_seul_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($deces_seul_locataire) && !(is_float($deces_seul_locataire) || is_numeric($deces_seul_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deces_seul_locataire, true), gettype($deces_seul_locataire)), __LINE__);
        }
        $this->deces_seul_locataire = $deces_seul_locataire;
        return $this;
    }
    /**
     * Get deces_seul_colocataire value
     * @return float|null
     */
    public function getDeces_seul_colocataire()
    {
        return $this->deces_seul_colocataire;
    }
    /**
     * Set deces_seul_colocataire value
     * @param float $deces_seul_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setDeces_seul_colocataire($deces_seul_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($deces_seul_colocataire) && !(is_float($deces_seul_colocataire) || is_numeric($deces_seul_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($deces_seul_colocataire, true), gettype($deces_seul_colocataire)), __LINE__);
        }
        $this->deces_seul_colocataire = $deces_seul_colocataire;
        return $this;
    }
    /**
     * Get natixis_ADIIT_locataire value
     * @return float|null
     */
    public function getNatixis_ADIIT_locataire()
    {
        return $this->natixis_ADIIT_locataire;
    }
    /**
     * Set natixis_ADIIT_locataire value
     * @param float $natixis_ADIIT_locataire
     * @return \Capitole\StructType\Result
     */
    public function setNatixis_ADIIT_locataire($natixis_ADIIT_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($natixis_ADIIT_locataire) && !(is_float($natixis_ADIIT_locataire) || is_numeric($natixis_ADIIT_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($natixis_ADIIT_locataire, true), gettype($natixis_ADIIT_locataire)), __LINE__);
        }
        $this->natixis_ADIIT_locataire = $natixis_ADIIT_locataire;
        return $this;
    }
    /**
     * Get natixis_ADIIT_colocataire value
     * @return float|null
     */
    public function getNatixis_ADIIT_colocataire()
    {
        return $this->natixis_ADIIT_colocataire;
    }
    /**
     * Set natixis_ADIIT_colocataire value
     * @param float $natixis_ADIIT_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setNatixis_ADIIT_colocataire($natixis_ADIIT_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($natixis_ADIIT_colocataire) && !(is_float($natixis_ADIIT_colocataire) || is_numeric($natixis_ADIIT_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($natixis_ADIIT_colocataire, true), gettype($natixis_ADIIT_colocataire)), __LINE__);
        }
        $this->natixis_ADIIT_colocataire = $natixis_ADIIT_colocataire;
        return $this;
    }
    /**
     * Get natixis_deces_seul_locataire value
     * @return float|null
     */
    public function getNatixis_deces_seul_locataire()
    {
        return $this->natixis_deces_seul_locataire;
    }
    /**
     * Set natixis_deces_seul_locataire value
     * @param float $natixis_deces_seul_locataire
     * @return \Capitole\StructType\Result
     */
    public function setNatixis_deces_seul_locataire($natixis_deces_seul_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($natixis_deces_seul_locataire) && !(is_float($natixis_deces_seul_locataire) || is_numeric($natixis_deces_seul_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($natixis_deces_seul_locataire, true), gettype($natixis_deces_seul_locataire)), __LINE__);
        }
        $this->natixis_deces_seul_locataire = $natixis_deces_seul_locataire;
        return $this;
    }
    /**
     * Get natixis_deces_seul_colocataire value
     * @return float|null
     */
    public function getNatixis_deces_seul_colocataire()
    {
        return $this->natixis_deces_seul_colocataire;
    }
    /**
     * Set natixis_deces_seul_colocataire value
     * @param float $natixis_deces_seul_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setNatixis_deces_seul_colocataire($natixis_deces_seul_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($natixis_deces_seul_colocataire) && !(is_float($natixis_deces_seul_colocataire) || is_numeric($natixis_deces_seul_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($natixis_deces_seul_colocataire, true), gettype($natixis_deces_seul_colocataire)), __LINE__);
        }
        $this->natixis_deces_seul_colocataire = $natixis_deces_seul_colocataire;
        return $this;
    }
    /**
     * Get natixis_perte_total value
     * @return float|null
     */
    public function getNatixis_perte_total()
    {
        return $this->natixis_perte_total;
    }
    /**
     * Set natixis_perte_total value
     * @param float $natixis_perte_total
     * @return \Capitole\StructType\Result
     */
    public function setNatixis_perte_total($natixis_perte_total = null)
    {
        // validation for constraint: float
        if (!is_null($natixis_perte_total) && !(is_float($natixis_perte_total) || is_numeric($natixis_perte_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($natixis_perte_total, true), gettype($natixis_perte_total)), __LINE__);
        }
        $this->natixis_perte_total = $natixis_perte_total;
        return $this;
    }
    /**
     * Get taux_ADIIT_locataire value
     * @return float|null
     */
    public function getTaux_ADIIT_locataire()
    {
        return $this->taux_ADIIT_locataire;
    }
    /**
     * Set taux_ADIIT_locataire value
     * @param float $taux_ADIIT_locataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_ADIIT_locataire($taux_ADIIT_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_ADIIT_locataire) && !(is_float($taux_ADIIT_locataire) || is_numeric($taux_ADIIT_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_ADIIT_locataire, true), gettype($taux_ADIIT_locataire)), __LINE__);
        }
        $this->taux_ADIIT_locataire = $taux_ADIIT_locataire;
        return $this;
    }
    /**
     * Get taux_ADIIT_colocataire value
     * @return float|null
     */
    public function getTaux_ADIIT_colocataire()
    {
        return $this->taux_ADIIT_colocataire;
    }
    /**
     * Set taux_ADIIT_colocataire value
     * @param float $taux_ADIIT_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_ADIIT_colocataire($taux_ADIIT_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_ADIIT_colocataire) && !(is_float($taux_ADIIT_colocataire) || is_numeric($taux_ADIIT_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_ADIIT_colocataire, true), gettype($taux_ADIIT_colocataire)), __LINE__);
        }
        $this->taux_ADIIT_colocataire = $taux_ADIIT_colocataire;
        return $this;
    }
    /**
     * Get taux_deces_seul_locataire value
     * @return float|null
     */
    public function getTaux_deces_seul_locataire()
    {
        return $this->taux_deces_seul_locataire;
    }
    /**
     * Set taux_deces_seul_locataire value
     * @param float $taux_deces_seul_locataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_deces_seul_locataire($taux_deces_seul_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_deces_seul_locataire) && !(is_float($taux_deces_seul_locataire) || is_numeric($taux_deces_seul_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_deces_seul_locataire, true), gettype($taux_deces_seul_locataire)), __LINE__);
        }
        $this->taux_deces_seul_locataire = $taux_deces_seul_locataire;
        return $this;
    }
    /**
     * Get taux_deces_seul_colocataire value
     * @return float|null
     */
    public function getTaux_deces_seul_colocataire()
    {
        return $this->taux_deces_seul_colocataire;
    }
    /**
     * Set taux_deces_seul_colocataire value
     * @param float $taux_deces_seul_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_deces_seul_colocataire($taux_deces_seul_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_deces_seul_colocataire) && !(is_float($taux_deces_seul_colocataire) || is_numeric($taux_deces_seul_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_deces_seul_colocataire, true), gettype($taux_deces_seul_colocataire)), __LINE__);
        }
        $this->taux_deces_seul_colocataire = $taux_deces_seul_colocataire;
        return $this;
    }
    /**
     * Get taux_natixis_ADIIT_locataire value
     * @return float|null
     */
    public function getTaux_natixis_ADIIT_locataire()
    {
        return $this->taux_natixis_ADIIT_locataire;
    }
    /**
     * Set taux_natixis_ADIIT_locataire value
     * @param float $taux_natixis_ADIIT_locataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_natixis_ADIIT_locataire($taux_natixis_ADIIT_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_natixis_ADIIT_locataire) && !(is_float($taux_natixis_ADIIT_locataire) || is_numeric($taux_natixis_ADIIT_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_natixis_ADIIT_locataire, true), gettype($taux_natixis_ADIIT_locataire)), __LINE__);
        }
        $this->taux_natixis_ADIIT_locataire = $taux_natixis_ADIIT_locataire;
        return $this;
    }
    /**
     * Get taux_natixis_ADIIT_colocataire value
     * @return float|null
     */
    public function getTaux_natixis_ADIIT_colocataire()
    {
        return $this->taux_natixis_ADIIT_colocataire;
    }
    /**
     * Set taux_natixis_ADIIT_colocataire value
     * @param float $taux_natixis_ADIIT_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_natixis_ADIIT_colocataire($taux_natixis_ADIIT_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_natixis_ADIIT_colocataire) && !(is_float($taux_natixis_ADIIT_colocataire) || is_numeric($taux_natixis_ADIIT_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_natixis_ADIIT_colocataire, true), gettype($taux_natixis_ADIIT_colocataire)), __LINE__);
        }
        $this->taux_natixis_ADIIT_colocataire = $taux_natixis_ADIIT_colocataire;
        return $this;
    }
    /**
     * Get taux_natixis_deces_seul_locataire value
     * @return float|null
     */
    public function getTaux_natixis_deces_seul_locataire()
    {
        return $this->taux_natixis_deces_seul_locataire;
    }
    /**
     * Set taux_natixis_deces_seul_locataire value
     * @param float $taux_natixis_deces_seul_locataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_natixis_deces_seul_locataire($taux_natixis_deces_seul_locataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_natixis_deces_seul_locataire) && !(is_float($taux_natixis_deces_seul_locataire) || is_numeric($taux_natixis_deces_seul_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_natixis_deces_seul_locataire, true), gettype($taux_natixis_deces_seul_locataire)), __LINE__);
        }
        $this->taux_natixis_deces_seul_locataire = $taux_natixis_deces_seul_locataire;
        return $this;
    }
    /**
     * Get taux_natixis_deces_seul_colocataire value
     * @return float|null
     */
    public function getTaux_natixis_deces_seul_colocataire()
    {
        return $this->taux_natixis_deces_seul_colocataire;
    }
    /**
     * Set taux_natixis_deces_seul_colocataire value
     * @param float $taux_natixis_deces_seul_colocataire
     * @return \Capitole\StructType\Result
     */
    public function setTaux_natixis_deces_seul_colocataire($taux_natixis_deces_seul_colocataire = null)
    {
        // validation for constraint: float
        if (!is_null($taux_natixis_deces_seul_colocataire) && !(is_float($taux_natixis_deces_seul_colocataire) || is_numeric($taux_natixis_deces_seul_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_natixis_deces_seul_colocataire, true), gettype($taux_natixis_deces_seul_colocataire)), __LINE__);
        }
        $this->taux_natixis_deces_seul_colocataire = $taux_natixis_deces_seul_colocataire;
        return $this;
    }
    /**
     * Get taux_natixis_perte_total value
     * @return float|null
     */
    public function getTaux_natixis_perte_total()
    {
        return $this->taux_natixis_perte_total;
    }
    /**
     * Set taux_natixis_perte_total value
     * @param float $taux_natixis_perte_total
     * @return \Capitole\StructType\Result
     */
    public function setTaux_natixis_perte_total($taux_natixis_perte_total = null)
    {
        // validation for constraint: float
        if (!is_null($taux_natixis_perte_total) && !(is_float($taux_natixis_perte_total) || is_numeric($taux_natixis_perte_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux_natixis_perte_total, true), gettype($taux_natixis_perte_total)), __LINE__);
        }
        $this->taux_natixis_perte_total = $taux_natixis_perte_total;
        return $this;
    }
    /**
     * Get marge_aleatoire_pourcent value
     * @return float|null
     */
    public function getMarge_aleatoire_pourcent()
    {
        return $this->marge_aleatoire_pourcent;
    }
    /**
     * Set marge_aleatoire_pourcent value
     * @param float $marge_aleatoire_pourcent
     * @return \Capitole\StructType\Result
     */
    public function setMarge_aleatoire_pourcent($marge_aleatoire_pourcent = null)
    {
        // validation for constraint: float
        if (!is_null($marge_aleatoire_pourcent) && !(is_float($marge_aleatoire_pourcent) || is_numeric($marge_aleatoire_pourcent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($marge_aleatoire_pourcent, true), gettype($marge_aleatoire_pourcent)), __LINE__);
        }
        $this->marge_aleatoire_pourcent = $marge_aleatoire_pourcent;
        return $this;
    }
    /**
     * Get tdf_pourcent value
     * @return float|null
     */
    public function getTdf_pourcent()
    {
        return $this->tdf_pourcent;
    }
    /**
     * Set tdf_pourcent value
     * @param float $tdf_pourcent
     * @return \Capitole\StructType\Result
     */
    public function setTdf_pourcent($tdf_pourcent = null)
    {
        // validation for constraint: float
        if (!is_null($tdf_pourcent) && !(is_float($tdf_pourcent) || is_numeric($tdf_pourcent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tdf_pourcent, true), gettype($tdf_pourcent)), __LINE__);
        }
        $this->tdf_pourcent = $tdf_pourcent;
        return $this;
    }
    /**
     * Get montant_commission value
     * @return float|null
     */
    public function getMontant_commission()
    {
        return $this->montant_commission;
    }
    /**
     * Set montant_commission value
     * @param float $montant_commission
     * @return \Capitole\StructType\Result
     */
    public function setMontant_commission($montant_commission = null)
    {
        // validation for constraint: float
        if (!is_null($montant_commission) && !(is_float($montant_commission) || is_numeric($montant_commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant_commission, true), gettype($montant_commission)), __LINE__);
        }
        $this->montant_commission = $montant_commission;
        return $this;
    }
    /**
     * Get prestations_opteven value
     * @return \Capitole\StructType\Prestation[]|null
     */
    public function getPrestations_opteven()
    {
        return $this->prestations_opteven;
    }
    /**
     * This method is responsible for validating the values passed to the setPrestations_opteven method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrestations_opteven method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrestations_optevenForArrayConstraintsFromSetPrestations_opteven(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultPrestations_optevenItem) {
            // validation for constraint: itemType
            if (!$resultPrestations_optevenItem instanceof \Capitole\StructType\Prestation) {
                $invalidValues[] = is_object($resultPrestations_optevenItem) ? get_class($resultPrestations_optevenItem) : sprintf('%s(%s)', gettype($resultPrestations_optevenItem), var_export($resultPrestations_optevenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The prestations_opteven property can only contain items of type \Capitole\StructType\Prestation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set prestations_opteven value
     * @throws \InvalidArgumentException
     * @param \Capitole\StructType\Prestation[] $prestations_opteven
     * @return \Capitole\StructType\Result
     */
    public function setPrestations_opteven(array $prestations_opteven = array())
    {
        // validation for constraint: array
        if ('' !== ($prestations_optevenArrayErrorMessage = self::validatePrestations_optevenForArrayConstraintsFromSetPrestations_opteven($prestations_opteven))) {
            throw new \InvalidArgumentException($prestations_optevenArrayErrorMessage, __LINE__);
        }
        $this->prestations_opteven = $prestations_opteven;
        return $this;
    }
    /**
     * Add item to prestations_opteven value
     * @throws \InvalidArgumentException
     * @param \Capitole\StructType\Prestation $item
     * @return \Capitole\StructType\Result
     */
    public function addToPrestations_opteven(\Capitole\StructType\Prestation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Capitole\StructType\Prestation) {
            throw new \InvalidArgumentException(sprintf('The prestations_opteven property can only contain items of type \Capitole\StructType\Prestation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->prestations_opteven[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Capitole\StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
