<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requestImageTypes StructType
 * @subpackage Structs
 */
class RequestImageTypes extends AbstractStructBase
{
    /**
     * The thumbnail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $thumbnail;
    /**
     * The small
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $small;
    /**
     * The large
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $large;
    /**
     * Constructor method for requestImageTypes
     * @uses RequestImageTypes::setThumbnail()
     * @uses RequestImageTypes::setSmall()
     * @uses RequestImageTypes::setLarge()
     * @param bool $thumbnail
     * @param bool $small
     * @param bool $large
     */
    public function __construct($thumbnail = null, $small = null, $large = null)
    {
        $this
            ->setThumbnail($thumbnail)
            ->setSmall($small)
            ->setLarge($large);
    }
    /**
     * Get thumbnail value
     * @return bool|null
     */
    public function getThumbnail()
    {
        return $this->thumbnail;
    }
    /**
     * Set thumbnail value
     * @param bool $thumbnail
     * @return \ATDConnect\StructType\RequestImageTypes
     */
    public function setThumbnail($thumbnail = null)
    {
        // validation for constraint: boolean
        if (!is_null($thumbnail) && !is_bool($thumbnail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thumbnail, true), gettype($thumbnail)), __LINE__);
        }
        $this->thumbnail = $thumbnail;
        return $this;
    }
    /**
     * Get small value
     * @return bool|null
     */
    public function getSmall()
    {
        return $this->small;
    }
    /**
     * Set small value
     * @param bool $small
     * @return \ATDConnect\StructType\RequestImageTypes
     */
    public function setSmall($small = null)
    {
        // validation for constraint: boolean
        if (!is_null($small) && !is_bool($small)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($small, true), gettype($small)), __LINE__);
        }
        $this->small = $small;
        return $this;
    }
    /**
     * Get large value
     * @return bool|null
     */
    public function getLarge()
    {
        return $this->large;
    }
    /**
     * Set large value
     * @param bool $large
     * @return \ATDConnect\StructType\RequestImageTypes
     */
    public function setLarge($large = null)
    {
        // validation for constraint: boolean
        if (!is_null($large) && !is_bool($large)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($large, true), gettype($large)), __LINE__);
        }
        $this->large = $large;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\RequestImageTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
