<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The ATDProductNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ATDProductNumber;
    /**
     * The MFGProductNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MFGProductNumber;
    /**
     * The CustomerPartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPartNumber;
    /**
     * The style
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $style;
    /**
     * The brand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brand;
    /**
     * The productGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productGroup;
    /**
     * The discontinued
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $discontinued;
    /**
     * The replaced
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $replaced;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\Price
     */
    public $price;
    /**
     * The availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\Inventory
     */
    public $availability;
    /**
     * The images
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\ResponseImageTypes
     */
    public $images;
    /**
     * The marketingPrograms
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ATDConnect\StructType\MarketingProgram[]
     */
    public $marketingPrograms;
    /**
     * The productSpec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\CriteriaType
     */
    public $productSpec;
    /**
     * The rebates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ATDConnect\StructType\Rebate[]
     */
    public $rebates;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The preferredBrand
     * @var bool
     */
    public $preferredBrand;
    /**
     * The privateBrand
     * @var bool
     */
    public $privateBrand;
    /**
     * The flaggedBrand
     * @var bool
     */
    public $flaggedBrand;
    /**
     * Constructor method for product
     * @uses Product::setATDProductNumber()
     * @uses Product::setMFGProductNumber()
     * @uses Product::setCustomerPartNumber()
     * @uses Product::setStyle()
     * @uses Product::setBrand()
     * @uses Product::setProductGroup()
     * @uses Product::setDiscontinued()
     * @uses Product::setReplaced()
     * @uses Product::setDescription()
     * @uses Product::setPrice()
     * @uses Product::setAvailability()
     * @uses Product::setImages()
     * @uses Product::setMarketingPrograms()
     * @uses Product::setProductSpec()
     * @uses Product::setRebates()
     * @uses Product::setType()
     * @uses Product::setPreferredBrand()
     * @uses Product::setPrivateBrand()
     * @uses Product::setFlaggedBrand()
     * @param string $aTDProductNumber
     * @param string $mFGProductNumber
     * @param string $customerPartNumber
     * @param string $style
     * @param string $brand
     * @param string $productGroup
     * @param bool $discontinued
     * @param bool $replaced
     * @param string $description
     * @param \ATDConnect\StructType\Price $price
     * @param \ATDConnect\StructType\Inventory $availability
     * @param \ATDConnect\StructType\ResponseImageTypes $images
     * @param \ATDConnect\StructType\MarketingProgram[] $marketingPrograms
     * @param \ATDConnect\StructType\CriteriaType $productSpec
     * @param \ATDConnect\StructType\Rebate[] $rebates
     * @param string $type
     * @param bool $preferredBrand
     * @param bool $privateBrand
     * @param bool $flaggedBrand
     */
    public function __construct($aTDProductNumber = null, $mFGProductNumber = null, $customerPartNumber = null, $style = null, $brand = null, $productGroup = null, $discontinued = null, $replaced = null, $description = null, \ATDConnect\StructType\Price $price = null, \ATDConnect\StructType\Inventory $availability = null, \ATDConnect\StructType\ResponseImageTypes $images = null, array $marketingPrograms = array(), \ATDConnect\StructType\CriteriaType $productSpec = null, array $rebates = array(), $type = null, $preferredBrand = null, $privateBrand = null, $flaggedBrand = null)
    {
        $this
            ->setATDProductNumber($aTDProductNumber)
            ->setMFGProductNumber($mFGProductNumber)
            ->setCustomerPartNumber($customerPartNumber)
            ->setStyle($style)
            ->setBrand($brand)
            ->setProductGroup($productGroup)
            ->setDiscontinued($discontinued)
            ->setReplaced($replaced)
            ->setDescription($description)
            ->setPrice($price)
            ->setAvailability($availability)
            ->setImages($images)
            ->setMarketingPrograms($marketingPrograms)
            ->setProductSpec($productSpec)
            ->setRebates($rebates)
            ->setType($type)
            ->setPreferredBrand($preferredBrand)
            ->setPrivateBrand($privateBrand)
            ->setFlaggedBrand($flaggedBrand);
    }
    /**
     * Get ATDProductNumber value
     * @return string|null
     */
    public function getATDProductNumber()
    {
        return $this->ATDProductNumber;
    }
    /**
     * Set ATDProductNumber value
     * @param string $aTDProductNumber
     * @return \ATDConnect\StructType\Product
     */
    public function setATDProductNumber($aTDProductNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aTDProductNumber) && !is_string($aTDProductNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTDProductNumber, true), gettype($aTDProductNumber)), __LINE__);
        }
        $this->ATDProductNumber = $aTDProductNumber;
        return $this;
    }
    /**
     * Get MFGProductNumber value
     * @return string|null
     */
    public function getMFGProductNumber()
    {
        return $this->MFGProductNumber;
    }
    /**
     * Set MFGProductNumber value
     * @param string $mFGProductNumber
     * @return \ATDConnect\StructType\Product
     */
    public function setMFGProductNumber($mFGProductNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mFGProductNumber) && !is_string($mFGProductNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mFGProductNumber, true), gettype($mFGProductNumber)), __LINE__);
        }
        $this->MFGProductNumber = $mFGProductNumber;
        return $this;
    }
    /**
     * Get CustomerPartNumber value
     * @return string|null
     */
    public function getCustomerPartNumber()
    {
        return $this->CustomerPartNumber;
    }
    /**
     * Set CustomerPartNumber value
     * @param string $customerPartNumber
     * @return \ATDConnect\StructType\Product
     */
    public function setCustomerPartNumber($customerPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartNumber) && !is_string($customerPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartNumber, true), gettype($customerPartNumber)), __LINE__);
        }
        $this->CustomerPartNumber = $customerPartNumber;
        return $this;
    }
    /**
     * Get style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->style;
    }
    /**
     * Set style value
     * @param string $style
     * @return \ATDConnect\StructType\Product
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($style, true), gettype($style)), __LINE__);
        }
        $this->style = $style;
        return $this;
    }
    /**
     * Get brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->brand;
    }
    /**
     * Set brand value
     * @param string $brand
     * @return \ATDConnect\StructType\Product
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->brand = $brand;
        return $this;
    }
    /**
     * Get productGroup value
     * @return string|null
     */
    public function getProductGroup()
    {
        return $this->productGroup;
    }
    /**
     * Set productGroup value
     * @param string $productGroup
     * @return \ATDConnect\StructType\Product
     */
    public function setProductGroup($productGroup = null)
    {
        // validation for constraint: string
        if (!is_null($productGroup) && !is_string($productGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productGroup, true), gettype($productGroup)), __LINE__);
        }
        $this->productGroup = $productGroup;
        return $this;
    }
    /**
     * Get discontinued value
     * @return bool|null
     */
    public function getDiscontinued()
    {
        return $this->discontinued;
    }
    /**
     * Set discontinued value
     * @param bool $discontinued
     * @return \ATDConnect\StructType\Product
     */
    public function setDiscontinued($discontinued = null)
    {
        // validation for constraint: boolean
        if (!is_null($discontinued) && !is_bool($discontinued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($discontinued, true), gettype($discontinued)), __LINE__);
        }
        $this->discontinued = $discontinued;
        return $this;
    }
    /**
     * Get replaced value
     * @return bool|null
     */
    public function getReplaced()
    {
        return $this->replaced;
    }
    /**
     * Set replaced value
     * @param bool $replaced
     * @return \ATDConnect\StructType\Product
     */
    public function setReplaced($replaced = null)
    {
        // validation for constraint: boolean
        if (!is_null($replaced) && !is_bool($replaced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaced, true), gettype($replaced)), __LINE__);
        }
        $this->replaced = $replaced;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \ATDConnect\StructType\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return \ATDConnect\StructType\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \ATDConnect\StructType\Price $price
     * @return \ATDConnect\StructType\Product
     */
    public function setPrice(\ATDConnect\StructType\Price $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get availability value
     * @return \ATDConnect\StructType\Inventory|null
     */
    public function getAvailability()
    {
        return $this->availability;
    }
    /**
     * Set availability value
     * @param \ATDConnect\StructType\Inventory $availability
     * @return \ATDConnect\StructType\Product
     */
    public function setAvailability(\ATDConnect\StructType\Inventory $availability = null)
    {
        $this->availability = $availability;
        return $this;
    }
    /**
     * Get images value
     * @return \ATDConnect\StructType\ResponseImageTypes|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \ATDConnect\StructType\ResponseImageTypes $images
     * @return \ATDConnect\StructType\Product
     */
    public function setImages(\ATDConnect\StructType\ResponseImageTypes $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get marketingPrograms value
     * @return \ATDConnect\StructType\MarketingProgram[]|null
     */
    public function getMarketingPrograms()
    {
        return $this->marketingPrograms;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingPrograms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingPrograms method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingProgramsForArrayConstraintsFromSetMarketingPrograms(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productMarketingProgramsItem) {
            // validation for constraint: itemType
            if (!$productMarketingProgramsItem instanceof \ATDConnect\StructType\MarketingProgram) {
                $invalidValues[] = is_object($productMarketingProgramsItem) ? get_class($productMarketingProgramsItem) : sprintf('%s(%s)', gettype($productMarketingProgramsItem), var_export($productMarketingProgramsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The marketingPrograms property can only contain items of type \ATDConnect\StructType\MarketingProgram, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set marketingPrograms value
     * @throws \InvalidArgumentException
     * @param \ATDConnect\StructType\MarketingProgram[] $marketingPrograms
     * @return \ATDConnect\StructType\Product
     */
    public function setMarketingPrograms(array $marketingPrograms = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingProgramsArrayErrorMessage = self::validateMarketingProgramsForArrayConstraintsFromSetMarketingPrograms($marketingPrograms))) {
            throw new \InvalidArgumentException($marketingProgramsArrayErrorMessage, __LINE__);
        }
        $this->marketingPrograms = $marketingPrograms;
        return $this;
    }
    /**
     * Add item to marketingPrograms value
     * @throws \InvalidArgumentException
     * @param \ATDConnect\StructType\MarketingProgram $item
     * @return \ATDConnect\StructType\Product
     */
    public function addToMarketingPrograms(\ATDConnect\StructType\MarketingProgram $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ATDConnect\StructType\MarketingProgram) {
            throw new \InvalidArgumentException(sprintf('The marketingPrograms property can only contain items of type \ATDConnect\StructType\MarketingProgram, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->marketingPrograms[] = $item;
        return $this;
    }
    /**
     * Get productSpec value
     * @return \ATDConnect\StructType\CriteriaType|null
     */
    public function getProductSpec()
    {
        return $this->productSpec;
    }
    /**
     * Set productSpec value
     * @param \ATDConnect\StructType\CriteriaType $productSpec
     * @return \ATDConnect\StructType\Product
     */
    public function setProductSpec(\ATDConnect\StructType\CriteriaType $productSpec = null)
    {
        $this->productSpec = $productSpec;
        return $this;
    }
    /**
     * Get rebates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ATDConnect\StructType\Rebate[]|null
     */
    public function getRebates()
    {
        return isset($this->rebates) ? $this->rebates : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRebates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRebates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRebatesForArrayConstraintsFromSetRebates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productRebatesItem) {
            // validation for constraint: itemType
            if (!$productRebatesItem instanceof \ATDConnect\StructType\Rebate) {
                $invalidValues[] = is_object($productRebatesItem) ? get_class($productRebatesItem) : sprintf('%s(%s)', gettype($productRebatesItem), var_export($productRebatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rebates property can only contain items of type \ATDConnect\StructType\Rebate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rebates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ATDConnect\StructType\Rebate[] $rebates
     * @return \ATDConnect\StructType\Product
     */
    public function setRebates(array $rebates = array())
    {
        // validation for constraint: array
        if ('' !== ($rebatesArrayErrorMessage = self::validateRebatesForArrayConstraintsFromSetRebates($rebates))) {
            throw new \InvalidArgumentException($rebatesArrayErrorMessage, __LINE__);
        }
        if (is_null($rebates) || (is_array($rebates) && empty($rebates))) {
            unset($this->rebates);
        } else {
            $this->rebates = $rebates;
        }
        return $this;
    }
    /**
     * Add item to rebates value
     * @throws \InvalidArgumentException
     * @param \ATDConnect\StructType\Rebate $item
     * @return \ATDConnect\StructType\Product
     */
    public function addToRebates(\ATDConnect\StructType\Rebate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ATDConnect\StructType\Rebate) {
            throw new \InvalidArgumentException(sprintf('The rebates property can only contain items of type \ATDConnect\StructType\Rebate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rebates[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \ATDConnect\StructType\Product
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get preferredBrand value
     * @return bool|null
     */
    public function getPreferredBrand()
    {
        return $this->preferredBrand;
    }
    /**
     * Set preferredBrand value
     * @param bool $preferredBrand
     * @return \ATDConnect\StructType\Product
     */
    public function setPreferredBrand($preferredBrand = null)
    {
        // validation for constraint: boolean
        if (!is_null($preferredBrand) && !is_bool($preferredBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preferredBrand, true), gettype($preferredBrand)), __LINE__);
        }
        $this->preferredBrand = $preferredBrand;
        return $this;
    }
    /**
     * Get privateBrand value
     * @return bool|null
     */
    public function getPrivateBrand()
    {
        return $this->privateBrand;
    }
    /**
     * Set privateBrand value
     * @param bool $privateBrand
     * @return \ATDConnect\StructType\Product
     */
    public function setPrivateBrand($privateBrand = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateBrand) && !is_bool($privateBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateBrand, true), gettype($privateBrand)), __LINE__);
        }
        $this->privateBrand = $privateBrand;
        return $this;
    }
    /**
     * Get flaggedBrand value
     * @return bool|null
     */
    public function getFlaggedBrand()
    {
        return $this->flaggedBrand;
    }
    /**
     * Set flaggedBrand value
     * @param bool $flaggedBrand
     * @return \ATDConnect\StructType\Product
     */
    public function setFlaggedBrand($flaggedBrand = null)
    {
        // validation for constraint: boolean
        if (!is_null($flaggedBrand) && !is_bool($flaggedBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($flaggedBrand, true), gettype($flaggedBrand)), __LINE__);
        }
        $this->flaggedBrand = $flaggedBrand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
