<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for price StructType
 * @subpackage Structs
 */
class Price extends AbstractStructBase
{
    /**
     * The cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The retail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $retail;
    /**
     * The specialDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $specialDiscount;
    /**
     * The fet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $fet;
    /**
     * Constructor method for price
     * @uses Price::setCost()
     * @uses Price::setRetail()
     * @uses Price::setSpecialDiscount()
     * @uses Price::setFet()
     * @param float $cost
     * @param float $retail
     * @param float $specialDiscount
     * @param float $fet
     */
    public function __construct($cost = null, $retail = null, $specialDiscount = null, $fet = null)
    {
        $this
            ->setCost($cost)
            ->setRetail($retail)
            ->setSpecialDiscount($specialDiscount)
            ->setFet($fet);
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \ATDConnect\StructType\Price
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get retail value
     * @return float|null
     */
    public function getRetail()
    {
        return $this->retail;
    }
    /**
     * Set retail value
     * @param float $retail
     * @return \ATDConnect\StructType\Price
     */
    public function setRetail($retail = null)
    {
        // validation for constraint: float
        if (!is_null($retail) && !(is_float($retail) || is_numeric($retail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retail, true), gettype($retail)), __LINE__);
        }
        $this->retail = $retail;
        return $this;
    }
    /**
     * Get specialDiscount value
     * @return float|null
     */
    public function getSpecialDiscount()
    {
        return $this->specialDiscount;
    }
    /**
     * Set specialDiscount value
     * @param float $specialDiscount
     * @return \ATDConnect\StructType\Price
     */
    public function setSpecialDiscount($specialDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($specialDiscount) && !(is_float($specialDiscount) || is_numeric($specialDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($specialDiscount, true), gettype($specialDiscount)), __LINE__);
        }
        $this->specialDiscount = $specialDiscount;
        return $this;
    }
    /**
     * Get fet value
     * @return float|null
     */
    public function getFet()
    {
        return $this->fet;
    }
    /**
     * Set fet value
     * @param float $fet
     * @return \ATDConnect\StructType\Price
     */
    public function setFet($fet = null)
    {
        // validation for constraint: float
        if (!is_null($fet) && !(is_float($fet) || is_numeric($fet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fet, true), gettype($fet)), __LINE__);
        }
        $this->fet = $fet;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Price
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
