<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for options StructType
 * @subpackage Structs
 */
class Options extends AbstractStructBase
{
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\Price
     */
    public $price;
    /**
     * The availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\Inventory
     */
    public $availability;
    /**
     * The images
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\RequestImageTypes
     */
    public $images;
    /**
     * The productSpec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\CriteriaType
     */
    public $productSpec;
    /**
     * The includeRebates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeRebates;
    /**
     * The includeMarketingPrograms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeMarketingPrograms;
    /**
     * Constructor method for options
     * @uses Options::setPrice()
     * @uses Options::setAvailability()
     * @uses Options::setImages()
     * @uses Options::setProductSpec()
     * @uses Options::setIncludeRebates()
     * @uses Options::setIncludeMarketingPrograms()
     * @param \ATDConnect\StructType\Price $price
     * @param \ATDConnect\StructType\Inventory $availability
     * @param \ATDConnect\StructType\RequestImageTypes $images
     * @param \ATDConnect\StructType\CriteriaType $productSpec
     * @param bool $includeRebates
     * @param bool $includeMarketingPrograms
     */
    public function __construct(\ATDConnect\StructType\Price $price = null, \ATDConnect\StructType\Inventory $availability = null, \ATDConnect\StructType\RequestImageTypes $images = null, \ATDConnect\StructType\CriteriaType $productSpec = null, $includeRebates = null, $includeMarketingPrograms = null)
    {
        $this
            ->setPrice($price)
            ->setAvailability($availability)
            ->setImages($images)
            ->setProductSpec($productSpec)
            ->setIncludeRebates($includeRebates)
            ->setIncludeMarketingPrograms($includeMarketingPrograms);
    }
    /**
     * Get price value
     * @return \ATDConnect\StructType\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param \ATDConnect\StructType\Price $price
     * @return \ATDConnect\StructType\Options
     */
    public function setPrice(\ATDConnect\StructType\Price $price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get availability value
     * @return \ATDConnect\StructType\Inventory|null
     */
    public function getAvailability()
    {
        return $this->availability;
    }
    /**
     * Set availability value
     * @param \ATDConnect\StructType\Inventory $availability
     * @return \ATDConnect\StructType\Options
     */
    public function setAvailability(\ATDConnect\StructType\Inventory $availability = null)
    {
        $this->availability = $availability;
        return $this;
    }
    /**
     * Get images value
     * @return \ATDConnect\StructType\RequestImageTypes|null
     */
    public function getImages()
    {
        return $this->images;
    }
    /**
     * Set images value
     * @param \ATDConnect\StructType\RequestImageTypes $images
     * @return \ATDConnect\StructType\Options
     */
    public function setImages(\ATDConnect\StructType\RequestImageTypes $images = null)
    {
        $this->images = $images;
        return $this;
    }
    /**
     * Get productSpec value
     * @return \ATDConnect\StructType\CriteriaType|null
     */
    public function getProductSpec()
    {
        return $this->productSpec;
    }
    /**
     * Set productSpec value
     * @param \ATDConnect\StructType\CriteriaType $productSpec
     * @return \ATDConnect\StructType\Options
     */
    public function setProductSpec(\ATDConnect\StructType\CriteriaType $productSpec = null)
    {
        $this->productSpec = $productSpec;
        return $this;
    }
    /**
     * Get includeRebates value
     * @return bool|null
     */
    public function getIncludeRebates()
    {
        return $this->includeRebates;
    }
    /**
     * Set includeRebates value
     * @param bool $includeRebates
     * @return \ATDConnect\StructType\Options
     */
    public function setIncludeRebates($includeRebates = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRebates) && !is_bool($includeRebates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRebates, true), gettype($includeRebates)), __LINE__);
        }
        $this->includeRebates = $includeRebates;
        return $this;
    }
    /**
     * Get includeMarketingPrograms value
     * @return bool|null
     */
    public function getIncludeMarketingPrograms()
    {
        return $this->includeMarketingPrograms;
    }
    /**
     * Set includeMarketingPrograms value
     * @param bool $includeMarketingPrograms
     * @return \ATDConnect\StructType\Options
     */
    public function setIncludeMarketingPrograms($includeMarketingPrograms = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMarketingPrograms) && !is_bool($includeMarketingPrograms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMarketingPrograms, true), gettype($includeMarketingPrograms)), __LINE__);
        }
        $this->includeMarketingPrograms = $includeMarketingPrograms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
