<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for marketingResponse StructType
 * @subpackage Structs
 */
class MarketingResponse extends AbstractStructBase
{
    /**
     * The locationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locationNumber;
    /**
     * The ATDProductNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ATDProductNumber;
    /**
     * The MFGProductNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MFGProductNumber;
    /**
     * The CustomerPartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerPartNumber;
    /**
     * The productStyle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productStyle;
    /**
     * The marketing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\Marketing
     */
    public $marketing;
    /**
     * Constructor method for marketingResponse
     * @uses MarketingResponse::setLocationNumber()
     * @uses MarketingResponse::setATDProductNumber()
     * @uses MarketingResponse::setMFGProductNumber()
     * @uses MarketingResponse::setCustomerPartNumber()
     * @uses MarketingResponse::setProductStyle()
     * @uses MarketingResponse::setMarketing()
     * @param string $locationNumber
     * @param string $aTDProductNumber
     * @param string $mFGProductNumber
     * @param string $customerPartNumber
     * @param string $productStyle
     * @param \ATDConnect\StructType\Marketing $marketing
     */
    public function __construct($locationNumber = null, $aTDProductNumber = null, $mFGProductNumber = null, $customerPartNumber = null, $productStyle = null, \ATDConnect\StructType\Marketing $marketing = null)
    {
        $this
            ->setLocationNumber($locationNumber)
            ->setATDProductNumber($aTDProductNumber)
            ->setMFGProductNumber($mFGProductNumber)
            ->setCustomerPartNumber($customerPartNumber)
            ->setProductStyle($productStyle)
            ->setMarketing($marketing);
    }
    /**
     * Get locationNumber value
     * @return string|null
     */
    public function getLocationNumber()
    {
        return $this->locationNumber;
    }
    /**
     * Set locationNumber value
     * @param string $locationNumber
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setLocationNumber($locationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($locationNumber) && !is_string($locationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationNumber, true), gettype($locationNumber)), __LINE__);
        }
        $this->locationNumber = $locationNumber;
        return $this;
    }
    /**
     * Get ATDProductNumber value
     * @return string|null
     */
    public function getATDProductNumber()
    {
        return $this->ATDProductNumber;
    }
    /**
     * Set ATDProductNumber value
     * @param string $aTDProductNumber
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setATDProductNumber($aTDProductNumber = null)
    {
        // validation for constraint: string
        if (!is_null($aTDProductNumber) && !is_string($aTDProductNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aTDProductNumber, true), gettype($aTDProductNumber)), __LINE__);
        }
        $this->ATDProductNumber = $aTDProductNumber;
        return $this;
    }
    /**
     * Get MFGProductNumber value
     * @return string|null
     */
    public function getMFGProductNumber()
    {
        return $this->MFGProductNumber;
    }
    /**
     * Set MFGProductNumber value
     * @param string $mFGProductNumber
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setMFGProductNumber($mFGProductNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mFGProductNumber) && !is_string($mFGProductNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mFGProductNumber, true), gettype($mFGProductNumber)), __LINE__);
        }
        $this->MFGProductNumber = $mFGProductNumber;
        return $this;
    }
    /**
     * Get CustomerPartNumber value
     * @return string|null
     */
    public function getCustomerPartNumber()
    {
        return $this->CustomerPartNumber;
    }
    /**
     * Set CustomerPartNumber value
     * @param string $customerPartNumber
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setCustomerPartNumber($customerPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerPartNumber) && !is_string($customerPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPartNumber, true), gettype($customerPartNumber)), __LINE__);
        }
        $this->CustomerPartNumber = $customerPartNumber;
        return $this;
    }
    /**
     * Get productStyle value
     * @return string|null
     */
    public function getProductStyle()
    {
        return $this->productStyle;
    }
    /**
     * Set productStyle value
     * @param string $productStyle
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setProductStyle($productStyle = null)
    {
        // validation for constraint: string
        if (!is_null($productStyle) && !is_string($productStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productStyle, true), gettype($productStyle)), __LINE__);
        }
        $this->productStyle = $productStyle;
        return $this;
    }
    /**
     * Get marketing value
     * @return \ATDConnect\StructType\Marketing|null
     */
    public function getMarketing()
    {
        return $this->marketing;
    }
    /**
     * Set marketing value
     * @param \ATDConnect\StructType\Marketing $marketing
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function setMarketing(\ATDConnect\StructType\Marketing $marketing = null)
    {
        $this->marketing = $marketing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
