<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for marketingRequest StructType
 * @subpackage Structs
 */
class MarketingRequest extends AbstractStructBase
{
    /**
     * The locationNumber
     * @var string
     */
    public $locationNumber;
    /**
     * The criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\CriteriaType
     */
    public $criteria;
    /**
     * Constructor method for marketingRequest
     * @uses MarketingRequest::setLocationNumber()
     * @uses MarketingRequest::setCriteria()
     * @param string $locationNumber
     * @param \ATDConnect\StructType\CriteriaType $criteria
     */
    public function __construct($locationNumber = null, \ATDConnect\StructType\CriteriaType $criteria = null)
    {
        $this
            ->setLocationNumber($locationNumber)
            ->setCriteria($criteria);
    }
    /**
     * Get locationNumber value
     * @return string|null
     */
    public function getLocationNumber()
    {
        return $this->locationNumber;
    }
    /**
     * Set locationNumber value
     * @param string $locationNumber
     * @return \ATDConnect\StructType\MarketingRequest
     */
    public function setLocationNumber($locationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($locationNumber) && !is_string($locationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationNumber, true), gettype($locationNumber)), __LINE__);
        }
        $this->locationNumber = $locationNumber;
        return $this;
    }
    /**
     * Get criteria value
     * @return \ATDConnect\StructType\CriteriaType|null
     */
    public function getCriteria()
    {
        return $this->criteria;
    }
    /**
     * Set criteria value
     * @param \ATDConnect\StructType\CriteriaType $criteria
     * @return \ATDConnect\StructType\MarketingRequest
     */
    public function setCriteria(\ATDConnect\StructType\CriteriaType $criteria = null)
    {
        $this->criteria = $criteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\MarketingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
