<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for marketingProgram StructType
 * @subpackage Structs
 */
class MarketingProgram extends AbstractStructBase
{
    /**
     * The programId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $programId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * Constructor method for marketingProgram
     * @uses MarketingProgram::setProgramId()
     * @uses MarketingProgram::setName()
     * @param string $programId
     * @param string $name
     */
    public function __construct($programId = null, $name = null)
    {
        $this
            ->setProgramId($programId)
            ->setName($name);
    }
    /**
     * Get programId value
     * @return string|null
     */
    public function getProgramId()
    {
        return $this->programId;
    }
    /**
     * Set programId value
     * @param string $programId
     * @return \ATDConnect\StructType\MarketingProgram
     */
    public function setProgramId($programId = null)
    {
        // validation for constraint: string
        if (!is_null($programId) && !is_string($programId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programId, true), gettype($programId)), __LINE__);
        }
        $this->programId = $programId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \ATDConnect\StructType\MarketingProgram
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\MarketingProgram
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
