<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for inventory StructType
 * @subpackage Structs
 */
class Inventory extends AbstractStructBase
{
    /**
     * The local
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $local;
    /**
     * The localPlus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $localPlus;
    /**
     * The nationWide
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nationWide;
    /**
     * The onHand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $onHand;
    /**
     * Constructor method for inventory
     * @uses Inventory::setLocal()
     * @uses Inventory::setLocalPlus()
     * @uses Inventory::setNationWide()
     * @uses Inventory::setOnHand()
     * @param int $local
     * @param int $localPlus
     * @param int $nationWide
     * @param int $onHand
     */
    public function __construct($local = null, $localPlus = null, $nationWide = null, $onHand = null)
    {
        $this
            ->setLocal($local)
            ->setLocalPlus($localPlus)
            ->setNationWide($nationWide)
            ->setOnHand($onHand);
    }
    /**
     * Get local value
     * @return int|null
     */
    public function getLocal()
    {
        return $this->local;
    }
    /**
     * Set local value
     * @param int $local
     * @return \ATDConnect\StructType\Inventory
     */
    public function setLocal($local = null)
    {
        // validation for constraint: int
        if (!is_null($local) && !(is_int($local) || ctype_digit($local))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($local, true), gettype($local)), __LINE__);
        }
        $this->local = $local;
        return $this;
    }
    /**
     * Get localPlus value
     * @return int|null
     */
    public function getLocalPlus()
    {
        return $this->localPlus;
    }
    /**
     * Set localPlus value
     * @param int $localPlus
     * @return \ATDConnect\StructType\Inventory
     */
    public function setLocalPlus($localPlus = null)
    {
        // validation for constraint: int
        if (!is_null($localPlus) && !(is_int($localPlus) || ctype_digit($localPlus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localPlus, true), gettype($localPlus)), __LINE__);
        }
        $this->localPlus = $localPlus;
        return $this;
    }
    /**
     * Get nationWide value
     * @return int|null
     */
    public function getNationWide()
    {
        return $this->nationWide;
    }
    /**
     * Set nationWide value
     * @param int $nationWide
     * @return \ATDConnect\StructType\Inventory
     */
    public function setNationWide($nationWide = null)
    {
        // validation for constraint: int
        if (!is_null($nationWide) && !(is_int($nationWide) || ctype_digit($nationWide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nationWide, true), gettype($nationWide)), __LINE__);
        }
        $this->nationWide = $nationWide;
        return $this;
    }
    /**
     * Get onHand value
     * @return int|null
     */
    public function getOnHand()
    {
        return $this->onHand;
    }
    /**
     * Set onHand value
     * @param int $onHand
     * @return \ATDConnect\StructType\Inventory
     */
    public function setOnHand($onHand = null)
    {
        // validation for constraint: int
        if (!is_null($onHand) && !(is_int($onHand) || ctype_digit($onHand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onHand, true), gettype($onHand)), __LINE__);
        }
        $this->onHand = $onHand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Inventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
