<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address1;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address3;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zipCode;
    /**
     * The plus4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plus4;
    /**
     * Constructor method for address
     * @uses Address::setAddress1()
     * @uses Address::setAddress2()
     * @uses Address::setAddress3()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setZipCode()
     * @uses Address::setPlus4()
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $state
     * @param string $zipCode
     * @param string $plus4
     */
    public function __construct($address1 = null, $address2 = null, $address3 = null, $city = null, $state = null, $zipCode = null, $plus4 = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setState($state)
            ->setZipCode($zipCode)
            ->setPlus4($plus4);
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \ATDConnect\StructType\Address
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \ATDConnect\StructType\Address
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \ATDConnect\StructType\Address
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \ATDConnect\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \ATDConnect\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param string $zipCode
     * @return \ATDConnect\StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get plus4 value
     * @return string|null
     */
    public function getPlus4()
    {
        return $this->plus4;
    }
    /**
     * Set plus4 value
     * @param string $plus4
     * @return \ATDConnect\StructType\Address
     */
    public function setPlus4($plus4 = null)
    {
        // validation for constraint: string
        if (!is_null($plus4) && !is_string($plus4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plus4, true), gettype($plus4)), __LINE__);
        }
        $this->plus4 = $plus4;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
