<?php

namespace ATDConnect\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getMarketingInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \ATDConnect\StructType\MarketingRequest $getMarketingInfoRequest
     * @return \ATDConnect\StructType\MarketingResponse|bool
     */
    public function getMarketingInfo(\ATDConnect\StructType\MarketingRequest $getMarketingInfoRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getMarketingInfo($getMarketingInfoRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \ATDConnect\StructType\MarketingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
