<?php

namespace ATDConnect;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'address' => '\\ATDConnect\\StructType\\Address',
            'inventory' => '\\ATDConnect\\StructType\\Inventory',
            'jaxbList' => '\\ATDConnect\\StructType\\JaxbList',
            'criteriaEntryType' => '\\ATDConnect\\StructType\\CriteriaEntryType',
            'criteriaType' => '\\ATDConnect\\StructType\\CriteriaType',
            'requestImageTypes' => '\\ATDConnect\\StructType\\RequestImageTypes',
            'options' => '\\ATDConnect\\StructType\\Options',
            'price' => '\\ATDConnect\\StructType\\Price',
            'responseImages' => '\\ATDConnect\\StructType\\ResponseImages',
            'images' => '\\ATDConnect\\StructType\\Images',
            'responseImageTypes' => '\\ATDConnect\\StructType\\ResponseImageTypes',
            'rebate' => '\\ATDConnect\\StructType\\Rebate',
            'marketingProgram' => '\\ATDConnect\\StructType\\MarketingProgram',
            'product' => '\\ATDConnect\\StructType\\Product',
            'Marketing' => '\\ATDConnect\\StructType\\Marketing',
            'marketingProduct' => '\\ATDConnect\\StructType\\MarketingProduct',
            'marketingRequest' => '\\ATDConnect\\StructType\\MarketingRequest',
            'marketingResponse' => '\\ATDConnect\\StructType\\MarketingResponse',
        );
    }
}
