<?php

namespace ATDConnect\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing StructType
 * @subpackage Structs
 */
class Marketing extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\JaxbList
     */
    public $features;
    /**
     * The benefits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\JaxbList
     */
    public $benefits;
    /**
     * The warranty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ATDConnect\StructType\CriteriaType
     */
    public $warranty;
    /**
     * Constructor method for Marketing
     * @uses Marketing::setDescription()
     * @uses Marketing::setFeatures()
     * @uses Marketing::setBenefits()
     * @uses Marketing::setWarranty()
     * @param string $description
     * @param \ATDConnect\StructType\JaxbList $features
     * @param \ATDConnect\StructType\JaxbList $benefits
     * @param \ATDConnect\StructType\CriteriaType $warranty
     */
    public function __construct($description = null, \ATDConnect\StructType\JaxbList $features = null, \ATDConnect\StructType\JaxbList $benefits = null, \ATDConnect\StructType\CriteriaType $warranty = null)
    {
        $this
            ->setDescription($description)
            ->setFeatures($features)
            ->setBenefits($benefits)
            ->setWarranty($warranty);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \ATDConnect\StructType\Marketing
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get features value
     * @return \ATDConnect\StructType\JaxbList|null
     */
    public function getFeatures()
    {
        return $this->features;
    }
    /**
     * Set features value
     * @param \ATDConnect\StructType\JaxbList $features
     * @return \ATDConnect\StructType\Marketing
     */
    public function setFeatures(\ATDConnect\StructType\JaxbList $features = null)
    {
        $this->features = $features;
        return $this;
    }
    /**
     * Get benefits value
     * @return \ATDConnect\StructType\JaxbList|null
     */
    public function getBenefits()
    {
        return $this->benefits;
    }
    /**
     * Set benefits value
     * @param \ATDConnect\StructType\JaxbList $benefits
     * @return \ATDConnect\StructType\Marketing
     */
    public function setBenefits(\ATDConnect\StructType\JaxbList $benefits = null)
    {
        $this->benefits = $benefits;
        return $this;
    }
    /**
     * Get warranty value
     * @return \ATDConnect\StructType\CriteriaType|null
     */
    public function getWarranty()
    {
        return $this->warranty;
    }
    /**
     * Set warranty value
     * @param \ATDConnect\StructType\CriteriaType $warranty
     * @return \ATDConnect\StructType\Marketing
     */
    public function setWarranty(\ATDConnect\StructType\CriteriaType $warranty = null)
    {
        $this->warranty = $warranty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ATDConnect\StructType\Marketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
