<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prestation StructType
 * @subpackage Structs
 */
class Prestation extends AbstractStructBase
{
    /**
     * The offre
     * @var string
     */
    public $offre;
    /**
     * The prix_ttc
     * @var float
     */
    public $prix_ttc;
    /**
     * Constructor method for Prestation
     * @uses Prestation::setOffre()
     * @uses Prestation::setPrix_ttc()
     * @param string $offre
     * @param float $prix_ttc
     */
    public function __construct($offre = null, $prix_ttc = null)
    {
        $this
            ->setOffre($offre)
            ->setPrix_ttc($prix_ttc);
    }
    /**
     * Get offre value
     * @return string|null
     */
    public function getOffre()
    {
        return $this->offre;
    }
    /**
     * Set offre value
     * @param string $offre
     * @return \StructType\Prestation
     */
    public function setOffre($offre = null)
    {
        // validation for constraint: string
        if (!is_null($offre) && !is_string($offre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offre, true), gettype($offre)), __LINE__);
        }
        $this->offre = $offre;
        return $this;
    }
    /**
     * Get prix_ttc value
     * @return float|null
     */
    public function getPrix_ttc()
    {
        return $this->prix_ttc;
    }
    /**
     * Set prix_ttc value
     * @param float $prix_ttc
     * @return \StructType\Prestation
     */
    public function setPrix_ttc($prix_ttc = null)
    {
        // validation for constraint: float
        if (!is_null($prix_ttc) && !(is_float($prix_ttc) || is_numeric($prix_ttc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix_ttc, true), gettype($prix_ttc)), __LINE__);
        }
        $this->prix_ttc = $prix_ttc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Prestation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
