<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Input StructType
 * @subpackage Structs
 */
class Input extends AbstractStructBase
{
    /**
     * The type_id_RTD
     * @var string
     */
    public $type_id_RTD;
    /**
     * The id_RTD
     * @var string
     */
    public $id_RTD;
    /**
     * The is_immatricule
     * @var string
     */
    public $is_immatricule;
    /**
     * The tx_co2
     * @var int
     */
    public $tx_co2;
    /**
     * The duree
     * @var float
     */
    public $duree;
    /**
     * The prix
     * @var float
     */
    public $prix;
    /**
     * The apport
     * @var float
     */
    public $apport;
    /**
     * The niveau_taux
     * @var string
     */
    public $niveau_taux;
    /**
     * The energie
     * @var string
     */
    public $energie;
    /**
     * The prix_constr
     * @var float
     */
    public $prix_constr;
    /**
     * The prix_options
     * @var float
     */
    public $prix_options;
    /**
     * The km_prevu
     * @var int
     */
    public $km_prevu;
    /**
     * The depot_garantie
     * @var float
     */
    public $depot_garantie;
    /**
     * The frais_livraison
     * @var float
     */
    public $frais_livraison;
    /**
     * The frais_transport
     * @var float
     */
    public $frais_transport;
    /**
     * The horse_power
     * @var int
     */
    public $horse_power;
    /**
     * The dept_livraison
     * @var string
     */
    public $dept_livraison;
    /**
     * The vehicule_marque
     * @var string
     */
    public $vehicule_marque;
    /**
     * The vehicule_modele
     * @var string
     */
    public $vehicule_modele;
    /**
     * The age_locataire
     * @var int
     */
    public $age_locataire;
    /**
     * The age_colocataire
     * @var int
     */
    public $age_colocataire;
    /**
     * The frais_accessoires
     * @var float
     */
    public $frais_accessoires;
    /**
     * The override_marge_aleatoire_pourcent
     * @var string
     */
    public $override_marge_aleatoire_pourcent;
    /**
     * The override_tdf_pourcent
     * @var float
     */
    public $override_tdf_pourcent;
    /**
     * The offrec_nom
     * @var string
     */
    public $offrec_nom;
    /**
     * The force_duree_eligible
     * @var int
     */
    public $force_duree_eligible;
    /**
     * The type_contrat
     * @var string
     */
    public $type_contrat;
    /**
     * The caisse_code
     * @var string
     */
    public $caisse_code;
    /**
     * The ignore_check_vehicule_exist
     * @var bool
     */
    public $ignore_check_vehicule_exist;
    /**
     * The montant_malus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $montant_malus;
    /**
     * The frais_ww
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $frais_ww;
    /**
     * The frais_custom_carte_grise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $frais_custom_carte_grise;
    /**
     * The override_taux_valeur_rachat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $override_taux_valeur_rachat;
    /**
     * The type_locataire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type_locataire;
    /**
     * The type_colocataire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type_colocataire;
    /**
     * The date_mise_circulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date_mise_circulation;
    /**
     * The kilometrage_initial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $kilometrage_initial;
    /**
     * The type_dossier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type_dossier;
    /**
     * Constructor method for Input
     * @uses Input::setType_id_RTD()
     * @uses Input::setId_RTD()
     * @uses Input::setIs_immatricule()
     * @uses Input::setTx_co2()
     * @uses Input::setDuree()
     * @uses Input::setPrix()
     * @uses Input::setApport()
     * @uses Input::setNiveau_taux()
     * @uses Input::setEnergie()
     * @uses Input::setPrix_constr()
     * @uses Input::setPrix_options()
     * @uses Input::setKm_prevu()
     * @uses Input::setDepot_garantie()
     * @uses Input::setFrais_livraison()
     * @uses Input::setFrais_transport()
     * @uses Input::setHorse_power()
     * @uses Input::setDept_livraison()
     * @uses Input::setVehicule_marque()
     * @uses Input::setVehicule_modele()
     * @uses Input::setAge_locataire()
     * @uses Input::setAge_colocataire()
     * @uses Input::setFrais_accessoires()
     * @uses Input::setOverride_marge_aleatoire_pourcent()
     * @uses Input::setOverride_tdf_pourcent()
     * @uses Input::setOffrec_nom()
     * @uses Input::setForce_duree_eligible()
     * @uses Input::setType_contrat()
     * @uses Input::setCaisse_code()
     * @uses Input::setIgnore_check_vehicule_exist()
     * @uses Input::setMontant_malus()
     * @uses Input::setFrais_ww()
     * @uses Input::setFrais_custom_carte_grise()
     * @uses Input::setOverride_taux_valeur_rachat()
     * @uses Input::setType_locataire()
     * @uses Input::setType_colocataire()
     * @uses Input::setDate_mise_circulation()
     * @uses Input::setKilometrage_initial()
     * @uses Input::setType_dossier()
     * @param string $type_id_RTD
     * @param string $id_RTD
     * @param string $is_immatricule
     * @param int $tx_co2
     * @param float $duree
     * @param float $prix
     * @param float $apport
     * @param string $niveau_taux
     * @param string $energie
     * @param float $prix_constr
     * @param float $prix_options
     * @param int $km_prevu
     * @param float $depot_garantie
     * @param float $frais_livraison
     * @param float $frais_transport
     * @param int $horse_power
     * @param string $dept_livraison
     * @param string $vehicule_marque
     * @param string $vehicule_modele
     * @param int $age_locataire
     * @param int $age_colocataire
     * @param float $frais_accessoires
     * @param string $override_marge_aleatoire_pourcent
     * @param float $override_tdf_pourcent
     * @param string $offrec_nom
     * @param int $force_duree_eligible
     * @param string $type_contrat
     * @param string $caisse_code
     * @param bool $ignore_check_vehicule_exist
     * @param float $montant_malus
     * @param float $frais_ww
     * @param float $frais_custom_carte_grise
     * @param float $override_taux_valeur_rachat
     * @param string $type_locataire
     * @param string $type_colocataire
     * @param string $date_mise_circulation
     * @param int $kilometrage_initial
     * @param string $type_dossier
     */
    public function __construct($type_id_RTD = null, $id_RTD = null, $is_immatricule = null, $tx_co2 = null, $duree = null, $prix = null, $apport = null, $niveau_taux = null, $energie = null, $prix_constr = null, $prix_options = null, $km_prevu = null, $depot_garantie = null, $frais_livraison = null, $frais_transport = null, $horse_power = null, $dept_livraison = null, $vehicule_marque = null, $vehicule_modele = null, $age_locataire = null, $age_colocataire = null, $frais_accessoires = null, $override_marge_aleatoire_pourcent = null, $override_tdf_pourcent = null, $offrec_nom = null, $force_duree_eligible = null, $type_contrat = null, $caisse_code = null, $ignore_check_vehicule_exist = null, $montant_malus = null, $frais_ww = null, $frais_custom_carte_grise = null, $override_taux_valeur_rachat = null, $type_locataire = null, $type_colocataire = null, $date_mise_circulation = null, $kilometrage_initial = null, $type_dossier = null)
    {
        $this
            ->setType_id_RTD($type_id_RTD)
            ->setId_RTD($id_RTD)
            ->setIs_immatricule($is_immatricule)
            ->setTx_co2($tx_co2)
            ->setDuree($duree)
            ->setPrix($prix)
            ->setApport($apport)
            ->setNiveau_taux($niveau_taux)
            ->setEnergie($energie)
            ->setPrix_constr($prix_constr)
            ->setPrix_options($prix_options)
            ->setKm_prevu($km_prevu)
            ->setDepot_garantie($depot_garantie)
            ->setFrais_livraison($frais_livraison)
            ->setFrais_transport($frais_transport)
            ->setHorse_power($horse_power)
            ->setDept_livraison($dept_livraison)
            ->setVehicule_marque($vehicule_marque)
            ->setVehicule_modele($vehicule_modele)
            ->setAge_locataire($age_locataire)
            ->setAge_colocataire($age_colocataire)
            ->setFrais_accessoires($frais_accessoires)
            ->setOverride_marge_aleatoire_pourcent($override_marge_aleatoire_pourcent)
            ->setOverride_tdf_pourcent($override_tdf_pourcent)
            ->setOffrec_nom($offrec_nom)
            ->setForce_duree_eligible($force_duree_eligible)
            ->setType_contrat($type_contrat)
            ->setCaisse_code($caisse_code)
            ->setIgnore_check_vehicule_exist($ignore_check_vehicule_exist)
            ->setMontant_malus($montant_malus)
            ->setFrais_ww($frais_ww)
            ->setFrais_custom_carte_grise($frais_custom_carte_grise)
            ->setOverride_taux_valeur_rachat($override_taux_valeur_rachat)
            ->setType_locataire($type_locataire)
            ->setType_colocataire($type_colocataire)
            ->setDate_mise_circulation($date_mise_circulation)
            ->setKilometrage_initial($kilometrage_initial)
            ->setType_dossier($type_dossier);
    }
    /**
     * Get type_id_RTD value
     * @return string|null
     */
    public function getType_id_RTD()
    {
        return $this->type_id_RTD;
    }
    /**
     * Set type_id_RTD value
     * @param string $type_id_RTD
     * @return \StructType\Input
     */
    public function setType_id_RTD($type_id_RTD = null)
    {
        // validation for constraint: string
        if (!is_null($type_id_RTD) && !is_string($type_id_RTD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_id_RTD, true), gettype($type_id_RTD)), __LINE__);
        }
        $this->type_id_RTD = $type_id_RTD;
        return $this;
    }
    /**
     * Get id_RTD value
     * @return string|null
     */
    public function getId_RTD()
    {
        return $this->id_RTD;
    }
    /**
     * Set id_RTD value
     * @param string $id_RTD
     * @return \StructType\Input
     */
    public function setId_RTD($id_RTD = null)
    {
        // validation for constraint: string
        if (!is_null($id_RTD) && !is_string($id_RTD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id_RTD, true), gettype($id_RTD)), __LINE__);
        }
        $this->id_RTD = $id_RTD;
        return $this;
    }
    /**
     * Get is_immatricule value
     * @return string|null
     */
    public function getIs_immatricule()
    {
        return $this->is_immatricule;
    }
    /**
     * Set is_immatricule value
     * @param string $is_immatricule
     * @return \StructType\Input
     */
    public function setIs_immatricule($is_immatricule = null)
    {
        // validation for constraint: string
        if (!is_null($is_immatricule) && !is_string($is_immatricule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($is_immatricule, true), gettype($is_immatricule)), __LINE__);
        }
        $this->is_immatricule = $is_immatricule;
        return $this;
    }
    /**
     * Get tx_co2 value
     * @return int|null
     */
    public function getTx_co2()
    {
        return $this->tx_co2;
    }
    /**
     * Set tx_co2 value
     * @param int $tx_co2
     * @return \StructType\Input
     */
    public function setTx_co2($tx_co2 = null)
    {
        // validation for constraint: int
        if (!is_null($tx_co2) && !(is_int($tx_co2) || ctype_digit($tx_co2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tx_co2, true), gettype($tx_co2)), __LINE__);
        }
        $this->tx_co2 = $tx_co2;
        return $this;
    }
    /**
     * Get duree value
     * @return float|null
     */
    public function getDuree()
    {
        return $this->duree;
    }
    /**
     * Set duree value
     * @param float $duree
     * @return \StructType\Input
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: float
        if (!is_null($duree) && !(is_float($duree) || is_numeric($duree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($duree, true), gettype($duree)), __LINE__);
        }
        $this->duree = $duree;
        return $this;
    }
    /**
     * Get prix value
     * @return float|null
     */
    public function getPrix()
    {
        return $this->prix;
    }
    /**
     * Set prix value
     * @param float $prix
     * @return \StructType\Input
     */
    public function setPrix($prix = null)
    {
        // validation for constraint: float
        if (!is_null($prix) && !(is_float($prix) || is_numeric($prix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix, true), gettype($prix)), __LINE__);
        }
        $this->prix = $prix;
        return $this;
    }
    /**
     * Get apport value
     * @return float|null
     */
    public function getApport()
    {
        return $this->apport;
    }
    /**
     * Set apport value
     * @param float $apport
     * @return \StructType\Input
     */
    public function setApport($apport = null)
    {
        // validation for constraint: float
        if (!is_null($apport) && !(is_float($apport) || is_numeric($apport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($apport, true), gettype($apport)), __LINE__);
        }
        $this->apport = $apport;
        return $this;
    }
    /**
     * Get niveau_taux value
     * @return string|null
     */
    public function getNiveau_taux()
    {
        return $this->niveau_taux;
    }
    /**
     * Set niveau_taux value
     * @param string $niveau_taux
     * @return \StructType\Input
     */
    public function setNiveau_taux($niveau_taux = null)
    {
        // validation for constraint: string
        if (!is_null($niveau_taux) && !is_string($niveau_taux)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($niveau_taux, true), gettype($niveau_taux)), __LINE__);
        }
        $this->niveau_taux = $niveau_taux;
        return $this;
    }
    /**
     * Get energie value
     * @return string|null
     */
    public function getEnergie()
    {
        return $this->energie;
    }
    /**
     * Set energie value
     * @param string $energie
     * @return \StructType\Input
     */
    public function setEnergie($energie = null)
    {
        // validation for constraint: string
        if (!is_null($energie) && !is_string($energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($energie, true), gettype($energie)), __LINE__);
        }
        $this->energie = $energie;
        return $this;
    }
    /**
     * Get prix_constr value
     * @return float|null
     */
    public function getPrix_constr()
    {
        return $this->prix_constr;
    }
    /**
     * Set prix_constr value
     * @param float $prix_constr
     * @return \StructType\Input
     */
    public function setPrix_constr($prix_constr = null)
    {
        // validation for constraint: float
        if (!is_null($prix_constr) && !(is_float($prix_constr) || is_numeric($prix_constr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix_constr, true), gettype($prix_constr)), __LINE__);
        }
        $this->prix_constr = $prix_constr;
        return $this;
    }
    /**
     * Get prix_options value
     * @return float|null
     */
    public function getPrix_options()
    {
        return $this->prix_options;
    }
    /**
     * Set prix_options value
     * @param float $prix_options
     * @return \StructType\Input
     */
    public function setPrix_options($prix_options = null)
    {
        // validation for constraint: float
        if (!is_null($prix_options) && !(is_float($prix_options) || is_numeric($prix_options))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix_options, true), gettype($prix_options)), __LINE__);
        }
        $this->prix_options = $prix_options;
        return $this;
    }
    /**
     * Get km_prevu value
     * @return int|null
     */
    public function getKm_prevu()
    {
        return $this->km_prevu;
    }
    /**
     * Set km_prevu value
     * @param int $km_prevu
     * @return \StructType\Input
     */
    public function setKm_prevu($km_prevu = null)
    {
        // validation for constraint: int
        if (!is_null($km_prevu) && !(is_int($km_prevu) || ctype_digit($km_prevu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($km_prevu, true), gettype($km_prevu)), __LINE__);
        }
        $this->km_prevu = $km_prevu;
        return $this;
    }
    /**
     * Get depot_garantie value
     * @return float|null
     */
    public function getDepot_garantie()
    {
        return $this->depot_garantie;
    }
    /**
     * Set depot_garantie value
     * @param float $depot_garantie
     * @return \StructType\Input
     */
    public function setDepot_garantie($depot_garantie = null)
    {
        // validation for constraint: float
        if (!is_null($depot_garantie) && !(is_float($depot_garantie) || is_numeric($depot_garantie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depot_garantie, true), gettype($depot_garantie)), __LINE__);
        }
        $this->depot_garantie = $depot_garantie;
        return $this;
    }
    /**
     * Get frais_livraison value
     * @return float|null
     */
    public function getFrais_livraison()
    {
        return $this->frais_livraison;
    }
    /**
     * Set frais_livraison value
     * @param float $frais_livraison
     * @return \StructType\Input
     */
    public function setFrais_livraison($frais_livraison = null)
    {
        // validation for constraint: float
        if (!is_null($frais_livraison) && !(is_float($frais_livraison) || is_numeric($frais_livraison))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_livraison, true), gettype($frais_livraison)), __LINE__);
        }
        $this->frais_livraison = $frais_livraison;
        return $this;
    }
    /**
     * Get frais_transport value
     * @return float|null
     */
    public function getFrais_transport()
    {
        return $this->frais_transport;
    }
    /**
     * Set frais_transport value
     * @param float $frais_transport
     * @return \StructType\Input
     */
    public function setFrais_transport($frais_transport = null)
    {
        // validation for constraint: float
        if (!is_null($frais_transport) && !(is_float($frais_transport) || is_numeric($frais_transport))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_transport, true), gettype($frais_transport)), __LINE__);
        }
        $this->frais_transport = $frais_transport;
        return $this;
    }
    /**
     * Get horse_power value
     * @return int|null
     */
    public function getHorse_power()
    {
        return $this->horse_power;
    }
    /**
     * Set horse_power value
     * @param int $horse_power
     * @return \StructType\Input
     */
    public function setHorse_power($horse_power = null)
    {
        // validation for constraint: int
        if (!is_null($horse_power) && !(is_int($horse_power) || ctype_digit($horse_power))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($horse_power, true), gettype($horse_power)), __LINE__);
        }
        $this->horse_power = $horse_power;
        return $this;
    }
    /**
     * Get dept_livraison value
     * @return string|null
     */
    public function getDept_livraison()
    {
        return $this->dept_livraison;
    }
    /**
     * Set dept_livraison value
     * @param string $dept_livraison
     * @return \StructType\Input
     */
    public function setDept_livraison($dept_livraison = null)
    {
        // validation for constraint: string
        if (!is_null($dept_livraison) && !is_string($dept_livraison)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dept_livraison, true), gettype($dept_livraison)), __LINE__);
        }
        $this->dept_livraison = $dept_livraison;
        return $this;
    }
    /**
     * Get vehicule_marque value
     * @return string|null
     */
    public function getVehicule_marque()
    {
        return $this->vehicule_marque;
    }
    /**
     * Set vehicule_marque value
     * @param string $vehicule_marque
     * @return \StructType\Input
     */
    public function setVehicule_marque($vehicule_marque = null)
    {
        // validation for constraint: string
        if (!is_null($vehicule_marque) && !is_string($vehicule_marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicule_marque, true), gettype($vehicule_marque)), __LINE__);
        }
        $this->vehicule_marque = $vehicule_marque;
        return $this;
    }
    /**
     * Get vehicule_modele value
     * @return string|null
     */
    public function getVehicule_modele()
    {
        return $this->vehicule_modele;
    }
    /**
     * Set vehicule_modele value
     * @param string $vehicule_modele
     * @return \StructType\Input
     */
    public function setVehicule_modele($vehicule_modele = null)
    {
        // validation for constraint: string
        if (!is_null($vehicule_modele) && !is_string($vehicule_modele)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicule_modele, true), gettype($vehicule_modele)), __LINE__);
        }
        $this->vehicule_modele = $vehicule_modele;
        return $this;
    }
    /**
     * Get age_locataire value
     * @return int|null
     */
    public function getAge_locataire()
    {
        return $this->age_locataire;
    }
    /**
     * Set age_locataire value
     * @param int $age_locataire
     * @return \StructType\Input
     */
    public function setAge_locataire($age_locataire = null)
    {
        // validation for constraint: int
        if (!is_null($age_locataire) && !(is_int($age_locataire) || ctype_digit($age_locataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age_locataire, true), gettype($age_locataire)), __LINE__);
        }
        $this->age_locataire = $age_locataire;
        return $this;
    }
    /**
     * Get age_colocataire value
     * @return int|null
     */
    public function getAge_colocataire()
    {
        return $this->age_colocataire;
    }
    /**
     * Set age_colocataire value
     * @param int $age_colocataire
     * @return \StructType\Input
     */
    public function setAge_colocataire($age_colocataire = null)
    {
        // validation for constraint: int
        if (!is_null($age_colocataire) && !(is_int($age_colocataire) || ctype_digit($age_colocataire))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age_colocataire, true), gettype($age_colocataire)), __LINE__);
        }
        $this->age_colocataire = $age_colocataire;
        return $this;
    }
    /**
     * Get frais_accessoires value
     * @return float|null
     */
    public function getFrais_accessoires()
    {
        return $this->frais_accessoires;
    }
    /**
     * Set frais_accessoires value
     * @param float $frais_accessoires
     * @return \StructType\Input
     */
    public function setFrais_accessoires($frais_accessoires = null)
    {
        // validation for constraint: float
        if (!is_null($frais_accessoires) && !(is_float($frais_accessoires) || is_numeric($frais_accessoires))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_accessoires, true), gettype($frais_accessoires)), __LINE__);
        }
        $this->frais_accessoires = $frais_accessoires;
        return $this;
    }
    /**
     * Get override_marge_aleatoire_pourcent value
     * @return string|null
     */
    public function getOverride_marge_aleatoire_pourcent()
    {
        return $this->override_marge_aleatoire_pourcent;
    }
    /**
     * Set override_marge_aleatoire_pourcent value
     * @param string $override_marge_aleatoire_pourcent
     * @return \StructType\Input
     */
    public function setOverride_marge_aleatoire_pourcent($override_marge_aleatoire_pourcent = null)
    {
        // validation for constraint: string
        if (!is_null($override_marge_aleatoire_pourcent) && !is_string($override_marge_aleatoire_pourcent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($override_marge_aleatoire_pourcent, true), gettype($override_marge_aleatoire_pourcent)), __LINE__);
        }
        $this->override_marge_aleatoire_pourcent = $override_marge_aleatoire_pourcent;
        return $this;
    }
    /**
     * Get override_tdf_pourcent value
     * @return float|null
     */
    public function getOverride_tdf_pourcent()
    {
        return $this->override_tdf_pourcent;
    }
    /**
     * Set override_tdf_pourcent value
     * @param float $override_tdf_pourcent
     * @return \StructType\Input
     */
    public function setOverride_tdf_pourcent($override_tdf_pourcent = null)
    {
        // validation for constraint: float
        if (!is_null($override_tdf_pourcent) && !(is_float($override_tdf_pourcent) || is_numeric($override_tdf_pourcent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($override_tdf_pourcent, true), gettype($override_tdf_pourcent)), __LINE__);
        }
        $this->override_tdf_pourcent = $override_tdf_pourcent;
        return $this;
    }
    /**
     * Get offrec_nom value
     * @return string|null
     */
    public function getOffrec_nom()
    {
        return $this->offrec_nom;
    }
    /**
     * Set offrec_nom value
     * @param string $offrec_nom
     * @return \StructType\Input
     */
    public function setOffrec_nom($offrec_nom = null)
    {
        // validation for constraint: string
        if (!is_null($offrec_nom) && !is_string($offrec_nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offrec_nom, true), gettype($offrec_nom)), __LINE__);
        }
        $this->offrec_nom = $offrec_nom;
        return $this;
    }
    /**
     * Get force_duree_eligible value
     * @return int|null
     */
    public function getForce_duree_eligible()
    {
        return $this->force_duree_eligible;
    }
    /**
     * Set force_duree_eligible value
     * @param int $force_duree_eligible
     * @return \StructType\Input
     */
    public function setForce_duree_eligible($force_duree_eligible = null)
    {
        // validation for constraint: int
        if (!is_null($force_duree_eligible) && !(is_int($force_duree_eligible) || ctype_digit($force_duree_eligible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($force_duree_eligible, true), gettype($force_duree_eligible)), __LINE__);
        }
        $this->force_duree_eligible = $force_duree_eligible;
        return $this;
    }
    /**
     * Get type_contrat value
     * @return string|null
     */
    public function getType_contrat()
    {
        return $this->type_contrat;
    }
    /**
     * Set type_contrat value
     * @param string $type_contrat
     * @return \StructType\Input
     */
    public function setType_contrat($type_contrat = null)
    {
        // validation for constraint: string
        if (!is_null($type_contrat) && !is_string($type_contrat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_contrat, true), gettype($type_contrat)), __LINE__);
        }
        $this->type_contrat = $type_contrat;
        return $this;
    }
    /**
     * Get caisse_code value
     * @return string|null
     */
    public function getCaisse_code()
    {
        return $this->caisse_code;
    }
    /**
     * Set caisse_code value
     * @param string $caisse_code
     * @return \StructType\Input
     */
    public function setCaisse_code($caisse_code = null)
    {
        // validation for constraint: string
        if (!is_null($caisse_code) && !is_string($caisse_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caisse_code, true), gettype($caisse_code)), __LINE__);
        }
        $this->caisse_code = $caisse_code;
        return $this;
    }
    /**
     * Get ignore_check_vehicule_exist value
     * @return bool|null
     */
    public function getIgnore_check_vehicule_exist()
    {
        return $this->ignore_check_vehicule_exist;
    }
    /**
     * Set ignore_check_vehicule_exist value
     * @param bool $ignore_check_vehicule_exist
     * @return \StructType\Input
     */
    public function setIgnore_check_vehicule_exist($ignore_check_vehicule_exist = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignore_check_vehicule_exist) && !is_bool($ignore_check_vehicule_exist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignore_check_vehicule_exist, true), gettype($ignore_check_vehicule_exist)), __LINE__);
        }
        $this->ignore_check_vehicule_exist = $ignore_check_vehicule_exist;
        return $this;
    }
    /**
     * Get montant_malus value
     * @return float|null
     */
    public function getMontant_malus()
    {
        return $this->montant_malus;
    }
    /**
     * Set montant_malus value
     * @param float $montant_malus
     * @return \StructType\Input
     */
    public function setMontant_malus($montant_malus = null)
    {
        // validation for constraint: float
        if (!is_null($montant_malus) && !(is_float($montant_malus) || is_numeric($montant_malus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant_malus, true), gettype($montant_malus)), __LINE__);
        }
        $this->montant_malus = $montant_malus;
        return $this;
    }
    /**
     * Get frais_ww value
     * @return float|null
     */
    public function getFrais_ww()
    {
        return $this->frais_ww;
    }
    /**
     * Set frais_ww value
     * @param float $frais_ww
     * @return \StructType\Input
     */
    public function setFrais_ww($frais_ww = null)
    {
        // validation for constraint: float
        if (!is_null($frais_ww) && !(is_float($frais_ww) || is_numeric($frais_ww))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_ww, true), gettype($frais_ww)), __LINE__);
        }
        $this->frais_ww = $frais_ww;
        return $this;
    }
    /**
     * Get frais_custom_carte_grise value
     * @return float|null
     */
    public function getFrais_custom_carte_grise()
    {
        return $this->frais_custom_carte_grise;
    }
    /**
     * Set frais_custom_carte_grise value
     * @param float $frais_custom_carte_grise
     * @return \StructType\Input
     */
    public function setFrais_custom_carte_grise($frais_custom_carte_grise = null)
    {
        // validation for constraint: float
        if (!is_null($frais_custom_carte_grise) && !(is_float($frais_custom_carte_grise) || is_numeric($frais_custom_carte_grise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frais_custom_carte_grise, true), gettype($frais_custom_carte_grise)), __LINE__);
        }
        $this->frais_custom_carte_grise = $frais_custom_carte_grise;
        return $this;
    }
    /**
     * Get override_taux_valeur_rachat value
     * @return float|null
     */
    public function getOverride_taux_valeur_rachat()
    {
        return $this->override_taux_valeur_rachat;
    }
    /**
     * Set override_taux_valeur_rachat value
     * @param float $override_taux_valeur_rachat
     * @return \StructType\Input
     */
    public function setOverride_taux_valeur_rachat($override_taux_valeur_rachat = null)
    {
        // validation for constraint: float
        if (!is_null($override_taux_valeur_rachat) && !(is_float($override_taux_valeur_rachat) || is_numeric($override_taux_valeur_rachat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($override_taux_valeur_rachat, true), gettype($override_taux_valeur_rachat)), __LINE__);
        }
        $this->override_taux_valeur_rachat = $override_taux_valeur_rachat;
        return $this;
    }
    /**
     * Get type_locataire value
     * @return string|null
     */
    public function getType_locataire()
    {
        return $this->type_locataire;
    }
    /**
     * Set type_locataire value
     * @param string $type_locataire
     * @return \StructType\Input
     */
    public function setType_locataire($type_locataire = null)
    {
        // validation for constraint: string
        if (!is_null($type_locataire) && !is_string($type_locataire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_locataire, true), gettype($type_locataire)), __LINE__);
        }
        $this->type_locataire = $type_locataire;
        return $this;
    }
    /**
     * Get type_colocataire value
     * @return string|null
     */
    public function getType_colocataire()
    {
        return $this->type_colocataire;
    }
    /**
     * Set type_colocataire value
     * @param string $type_colocataire
     * @return \StructType\Input
     */
    public function setType_colocataire($type_colocataire = null)
    {
        // validation for constraint: string
        if (!is_null($type_colocataire) && !is_string($type_colocataire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_colocataire, true), gettype($type_colocataire)), __LINE__);
        }
        $this->type_colocataire = $type_colocataire;
        return $this;
    }
    /**
     * Get date_mise_circulation value
     * @return string|null
     */
    public function getDate_mise_circulation()
    {
        return $this->date_mise_circulation;
    }
    /**
     * Set date_mise_circulation value
     * @param string $date_mise_circulation
     * @return \StructType\Input
     */
    public function setDate_mise_circulation($date_mise_circulation = null)
    {
        // validation for constraint: string
        if (!is_null($date_mise_circulation) && !is_string($date_mise_circulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_mise_circulation, true), gettype($date_mise_circulation)), __LINE__);
        }
        $this->date_mise_circulation = $date_mise_circulation;
        return $this;
    }
    /**
     * Get kilometrage_initial value
     * @return int|null
     */
    public function getKilometrage_initial()
    {
        return $this->kilometrage_initial;
    }
    /**
     * Set kilometrage_initial value
     * @param int $kilometrage_initial
     * @return \StructType\Input
     */
    public function setKilometrage_initial($kilometrage_initial = null)
    {
        // validation for constraint: int
        if (!is_null($kilometrage_initial) && !(is_int($kilometrage_initial) || ctype_digit($kilometrage_initial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometrage_initial, true), gettype($kilometrage_initial)), __LINE__);
        }
        $this->kilometrage_initial = $kilometrage_initial;
        return $this;
    }
    /**
     * Get type_dossier value
     * @return string|null
     */
    public function getType_dossier()
    {
        return $this->type_dossier;
    }
    /**
     * Set type_dossier value
     * @param string $type_dossier
     * @return \StructType\Input
     */
    public function setType_dossier($type_dossier = null)
    {
        // validation for constraint: string
        if (!is_null($type_dossier) && !is_string($type_dossier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type_dossier, true), gettype($type_dossier)), __LINE__);
        }
        $this->type_dossier = $type_dossier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Input
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
