<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoUser StructType
 * @subpackage Structs
 */
class InfoUser extends AbstractStructBase
{
    /**
     * The Retour_XML
     * @var string
     */
    public $Retour_XML;
    /**
     * Constructor method for InfoUser
     * @uses InfoUser::setRetour_XML()
     * @param string $retour_XML
     */
    public function __construct($retour_XML = null)
    {
        $this
            ->setRetour_XML($retour_XML);
    }
    /**
     * Get Retour_XML value
     * @return string|null
     */
    public function getRetour_XML()
    {
        return $this->Retour_XML;
    }
    /**
     * Set Retour_XML value
     * @param string $retour_XML
     * @return \StructType\InfoUser
     */
    public function setRetour_XML($retour_XML = null)
    {
        // validation for constraint: string
        if (!is_null($retour_XML) && !is_string($retour_XML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retour_XML, true), gettype($retour_XML)), __LINE__);
        }
        $this->Retour_XML = $retour_XML;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
