<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EtapeDepotItem StructType
 * @subpackage Structs
 */
class EtapeDepotItem extends AbstractStructBase
{
    /**
     * The user_siret
     * @var string
     */
    public $user_siret;
    /**
     * The user_login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $user_login;
    /**
     * The user_mail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $user_mail;
    /**
     * The action
     * @var string
     */
    public $action;
    /**
     * The contexte
     * @var string
     */
    public $contexte;
    /**
     * The norejet
     * @var string
     */
    public $norejet;
    /**
     * The ordre
     * @var int
     */
    public $ordre;
    /**
     * The page
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $page;
    /**
     * The x
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $x;
    /**
     * The y
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $y;
    /**
     * Constructor method for EtapeDepotItem
     * @uses EtapeDepotItem::setUser_siret()
     * @uses EtapeDepotItem::setUser_login()
     * @uses EtapeDepotItem::setUser_mail()
     * @uses EtapeDepotItem::setAction()
     * @uses EtapeDepotItem::setContexte()
     * @uses EtapeDepotItem::setNorejet()
     * @uses EtapeDepotItem::setOrdre()
     * @uses EtapeDepotItem::setPage()
     * @uses EtapeDepotItem::setX()
     * @uses EtapeDepotItem::setY()
     * @param string $user_siret
     * @param string $user_login
     * @param string $user_mail
     * @param string $action
     * @param string $contexte
     * @param string $norejet
     * @param int $ordre
     * @param string $page
     * @param int $x
     * @param int $y
     */
    public function __construct($user_siret = null, $user_login = null, $user_mail = null, $action = null, $contexte = null, $norejet = null, $ordre = null, $page = null, $x = null, $y = null)
    {
        $this
            ->setUser_siret($user_siret)
            ->setUser_login($user_login)
            ->setUser_mail($user_mail)
            ->setAction($action)
            ->setContexte($contexte)
            ->setNorejet($norejet)
            ->setOrdre($ordre)
            ->setPage($page)
            ->setX($x)
            ->setY($y);
    }
    /**
     * Get user_siret value
     * @return string|null
     */
    public function getUser_siret()
    {
        return $this->user_siret;
    }
    /**
     * Set user_siret value
     * @param string $user_siret
     * @return \StructType\EtapeDepotItem
     */
    public function setUser_siret($user_siret = null)
    {
        // validation for constraint: string
        if (!is_null($user_siret) && !is_string($user_siret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_siret, true), gettype($user_siret)), __LINE__);
        }
        $this->user_siret = $user_siret;
        return $this;
    }
    /**
     * Get user_login value
     * @return string|null
     */
    public function getUser_login()
    {
        return $this->user_login;
    }
    /**
     * Set user_login value
     * @param string $user_login
     * @return \StructType\EtapeDepotItem
     */
    public function setUser_login($user_login = null)
    {
        // validation for constraint: string
        if (!is_null($user_login) && !is_string($user_login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_login, true), gettype($user_login)), __LINE__);
        }
        $this->user_login = $user_login;
        return $this;
    }
    /**
     * Get user_mail value
     * @return string|null
     */
    public function getUser_mail()
    {
        return $this->user_mail;
    }
    /**
     * Set user_mail value
     * @param string $user_mail
     * @return \StructType\EtapeDepotItem
     */
    public function setUser_mail($user_mail = null)
    {
        // validation for constraint: string
        if (!is_null($user_mail) && !is_string($user_mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user_mail, true), gettype($user_mail)), __LINE__);
        }
        $this->user_mail = $user_mail;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \StructType\EtapeDepotItem
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get contexte value
     * @return string|null
     */
    public function getContexte()
    {
        return $this->contexte;
    }
    /**
     * Set contexte value
     * @param string $contexte
     * @return \StructType\EtapeDepotItem
     */
    public function setContexte($contexte = null)
    {
        // validation for constraint: string
        if (!is_null($contexte) && !is_string($contexte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contexte, true), gettype($contexte)), __LINE__);
        }
        $this->contexte = $contexte;
        return $this;
    }
    /**
     * Get norejet value
     * @return string|null
     */
    public function getNorejet()
    {
        return $this->norejet;
    }
    /**
     * Set norejet value
     * @param string $norejet
     * @return \StructType\EtapeDepotItem
     */
    public function setNorejet($norejet = null)
    {
        // validation for constraint: string
        if (!is_null($norejet) && !is_string($norejet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($norejet, true), gettype($norejet)), __LINE__);
        }
        $this->norejet = $norejet;
        return $this;
    }
    /**
     * Get ordre value
     * @return int|null
     */
    public function getOrdre()
    {
        return $this->ordre;
    }
    /**
     * Set ordre value
     * @param int $ordre
     * @return \StructType\EtapeDepotItem
     */
    public function setOrdre($ordre = null)
    {
        // validation for constraint: int
        if (!is_null($ordre) && !(is_int($ordre) || ctype_digit($ordre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordre, true), gettype($ordre)), __LINE__);
        }
        $this->ordre = $ordre;
        return $this;
    }
    /**
     * Get page value
     * @return string|null
     */
    public function getPage()
    {
        return $this->page;
    }
    /**
     * Set page value
     * @param string $page
     * @return \StructType\EtapeDepotItem
     */
    public function setPage($page = null)
    {
        // validation for constraint: string
        if (!is_null($page) && !is_string($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->page = $page;
        return $this;
    }
    /**
     * Get x value
     * @return int|null
     */
    public function getX()
    {
        return $this->x;
    }
    /**
     * Set x value
     * @param int $x
     * @return \StructType\EtapeDepotItem
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !(is_int($x) || ctype_digit($x))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x, true), gettype($x)), __LINE__);
        }
        $this->x = $x;
        return $this;
    }
    /**
     * Get y value
     * @return int|null
     */
    public function getY()
    {
        return $this->y;
    }
    /**
     * Set y value
     * @param int $y
     * @return \StructType\EtapeDepotItem
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !(is_int($y) || ctype_digit($y))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($y, true), gettype($y)), __LINE__);
        }
        $this->y = $y;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EtapeDepotItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
