<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnexeItem StructType
 * @subpackage Structs
 */
class AnnexeItem extends AbstractStructBase
{
    /**
     * The nom
     * @var string
     */
    public $nom;
    /**
     * The contenu
     * @var string
     */
    public $contenu;
    /**
     * The taille
     * @var int
     */
    public $taille;
    /**
     * Constructor method for AnnexeItem
     * @uses AnnexeItem::setNom()
     * @uses AnnexeItem::setContenu()
     * @uses AnnexeItem::setTaille()
     * @param string $nom
     * @param string $contenu
     * @param int $taille
     */
    public function __construct($nom = null, $contenu = null, $taille = null)
    {
        $this
            ->setNom($nom)
            ->setContenu($contenu)
            ->setTaille($taille);
    }
    /**
     * Get nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->nom;
    }
    /**
     * Set nom value
     * @param string $nom
     * @return \StructType\AnnexeItem
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->nom = $nom;
        return $this;
    }
    /**
     * Get contenu value
     * @return string|null
     */
    public function getContenu()
    {
        return $this->contenu;
    }
    /**
     * Set contenu value
     * @param string $contenu
     * @return \StructType\AnnexeItem
     */
    public function setContenu($contenu = null)
    {
        // validation for constraint: string
        if (!is_null($contenu) && !is_string($contenu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contenu, true), gettype($contenu)), __LINE__);
        }
        $this->contenu = $contenu;
        return $this;
    }
    /**
     * Get taille value
     * @return int|null
     */
    public function getTaille()
    {
        return $this->taille;
    }
    /**
     * Set taille value
     * @param int $taille
     * @return \StructType\AnnexeItem
     */
    public function setTaille($taille = null)
    {
        // validation for constraint: int
        if (!is_null($taille) && !(is_int($taille) || ctype_digit($taille))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taille, true), gettype($taille)), __LINE__);
        }
        $this->taille = $taille;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnexeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
