<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adminItem StructType
 * @subpackage Structs
 */
class AdminItem extends AbstractStructBase
{
    /**
     * The uidSPL
     * @var string
     */
    public $uidSPL;
    /**
     * The service
     * @var string
     */
    public $service;
    /**
     * The scenario
     * @var string
     */
    public $scenario;
    /**
     * The delegation
     * @var string
     */
    public $delegation;
    /**
     * Constructor method for adminItem
     * @uses AdminItem::setUidSPL()
     * @uses AdminItem::setService()
     * @uses AdminItem::setScenario()
     * @uses AdminItem::setDelegation()
     * @param string $uidSPL
     * @param string $service
     * @param string $scenario
     * @param string $delegation
     */
    public function __construct($uidSPL = null, $service = null, $scenario = null, $delegation = null)
    {
        $this
            ->setUidSPL($uidSPL)
            ->setService($service)
            ->setScenario($scenario)
            ->setDelegation($delegation);
    }
    /**
     * Get uidSPL value
     * @return string|null
     */
    public function getUidSPL()
    {
        return $this->uidSPL;
    }
    /**
     * Set uidSPL value
     * @param string $uidSPL
     * @return \StructType\AdminItem
     */
    public function setUidSPL($uidSPL = null)
    {
        // validation for constraint: string
        if (!is_null($uidSPL) && !is_string($uidSPL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uidSPL, true), gettype($uidSPL)), __LINE__);
        }
        $this->uidSPL = $uidSPL;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\AdminItem
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get scenario value
     * @return string|null
     */
    public function getScenario()
    {
        return $this->scenario;
    }
    /**
     * Set scenario value
     * @param string $scenario
     * @return \StructType\AdminItem
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        $this->scenario = $scenario;
        return $this;
    }
    /**
     * Get delegation value
     * @return string|null
     */
    public function getDelegation()
    {
        return $this->delegation;
    }
    /**
     * Set delegation value
     * @param string $delegation
     * @return \StructType\AdminItem
     */
    public function setDelegation($delegation = null)
    {
        // validation for constraint: string
        if (!is_null($delegation) && !is_string($delegation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delegation, true), gettype($delegation)), __LINE__);
        }
        $this->delegation = $delegation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdminItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
