<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFS ServiceType
 * @subpackage Services
 */
class XPRFS extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_Supprimer
     * Meta information extracted from the WSDL
     * - documentation: Supprime les depots non debutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Supprimer_Param $params
     * @return \StructType\InfoUser|bool
     */
    public function XPRF_Supprimer(\StructType\XPRF_Supprimer_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Supprimer($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InfoUser
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
