<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFI ServiceType
 * @subpackage Services
 */
class XPRFI extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_Initialisation_Deposer
     * Meta information extracted from the WSDL
     * - documentation: Liste des encours viseur ou signataire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Initialisation_Deposer_Param $params
     * @return \StructType\InfoUser|bool
     */
    public function XPRF_Initialisation_Deposer(\StructType\XPRF_Initialisation_Deposer_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Initialisation_Deposer($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InfoUser
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
