<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFG ServiceType
 * @subpackage Services
 */
class XPRFG extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_GetListFavoris
     * Meta information extracted from the WSDL
     * - documentation: Permet de récupérer la liste des favoris pour un agent pour un scénario donné
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_GetListFavoris_Param $params
     * @return string|bool
     */
    public function XPRF_GetListFavoris(\StructType\XPRF_GetListFavoris_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_GetListFavoris($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_GetInfosFavori
     * Meta information extracted from the WSDL
     * - documentation: Permet de récupérer les informations d'un favori pour un agent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_GetInfosFavori_Param $params
     * @return string|bool
     */
    public function XPRF_GetInfosFavori(\StructType\XPRF_GetInfosFavori_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_GetInfosFavori($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
