<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFD ServiceType
 * @subpackage Services
 */
class XPRFD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_Deposer
     * Meta information extracted from the WSDL
     * - documentation: Depot dans le parapheur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Deposer_Param $params
     * @return \StructType\InfoUserDepot|bool
     */
    public function XPRF_Deposer(\StructType\XPRF_Deposer_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Deposer($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_Detail_Depot
     * Meta information extracted from the WSDL
     * - documentation: Vise les fichiers des depots
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Detail_Depot_Param $params
     * @return \StructType\InfoUser|bool
     */
    public function XPRF_Detail_Depot(\StructType\XPRF_Detail_Depot_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Detail_Depot($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_Droits_Scenario
     * Meta information extracted from the WSDL
     * - documentation: Profil utilisateur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_Droits_Scenario_Param $params
     * @return string|bool
     */
    public function XPRF_Droits_Scenario(\StructType\XPRF_Droits_Scenario_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_Droits_Scenario($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\InfoUser|\StructType\InfoUserDepot
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
