<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRF ServiceType
 * @subpackage Services
 */
class XPRF extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_getVip
     * Meta information extracted from the WSDL
     * - documentation: Permet de demander à Xparaph de compléter les acteurs d'étapes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_getVip_Param $params
     * @return string|bool
     */
    public function XPRF_getVip(\StructType\XPRF_getVip_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_getVip($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_preDepot
     * Meta information extracted from the WSDL
     * - documentation: Permet de demander à Xparaph une url de pré-dépôt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_preDepot_Param $params
     * @return string|bool
     */
    public function XPRF_preDepot(\StructType\XPRF_preDepot_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_preDepot($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_getInfosAgent
     * Meta information extracted from the WSDL
     * - documentation: Permet de demander à Xparaph les informations sur un agent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_getInfosAgent_Param $params
     * @return string|bool
     */
    public function XPRF_getInfosAgent(\StructType\XPRF_getInfosAgent_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_getInfosAgent($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_insertOrUpdateUser
     * Meta information extracted from the WSDL
     * - documentation: Permet d'ajouter ou mettre un jour un compte utilisateur Xparaph
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_insertOrUpdateUser_Param $params
     * @return string|bool
     */
    public function XPRF_insertOrUpdateUser(\StructType\XPRF_insertOrUpdateUser_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_insertOrUpdateUser($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XPRF_getFiles
     * Meta information extracted from the WSDL
     * - documentation: Permet de récupérer le zip de sortie de dépot quand le scénario est terminé
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_getFiles_Param $params
     * @return string|bool
     */
    public function XPRF_getFiles(\StructType\XPRF_getFiles_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_getFiles($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
