<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPRF_ParamColl_Param StructType
 * @subpackage Structs
 */
class XPRF_ParamColl_Param extends AbstractStructBase
{
    /**
     * The key
     * @var string
     */
    public $key;
    /**
     * The siret
     * @var string
     */
    public $siret;
    /**
     * The action
     * @var string
     */
    public $action;
    /**
     * The infosColl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TabInfosColl
     */
    public $infosColl;
    /**
     * The admins
     * Meta information extracted from the WSDL
     * - arrayType: tns:adminItem[]
     * - base: SOAP-ENC:Array
     * - minOccurs: 0
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\AdminItem[]
     */
    public $admins;
    /**
     * Constructor method for XPRF_ParamColl_Param
     * @uses XPRF_ParamColl_Param::setKey()
     * @uses XPRF_ParamColl_Param::setSiret()
     * @uses XPRF_ParamColl_Param::setAction()
     * @uses XPRF_ParamColl_Param::setInfosColl()
     * @uses XPRF_ParamColl_Param::setAdmins()
     * @param string $key
     * @param string $siret
     * @param string $action
     * @param \StructType\TabInfosColl $infosColl
     * @param \StructType\AdminItem[] $admins
     */
    public function __construct($key = null, $siret = null, $action = null, \StructType\TabInfosColl $infosColl = null, array $admins = array())
    {
        $this
            ->setKey($key)
            ->setSiret($siret)
            ->setAction($action)
            ->setInfosColl($infosColl)
            ->setAdmins($admins);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get siret value
     * @return string|null
     */
    public function getSiret()
    {
        return $this->siret;
    }
    /**
     * Set siret value
     * @param string $siret
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function setSiret($siret = null)
    {
        // validation for constraint: string
        if (!is_null($siret) && !is_string($siret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siret, true), gettype($siret)), __LINE__);
        }
        $this->siret = $siret;
        return $this;
    }
    /**
     * Get action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get infosColl value
     * @return \StructType\TabInfosColl|null
     */
    public function getInfosColl()
    {
        return $this->infosColl;
    }
    /**
     * Set infosColl value
     * @param \StructType\TabInfosColl $infosColl
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function setInfosColl(\StructType\TabInfosColl $infosColl = null)
    {
        $this->infosColl = $infosColl;
        return $this;
    }
    /**
     * Get admins value
     * @return \StructType\AdminItem[]|null
     */
    public function getAdmins()
    {
        return $this->admins;
    }
    /**
     * This method is responsible for validating the values passed to the setAdmins method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdmins method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdminsForArrayConstraintsFromSetAdmins(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xPRF_ParamColl_ParamAdminsItem) {
            // validation for constraint: itemType
            if (!$xPRF_ParamColl_ParamAdminsItem instanceof \StructType\AdminItem) {
                $invalidValues[] = is_object($xPRF_ParamColl_ParamAdminsItem) ? get_class($xPRF_ParamColl_ParamAdminsItem) : sprintf('%s(%s)', gettype($xPRF_ParamColl_ParamAdminsItem), var_export($xPRF_ParamColl_ParamAdminsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The admins property can only contain items of type \StructType\AdminItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set admins value
     * @throws \InvalidArgumentException
     * @param \StructType\AdminItem[] $admins
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function setAdmins(array $admins = array())
    {
        // validation for constraint: array
        if ('' !== ($adminsArrayErrorMessage = self::validateAdminsForArrayConstraintsFromSetAdmins($admins))) {
            throw new \InvalidArgumentException($adminsArrayErrorMessage, __LINE__);
        }
        $this->admins = $admins;
        return $this;
    }
    /**
     * Add item to admins value
     * @throws \InvalidArgumentException
     * @param \StructType\AdminItem $item
     * @return \StructType\XPRF_ParamColl_Param
     */
    public function addToAdmins(\StructType\AdminItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdminItem) {
            throw new \InvalidArgumentException(sprintf('The admins property can only contain items of type \StructType\AdminItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->admins[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XPRF_ParamColl_Param
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
