<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPRF_AvancementDepot_Param StructType
 * @subpackage Structs
 */
class XPRF_AvancementDepot_Param extends AbstractStructBase
{
    /**
     * The siret
     * @var string
     */
    public $siret;
    /**
     * The logingen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $logingen;
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The depotids
     * Meta information extracted from the WSDL
     * - arrayType: xsd:string[]
     * - base: SOAP-ENC:Array
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $depotids;
    /**
     * The withNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $withNote;
    /**
     * Constructor method for XPRF_AvancementDepot_Param
     * @uses XPRF_AvancementDepot_Param::setSiret()
     * @uses XPRF_AvancementDepot_Param::setLogingen()
     * @uses XPRF_AvancementDepot_Param::setLogin()
     * @uses XPRF_AvancementDepot_Param::setPassword()
     * @uses XPRF_AvancementDepot_Param::setDepotids()
     * @uses XPRF_AvancementDepot_Param::setWithNote()
     * @param string $siret
     * @param string $logingen
     * @param string $login
     * @param string $password
     * @param string[] $depotids
     * @param string $withNote
     */
    public function __construct($siret = null, $logingen = null, $login = null, $password = null, array $depotids = array(), $withNote = null)
    {
        $this
            ->setSiret($siret)
            ->setLogingen($logingen)
            ->setLogin($login)
            ->setPassword($password)
            ->setDepotids($depotids)
            ->setWithNote($withNote);
    }
    /**
     * Get siret value
     * @return string|null
     */
    public function getSiret()
    {
        return $this->siret;
    }
    /**
     * Set siret value
     * @param string $siret
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setSiret($siret = null)
    {
        // validation for constraint: string
        if (!is_null($siret) && !is_string($siret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siret, true), gettype($siret)), __LINE__);
        }
        $this->siret = $siret;
        return $this;
    }
    /**
     * Get logingen value
     * @return string|null
     */
    public function getLogingen()
    {
        return $this->logingen;
    }
    /**
     * Set logingen value
     * @param string $logingen
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setLogingen($logingen = null)
    {
        // validation for constraint: string
        if (!is_null($logingen) && !is_string($logingen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logingen, true), gettype($logingen)), __LINE__);
        }
        $this->logingen = $logingen;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get depotids value
     * @return string[]|null
     */
    public function getDepotids()
    {
        return $this->depotids;
    }
    /**
     * This method is responsible for validating the values passed to the setDepotids method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepotids method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepotidsForArrayConstraintsFromSetDepotids(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $xPRF_AvancementDepot_ParamDepotidsItem) {
            // validation for constraint: itemType
            if (!is_string($xPRF_AvancementDepot_ParamDepotidsItem)) {
                $invalidValues[] = is_object($xPRF_AvancementDepot_ParamDepotidsItem) ? get_class($xPRF_AvancementDepot_ParamDepotidsItem) : sprintf('%s(%s)', gettype($xPRF_AvancementDepot_ParamDepotidsItem), var_export($xPRF_AvancementDepot_ParamDepotidsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The depotids property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set depotids value
     * @throws \InvalidArgumentException
     * @param string[] $depotids
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setDepotids(array $depotids = array())
    {
        // validation for constraint: array
        if ('' !== ($depotidsArrayErrorMessage = self::validateDepotidsForArrayConstraintsFromSetDepotids($depotids))) {
            throw new \InvalidArgumentException($depotidsArrayErrorMessage, __LINE__);
        }
        $this->depotids = $depotids;
        return $this;
    }
    /**
     * Add item to depotids value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function addToDepotids($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The depotids property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->depotids[] = $item;
        return $this;
    }
    /**
     * Get withNote value
     * @return string|null
     */
    public function getWithNote()
    {
        return $this->withNote;
    }
    /**
     * Set withNote value
     * @param string $withNote
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public function setWithNote($withNote = null)
    {
        // validation for constraint: string
        if (!is_null($withNote) && !is_string($withNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($withNote, true), gettype($withNote)), __LINE__);
        }
        $this->withNote = $withNote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XPRF_AvancementDepot_Param
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
