<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoUserDepot StructType
 * @subpackage Structs
 */
class InfoUserDepot extends AbstractStructBase
{
    /**
     * The Retour_XML
     * @var string
     */
    public $Retour_XML;
    /**
     * The depotid
     * @var string
     */
    public $depotid;
    /**
     * Constructor method for InfoUserDepot
     * @uses InfoUserDepot::setRetour_XML()
     * @uses InfoUserDepot::setDepotid()
     * @param string $retour_XML
     * @param string $depotid
     */
    public function __construct($retour_XML = null, $depotid = null)
    {
        $this
            ->setRetour_XML($retour_XML)
            ->setDepotid($depotid);
    }
    /**
     * Get Retour_XML value
     * @return string|null
     */
    public function getRetour_XML()
    {
        return $this->Retour_XML;
    }
    /**
     * Set Retour_XML value
     * @param string $retour_XML
     * @return \StructType\InfoUserDepot
     */
    public function setRetour_XML($retour_XML = null)
    {
        // validation for constraint: string
        if (!is_null($retour_XML) && !is_string($retour_XML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retour_XML, true), gettype($retour_XML)), __LINE__);
        }
        $this->Retour_XML = $retour_XML;
        return $this;
    }
    /**
     * Get depotid value
     * @return string|null
     */
    public function getDepotid()
    {
        return $this->depotid;
    }
    /**
     * Set depotid value
     * @param string $depotid
     * @return \StructType\InfoUserDepot
     */
    public function setDepotid($depotid = null)
    {
        // validation for constraint: string
        if (!is_null($depotid) && !is_string($depotid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depotid, true), gettype($depotid)), __LINE__);
        }
        $this->depotid = $depotid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoUserDepot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
