<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for XPRFP ServiceType
 * @subpackage Services
 */
class XPRFP extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XPRF_ParamColl
     * Meta information extracted from the WSDL
     * - documentation: Modif ou update des params de collectivite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XPRF_ParamColl_Param $params
     * @return string|bool
     */
    public function XPRF_ParamColl(\StructType\XPRF_ParamColl_Param $params)
    {
        try {
            $this->setResult($this->getSoapClient()->XPRF_ParamColl($params));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
